/*
 * Decompiled with CFR 0.152.
 */
package tico.interpreter.actions;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.SwingUtilities;
import tico.components.resources.TResourceManager;
import tico.configuration.TLanguage;
import tico.interpreter.TInterpreter;
import tico.interpreter.TInterpreterConstants;
import tico.interpreter.TInterpreterProject;
import tico.interpreter.actions.TInterpreterAbstractAction;
import tico.interpreter.components.TInterpreterCell;
import tico.interpreter.listeners.TBoardListener;
import tico.interpreter.threads.TInterpreterBoardSound;
import tico.interpreter.threads.TThreads;

public class TInterpreterRun
extends TInterpreterAbstractAction
implements ActionListener,
Runnable {
    public TInterpreterRun(TInterpreter interpreter) {
        super(interpreter, TLanguage.getString("TInterpreterRunAction.NAME"), TResourceManager.getImageIcon("run.gif"));
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        this.interpreter = this.getInterpreter();
        try {
            TInterpreterConstants.semaforo.releaseWhenStop();
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        TInterpreter.interpretationThread = new TThreads(this);
        TInterpreter.interpretationThread.start();
    }

    @Override
    public void run() {
        String mouseMode = TInterpreter.returnMouseMode();
        TInterpreter.run = 1;
        this.interpreter.TIntepreterChangeCursor();
        TInterpreterProject project = this.interpreter.getProject();
        TInterpreterConstants.currentBoard = project.getBoard(project.getBoardToGo());
        project.setBoardChanged(false);
        if (TInterpreterConstants.currentBoard.getSoundFile() != null) {
            TInterpreterBoardSound boardSound = new TInterpreterBoardSound(TInterpreterConstants.currentBoard.getSoundFile());
            boardSound.run();
        }
        if (mouseMode.equals("manualScanningMode")) {
            this.interpreter.interpreterRobot.setAutoDelay(0);
            TInterpreter.boardListener = new TBoardListener(this.interpreter);
            TInterpreter.interpretAreaBackground.addMouseListener(TInterpreter.boardListener);
            TInterpreter.accumulatedCells.addMouseListener(TInterpreter.boardListener);
        }
        if (mouseMode.equals("automaticScanningMode")) {
            this.interpreter.interpreterRobot.setAutoDelay(TInterpreterConstants.interpreterDelay);
            if (TInterpreterConstants.currentBoard.getOrderedCellListNames().size() != 0) {
                int posInicioBarrido;
                TInterpreterConstants.boardOrderedCells = TInterpreterConstants.currentBoard.getOrderedCellListNames();
                TInterpreterConstants.countRun = posInicioBarrido = this.interpreter.getProject().getPositionCellToReturn();
                while (TInterpreterConstants.countRun < TInterpreterConstants.currentBoard.getOrderedCellListNames().size() && TInterpreter.run == 1) {
                    try {
                        Thread.sleep(5L);
                    }
                    catch (InterruptedException e2) {
                        e2.printStackTrace();
                    }
                    try {
                        TInterpreterConstants.semaforo.acquire();
                    }
                    catch (InterruptedException e3) {
                        e3.printStackTrace();
                    }
                    if (TInterpreterConstants.currentBoard.getOrderedCellListNames().size() == 0) {
                        TInterpreter.run = 0;
                    } else {
                        TInterpreterCell cell = TInterpreterConstants.currentBoard.getCellByName(TInterpreterConstants.boardOrderedCells.get(TInterpreterConstants.countRun));
                        Point point = cell.getLocation();
                        SwingUtilities.convertPointToScreen(point, TInterpreter.interpretArea);
                        cell.setCenter(new Point(point.x + cell.getWidth() / 2, point.y + cell.getHeight() / 2));
                        TInterpreterConstants.x = cell.getCenter().x - 1;
                        TInterpreterConstants.y = cell.getCenter().y - 1;
                        this.interpreter.interpreterRobot.mouseMove(cell.getCenter().x, cell.getCenter().y);
                        if (++TInterpreterConstants.countRun == TInterpreterConstants.currentBoard.getOrderedCellListNames().size()) {
                            TInterpreterConstants.countRun = 0;
                        }
                    }
                    try {
                        TInterpreterConstants.semaforo.release();
                    }
                    catch (InterruptedException e4) {
                        e4.printStackTrace();
                    }
                }
            }
        }
    }
}

