/*
 * Decompiled with CFR 0.152.
 */
package tico.interpreter.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.JLabel;
import tico.components.resources.TFileUtils;
import tico.configuration.TLanguage;
import tico.configuration.TSetup;
import tico.interpreter.TInterpreter;
import tico.interpreter.actions.TInterpreterAbstractAction;
import tico.interpreter.components.TInterpreterAccumulatedCell;
import tico.interpreter.threads.TInterpreterGoogleTTS;
import tico.interpreter.threads.TInterpreterMidSound;
import tico.interpreter.threads.TInterpreterMp3Sound;
import tico.interpreter.threads.TInterpreterTTS;
import tico.interpreter.threads.TInterpreterWavSound;

public class TInterpreterReadAction
extends TInterpreterAbstractAction {
    TInterpreterWavSound nAudio = null;
    TInterpreterMp3Sound nMp3Audio = null;
    TInterpreterMidSound nMidAudio = null;

    public TInterpreterReadAction(TInterpreter interpreter) {
        super(interpreter, TLanguage.getString("TInterpreterRead.NAME"));
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        TInterpreterAccumulatedCell ac2;
        if (!System.getProperty("os.name").startsWith("Windows")) {
            return;
        }
        this.interpreter = this.getInterpreter();
        if (this.nMp3Audio != null) {
            this.nMp3Audio.TJoin();
        }
        if (this.nAudio != null) {
            try {
                this.nAudio.join();
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
        }
        if (this.nMidAudio != null) {
            try {
                this.nMidAudio.join();
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
        }
        int index = 0;
        String accumulatedVoiceText = "";
        index = 0;
        while (index < TInterpreter.accumulatedCellsList.size()) {
            ac2 = (TInterpreterAccumulatedCell)TInterpreter.accumulatedCellsList.get(index);
            String nameSound = ac2.getSound();
            if (nameSound != null) {
                String extension = TFileUtils.getExtension(nameSound);
                if (extension.equals("mp3")) {
                    this.nMp3Audio = new TInterpreterMp3Sound(nameSound);
                    this.nMp3Audio.TPlay();
                    this.nMp3Audio.TJoin();
                } else if (extension.equals("mid") || extension.equals("midi")) {
                    this.nMidAudio = new TInterpreterMidSound(nameSound);
                    this.nMidAudio.start();
                    try {
                        this.nMidAudio.join();
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                } else {
                    this.nAudio = new TInterpreterWavSound(nameSound);
                    this.nAudio.start();
                    try {
                        this.nAudio.join();
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                }
            }
            String voiceText = ac2.getVoiceText();
            int mode = ac2.getSynthMode();
            if (voiceText != null) {
                accumulatedVoiceText = String.valueOf(accumulatedVoiceText) + voiceText + " ";
            }
            ++index;
        }
        if (!accumulatedVoiceText.equals("")) {
            ac2 = (TInterpreterAccumulatedCell)TInterpreter.accumulatedCellsList.get(0);
            int mode = ac2.getSynthMode();
            switch (mode) {
                case 1: {
                    String voiceName = ac2.getVoiceName();
                    if (voiceName == null) {
                        voiceName = this.interpreter.getIntepreterProject().getDefaultVoiceName();
                    }
                    TInterpreterTTS tts = TInterpreterTTS.getInstance();
                    tts.setCurrentVoiceAndText(voiceName, accumulatedVoiceText);
                    tts.run();
                    break;
                }
                case 0: {
                    String voice = TSetup.getLanguageCode();
                    TInterpreterGoogleTTS ttsg = new TInterpreterGoogleTTS();
                    ttsg.setCurrentVoiceAndText(voice, accumulatedVoiceText);
                    ttsg.run();
                }
            }
        }
        if (index == 0) {
            String aLeer = "";
            Component[] componentArray = TInterpreter.interpretArea.getComponents();
            int n2 = componentArray.length;
            int voiceName = 0;
            while (voiceName < n2) {
                Component c2 = componentArray[voiceName];
                if (c2 instanceof JLabel) {
                    aLeer = String.valueOf(aLeer) + " " + ((JLabel)c2).getText();
                }
                ++voiceName;
            }
            String voiceName2 = this.interpreter.getIntepreterProject().getDefaultVoiceName();
            if (voiceName2 != null) {
                TInterpreterTTS tts = TInterpreterTTS.getInstance();
                tts.setCurrentVoiceAndText(voiceName2, aLeer);
                tts.run();
            }
        }
    }
}

