/*
 * Decompiled with CFR 0.152.
 */
package tico.interpreter.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import tico.components.resources.ProjectFilter;
import tico.components.resources.TResourceManager;
import tico.configuration.TLanguage;
import tico.configuration.TSetup;
import tico.editor.TProjectHandler;
import tico.interpreter.TInterpreter;
import tico.interpreter.TInterpreterProject;
import tico.interpreter.actions.TInterpreterAbstractAction;

public class TInterpreterProjectOpenAction
extends TInterpreterAbstractAction {
    private static File defaultDirectory = null;

    public TInterpreterProjectOpenAction(TInterpreter interpreter) {
        super(interpreter, TLanguage.getString("TProjectOpenAction.NAME"), TResourceManager.getImageIcon("archive-open-22.png"));
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogTitle(TLanguage.getString("TProjectOpenAction.OPEN_PROJECT"));
        if (!TSetup.getInterpreterHome().equals("")) {
            defaultDirectory = new File(TSetup.getInterpreterHome());
        }
        fileChooser.setCurrentDirectory(defaultDirectory);
        fileChooser.addChoosableFileFilter(new ProjectFilter());
        fileChooser.setAcceptAllFileFilterUsed(false);
        int returnValue = fileChooser.showOpenDialog(null);
        if (returnValue == 0) {
            this.interpreter.TIntepreterWaitingCursor();
            TInterpreter.accumulatedCells.removeAll();
            TInterpreter.accumulatedCells.updateUI();
            File selectedFile = fileChooser.getSelectedFile();
            defaultDirectory = selectedFile.getParentFile();
            TSetup.setInterpreterHome(selectedFile.getParent().toString());
            try {
                this.getInterpreter().deleteProject();
                TInterpreterProject project = TProjectHandler.loadProjectInterpreter(selectedFile);
                this.getInterpreter().setProject(project);
                TInterpreter.setEnabledActions(true);
                this.getInterpreter().setTitle(String.valueOf(TInterpreter.DEFAULT_TITLE) + " - " + project.getName());
                this.interpreter.TInterpreterRestoreCursor();
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(null, TLanguage.getString("TProjectOpenAction.OPEN_ERROR"), String.valueOf(TLanguage.getString("ERROR")) + "!", 0);
                this.interpreter.TInterpreterRestoreCursor();
            }
        }
    }
}

