/*
 * Decompiled with CFR 0.152.
 */
package tico.interpreter.actions;

import java.awt.AWTEvent;
import java.awt.Dimension;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.swing.JMenuBar;
import javax.swing.JSplitPane;
import tico.configuration.TLanguage;
import tico.interpreter.TInterpreter;
import tico.interpreter.actions.TInterpreterAbstractAction;

public class TInterpreterFullscreenAction
extends TInterpreterAbstractAction {
    private mouseMotionListener mml;
    private Toolkit t;
    Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
    JMenuBar menu;
    JSplitPane sp;
    int dividerLocation;
    int dividerSize;

    public TInterpreterFullscreenAction(TInterpreter interpreter) {
        super(interpreter, TLanguage.getString("TInterpreterFullscreenAction.NAME"));
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        this.interpreter = this.getInterpreter();
        this.switchFullScreen();
    }

    private void switchFullScreen() {
        this.interpreter.setVisible(false);
        this.interpreter.dispose();
        this.sp = TInterpreter.splitPane;
        this.menu = this.interpreter.getJMenuBar();
        if (TInterpreter.fullscreen) {
            this.interpreter.setExtendedState(0);
            this.interpreter.setUndecorated(false);
            this.interpreter.setAlwaysOnTop(false);
            this.sp.setDividerLocation(this.dividerLocation);
            this.sp.setDividerSize(this.dividerSize);
            this.removeMouseListener();
        } else {
            this.dividerLocation = this.sp.getDividerLocation();
            this.dividerSize = this.sp.getDividerSize();
            this.interpreter.setExtendedState(6);
            this.interpreter.setUndecorated(true);
            this.interpreter.setAlwaysOnTop(true);
            this.createMouseListener();
        }
        this.interpreter.setVisible(true);
        TInterpreter.fullscreen = !TInterpreter.fullscreen;
        this.interpreter.repaintCurrentBoard(true);
    }

    private void createMouseListener() {
        this.mml = new mouseMotionListener();
        long eventMask = 32L;
        this.t = Toolkit.getDefaultToolkit();
        this.t.addAWTEventListener(this.mml, eventMask);
    }

    private void removeMouseListener() {
        this.t.removeAWTEventListener(this.mml);
    }

    class mouseMotionListener
    implements AWTEventListener {
        mouseMotionListener() {
        }

        public void mouseMoved(MouseEvent e2) {
            boolean hasSelectedMenu = false;
            int i2 = 0;
            while (i2 < TInterpreterFullscreenAction.this.menu.getMenuCount() && !hasSelectedMenu) {
                if (TInterpreterFullscreenAction.this.menu.getMenu(i2).isSelected()) {
                    hasSelectedMenu = true;
                }
                ++i2;
            }
            Point pos = MouseInfo.getPointerInfo().getLocation();
            if (!hasSelectedMenu) {
                if (TInterpreterFullscreenAction.this.menu.isVisible()) {
                    TInterpreterFullscreenAction.this.menu.setVisible(pos.y < TInterpreterFullscreenAction.this.menu.getHeight());
                } else {
                    TInterpreterFullscreenAction.this.menu.setVisible(pos.y < 5);
                }
            }
            if (pos.y > TInterpreterFullscreenAction.this.screenSize.height - 15) {
                TInterpreterFullscreenAction.this.sp.setDividerLocation(TInterpreterFullscreenAction.this.screenSize.height - 100);
                TInterpreterFullscreenAction.this.sp.setDividerSize(5);
            } else if (pos.y < TInterpreterFullscreenAction.this.screenSize.height - 100) {
                TInterpreterFullscreenAction.this.sp.setDividerLocation(TInterpreterFullscreenAction.this.screenSize.height - 5);
                TInterpreterFullscreenAction.this.sp.setDividerSize(0);
            }
        }

        @Override
        public void eventDispatched(AWTEvent event) {
            this.mouseMoved((MouseEvent)event);
        }
    }
}

