/*
 * Decompiled with CFR 0.152.
 */
package tico.interpreter;

import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.ImageIcon;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import tico.configuration.TLanguage;
import tico.editor.TFileHandler;
import tico.editor.TProjectHandler;
import tico.interpreter.TInterpreterBoard;
import tico.interpreter.components.TInterpreterCell;
import tico.interpreter.components.TInterpreterLabel;
import tico.interpreter.components.TInterpreterLine;
import tico.interpreter.components.TInterpreterOval;
import tico.interpreter.components.TInterpreterRectangle;
import tico.interpreter.components.TInterpreterRoundRectangle;
import tico.interpreter.components.TInterpreterTextArea;
import tico.interpreter.listeners.TCellListener;
import tico.interpreter.listeners.TCopyCellListener;
import tico.interpreter.listeners.TExitCellListener;
import tico.interpreter.listeners.THomeCellListener;
import tico.interpreter.listeners.TReadCellListener;
import tico.interpreter.listeners.TReturnCellListener;
import tico.interpreter.listeners.TStopCellListener;
import tico.interpreter.listeners.TUndoAllCellListener;
import tico.interpreter.listeners.TUndoCellListener;
import tico.interpreter.threads.TInterpreterTTS;

public class TInterpreterProject {
    private static ArrayList<TInterpreterBoard> boardList;
    private static String name;
    private static String initialBoardname;
    private static String boardToGo;
    private static String defaultVoiceName;
    private boolean boardChanged = false;
    private static String boardToReturn;
    private String cellToReturn = null;
    private static String currentBoard;
    private int positionCellToReturn = 0;

    static {
        initialBoardname = null;
        boardToGo = null;
        boardToReturn = null;
        currentBoard = null;
    }

    public TInterpreterProject() {
        boardList = new ArrayList();
    }

    public String getName() {
        return name;
    }

    public void setName(String nameProject) {
        name = nameProject;
    }

    public int getPositionCellToReturnByName(String boardName, String cell) {
        TInterpreterBoard board = this.getBoard(boardName);
        ArrayList<String> cellNames = board.getOrderedCellListNames();
        int i2 = 0;
        Boolean salir = false;
        int posCelda = -1;
        while (i2 < cellNames.size() && !salir.booleanValue()) {
            if (cell.equals(cellNames.get(i2))) {
                posCelda = i2;
                salir = true;
            }
            ++i2;
        }
        return posCelda;
    }

    public int getPositionCellToReturn() {
        return this.positionCellToReturn;
    }

    public void setPositionCellToReturn(int i2) {
        this.positionCellToReturn = i2;
    }

    public static String getInitialBoardname() {
        return initialBoardname;
    }

    public void setBoardToGo(String boardToGo) {
        TInterpreterProject.boardToGo = boardToGo;
    }

    public String getBoardToGo() {
        return boardToGo;
    }

    public void setBoardChanged(boolean boardChanged) {
        this.boardChanged = boardChanged;
    }

    public boolean isBoardChanged() {
        return this.boardChanged;
    }

    public void insertBoard(TInterpreterBoard board) {
        boardList.add(board);
    }

    public TInterpreterBoard getBoard(String name) {
        int indice = 0;
        while (indice < boardList.size()) {
            if (boardList.get(indice).getName().equals(name)) {
                return boardList.get(indice);
            }
            ++indice;
        }
        return null;
    }

    public void setBoardToReturn(String board) {
        boardToReturn = board;
    }

    public String getBoardToReturn() {
        return boardToReturn;
    }

    public void setCellToReturn(String cell) {
        this.cellToReturn = cell;
    }

    public String getCellToReturn() {
        return this.cellToReturn;
    }

    public void setCurrentBoard(String current) {
        currentBoard = current;
    }

    public String getCurrentBoard() {
        return currentBoard;
    }

    public String getDefaultVoiceName() {
        return defaultVoiceName;
    }

    public static TInterpreterProject XMLDecode(File file, String projectName) {
        TInterpreterTTS tts = TInterpreterTTS.getInstance();
        float linewidth = 0.0f;
        Rectangle r2 = new Rectangle();
        Color foregroundColor = null;
        Color backgroundColor = null;
        Color borderColor = null;
        Color gradientColor = null;
        Font font = null;
        String id = null;
        String text = "";
        int ha = 0;
        int va = 0;
        int vtp = 0;
        ImageIcon icon = null;
        ImageIcon alternativeIcon = null;
        boolean transparentBackground = true;
        boolean transparentBorder = true;
        TInterpreterProject project = new TInterpreterProject();
        try {
            SAXBuilder builder = new SAXBuilder(false);
            Document doc = builder.build(file);
            Element raiz = doc.getRootElement();
            if (projectName != "") {
                project.setName(projectName);
            } else {
                String nameproject = raiz.getAttribute("name").getValue();
                project.setName(nameproject);
            }
            Element initialBoard = raiz.getChild("initial_board");
            initialBoardname = initialBoard.getValue();
            project.setBoardToReturn(initialBoardname);
            project.setCurrentBoard(initialBoardname);
            try {
                Element voice = raiz.getChild("voice");
                defaultVoiceName = voice.getAttribute("defaultVoiceName").getValue();
                if (System.getProperty("os.name").toLowerCase().indexOf("mac") < 0 && System.getProperty("os.name").toLowerCase().indexOf("linux") < 0) {
                    tts.addVoiceByName(defaultVoiceName);
                }
            }
            catch (Exception voice) {
                // empty catch block
            }
            List boards = raiz.getChildren("board");
            for (Element board : boards) {
                String name = board.getAttributeValue("name");
                TInterpreterBoard myboard = new TInterpreterBoard();
                myboard.setName(name);
                Element model = board.getChild("model");
                Element attributes = model.getChild("attributes");
                List attributeBoard = attributes.getChildren();
                Iterator bcomp = attributeBoard.iterator();
                backgroundColor = null;
                gradientColor = null;
                while (bcomp.hasNext()) {
                    String micolor;
                    String partialPath;
                    List orderedCells;
                    Iterator ocomp;
                    Element attribBoardValue = (Element)bcomp.next();
                    String componentType = attribBoardValue.getAttribute("key").getValue();
                    if (componentType.equals("imageResizeStyle")) {
                        int imageResizeStyle = Integer.parseInt(attribBoardValue.getValue());
                        myboard.setImageResizeStyle(imageResizeStyle);
                    }
                    if (componentType.equals("orderedCellList") && (ocomp = (orderedCells = attribBoardValue.getChildren()).iterator()).hasNext()) {
                        while (ocomp.hasNext()) {
                            Element nameCell = (Element)ocomp.next();
                            String cellName = nameCell.getValue();
                            myboard.insertOrderedCellName(cellName);
                        }
                    }
                    if (componentType.equals("size")) {
                        float width = Float.parseFloat(attribBoardValue.getChild("width").getValue().trim());
                        float height = Float.parseFloat(attribBoardValue.getChild("height").getValue().trim());
                        myboard.setWidth(width);
                        myboard.setHeight(height);
                    }
                    if (componentType.equals("soundFile")) {
                        File soundFile = null;
                        partialPath = attribBoardValue.getValue();
                        partialPath = partialPath.replace('\\', '/');
                        try {
                            soundFile = TFileHandler.importFile(new File(TProjectHandler.getTempDirectory(), partialPath));
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                        myboard.setSoundFile(partialPath);
                    }
                    if (componentType.equals("icon")) {
                        File imageFile = null;
                        partialPath = attribBoardValue.getValue();
                        partialPath = partialPath.replace('\\', '/');
                        try {
                            imageFile = TFileHandler.importFile(new File(TProjectHandler.getTempDirectory(), partialPath));
                        }
                        catch (IOException e3) {
                            e3.printStackTrace();
                        }
                        myboard.setImageFile(partialPath);
                    }
                    if (componentType.equals("backgroundColor")) {
                        micolor = attribBoardValue.getValue().trim();
                        micolor = micolor.substring(2, micolor.length());
                        int red = Integer.parseInt(micolor.substring(0, 2), 16);
                        int green = Integer.parseInt(micolor.substring(2, 4), 16);
                        int blue = Integer.parseInt(micolor.substring(4, 6), 16);
                        backgroundColor = new Color(red, green, blue);
                        myboard.setBackgroundColor(backgroundColor);
                    }
                    if (!componentType.equals("gradientColor")) continue;
                    micolor = attribBoardValue.getValue().trim();
                    micolor = micolor.substring(2, micolor.length());
                    int red = Integer.parseInt(micolor.substring(0, 2), 16);
                    int green = Integer.parseInt(micolor.substring(2, 4), 16);
                    int blue = Integer.parseInt(micolor.substring(4, 6), 16);
                    gradientColor = new Color(red, green, blue);
                    myboard.setGradientColor(gradientColor);
                }
                boardToGo = initialBoardname;
                List components = model.getChildren("component");
                for (Element component : components) {
                    List attributesLabelList;
                    Element attributesLabel;
                    List attributesList;
                    List attributesLabelList2;
                    Element attributesLabel2;
                    String componentType = component.getAttribute("type").getValue();
                    icon = null;
                    alternativeIcon = null;
                    String command = null;
                    text = "";
                    foregroundColor = null;
                    borderColor = null;
                    backgroundColor = null;
                    gradientColor = null;
                    font = null;
                    transparentBorder = true;
                    transparentBackground = true;
                    String soundFile = null;
                    String alternativeSoundFile = null;
                    String videoFile = null;
                    String videoURL = null;
                    String voiceName = null;
                    String voiceText = null;
                    int synthMode = 0;
                    if (componentType.equals("cell")) {
                        TInterpreterCell cell = new TInterpreterCell();
                        linewidth = 0.0f;
                        attributesLabel2 = component.getChild("attributes");
                        attributesLabelList2 = attributesLabel2.getChildren("attribute");
                        for (Element attribute : attributesLabelList2) {
                            File sound;
                            String partialPath;
                            if (attribute.getAttribute("key").getValue().trim().equals("font")) {
                                int size = Integer.parseInt(attribute.getChild("size").getValue());
                                String family = attribute.getChild("family").getValue();
                                font = attribute.getChild("bold") != null && attribute.getChild("italic") != null ? new Font(family, 3, size) : (attribute.getChild("bold") != null ? new Font(family, 1, size) : (attribute.getChild("italic") != null ? new Font(family, 2, size) : new Font(family, 0, size)));
                            }
                            if (attribute.getAttribute("key").getValue().trim().equals("id")) {
                                id = attribute.getValue().trim();
                            }
                            if (attribute.getAttribute("key").getValue().trim().equals("followingBoard")) {
                                cell.setBoardToGo(attribute.getValue());
                            }
                            if (attribute.getAttribute("key").getValue().trim().equals("bounds")) {
                                float x2 = Float.parseFloat(attribute.getChild("x").getValue().trim());
                                r2.x = (int)x2;
                                float y2 = Float.parseFloat(attribute.getChild("y").getValue().trim());
                                r2.y = (int)y2;
                                float width = Float.parseFloat(attribute.getChild("width").getValue().trim());
                                r2.width = (int)width;
                                float height = Float.parseFloat(attribute.getChild("height").getValue().trim());
                                r2.height = (int)height;
                            }
                            if (attribute.getAttribute("key").getValue().trim().equals("backgroundColor")) {
                                String micolor = attribute.getValue().trim();
                                micolor = micolor.substring(2, micolor.length());
                                int red = Integer.parseInt(micolor.substring(0, 2), 16);
                                int green = Integer.parseInt(micolor.substring(2, 4), 16);
                                int blue = Integer.parseInt(micolor.substring(4, 6), 16);
                                backgroundColor = new Color(red, green, blue);
                                transparentBackground = false;
                            }
                            if (attribute.getAttribute("key").getValue().trim().equals("gradientColor")) {
                                String micolor = attribute.getValue().trim();
                                micolor = micolor.substring(2, micolor.length());
                                int red = Integer.parseInt(micolor.substring(0, 2), 16);
                                int green = Integer.parseInt(micolor.substring(2, 4), 16);
                                int blue = Integer.parseInt(micolor.substring(4, 6), 16);
                                gradientColor = new Color(red, green, blue);
                            }
                            if (attribute.getAttribute("key").getValue().trim().equals("bordercolor")) {
                                String borderColorRectangle = attribute.getValue().trim();
                                borderColorRectangle = borderColorRectangle.substring(2, borderColorRectangle.length());
                                int red = Integer.parseInt(borderColorRectangle.substring(0, 2), 16);
                                int green = Integer.parseInt(borderColorRectangle.substring(2, 4), 16);
                                int blue = Integer.parseInt(borderColorRectangle.substring(4, 6), 16);
                                borderColor = new Color(red, green, blue);
                                transparentBorder = false;
                            }
                            if (attribute.getAttribute("key").getValue().trim().equals("linewidth")) {
                                linewidth = Float.valueOf(attribute.getValue().trim()).floatValue();
                            }
                            if (attribute.getAttribute("key").getValue().trim().equals("text")) {
                                text = attribute.getValue().trim();
                            }
                            if (attribute.getAttribute("key").getValue().trim().equals("environmentAction")) {
                                command = attribute.getValue().trim();
                            }
                            if (attribute.getAttribute("key").getValue().trim().equals("foregroundColor")) {
                                String micolor = attribute.getValue().trim();
                                micolor = micolor.substring(2, micolor.length());
                                int red = Integer.parseInt(micolor.substring(0, 2), 16);
                                int green = Integer.parseInt(micolor.substring(2, 4), 16);
                                int blue = Integer.parseInt(micolor.substring(4, 6), 16);
                                foregroundColor = new Color(red, green, blue);
                            }
                            if (attribute.getAttribute("key").getValue().trim().equals("alternativeBorderColor")) {
                                String micolor = attribute.getValue().trim();
                                micolor = micolor.substring(2, micolor.length());
                                int red = Integer.parseInt(micolor.substring(0, 2), 16);
                                int green = Integer.parseInt(micolor.substring(2, 4), 16);
                                int blue = Integer.parseInt(micolor.substring(4, 6), 16);
                                cell.setAlternativeBorderColor(new Color(red, green, blue));
                            }
                            if (attribute.getAttribute("key").getValue().trim().equals("alternativeLinewidth")) {
                                cell.setAlternativeBorderSize(Integer.parseInt(attribute.getValue()));
                            }
                            if (attribute.getAttribute("key").getValue().trim().equals("accumulated")) {
                                String valor = attribute.getValue().trim();
                                if (valor.equals("true")) {
                                    cell.setAccumulated(true);
                                } else if (valor.equals("false")) {
                                    cell.setAccumulated(false);
                                }
                            }
                            if (attribute.getAttribute("key").getValue().trim().equals("sendTextTimer")) {
                                cell.setTimeSending(Integer.parseInt(attribute.getValue()));
                            }
                            if (attribute.getAttribute("key").getValue().trim().equals("sendTextTarget")) {
                                cell.setTextAreaToSend(attribute.getValue());
                            }
                            if (attribute.getAttribute("key").getValue().trim().equals("sendText")) {
                                cell.setTextToSend(attribute.getValue());
                            }
                            if (attribute.getAttribute("key").getValue().trim().equals("alternativeIcon")) {
                                File imageFile = null;
                                partialPath = attribute.getValue();
                                partialPath = partialPath.replace('\\', '/');
                                try {
                                    imageFile = TFileHandler.importFile(new File(TProjectHandler.getTempDirectory(), partialPath));
                                }
                                catch (IOException e4) {
                                    e4.printStackTrace();
                                }
                                alternativeIcon = new ImageIcon(String.valueOf(TFileHandler.getCurrentDirectoryPath()) + File.separator + partialPath);
                                cell.setAlternativeIcon(alternativeIcon);
                            }
                            if (attribute.getAttribute("key").getValue().trim().equals("verticalTextPosition")) {
                                vtp = Integer.parseInt(attribute.getValue());
                            }
                            if (attribute.getAttribute("key").getValue().trim().equals("icon")) {
                                File imageFile = null;
                                partialPath = attribute.getValue();
                                partialPath = partialPath.replace('\\', '/');
                                try {
                                    imageFile = TFileHandler.importFile(new File(TProjectHandler.getTempDirectory(), partialPath));
                                }
                                catch (IOException e5) {
                                    e5.printStackTrace();
                                }
                                icon = new ImageIcon(String.valueOf(TFileHandler.getCurrentDirectoryPath()) + File.separator + partialPath);
                                cell.setDefaultIcon(icon);
                            }
                            if (attribute.getAttribute("key").getValue().trim().equals("soundFile") && (soundFile = attribute.getValue()) != null) {
                                String partialPath2 = attribute.getValue();
                                partialPath2 = partialPath2.replace('\\', '/');
                                soundFile = String.valueOf(TFileHandler.getCurrentDirectoryPath()) + File.separator + partialPath2;
                                sound = null;
                                try {
                                    sound = TFileHandler.importFile(new File(TProjectHandler.getTempDirectory(), partialPath2));
                                }
                                catch (IOException e6) {
                                    e6.printStackTrace();
                                }
                            }
                            if (attribute.getAttribute("key").getValue().trim().equals("alternativeSoundFile") && (alternativeSoundFile = attribute.getValue()) != null) {
                                String partialPath3 = attribute.getValue();
                                partialPath3 = partialPath3.replace('\\', '/');
                                alternativeSoundFile = String.valueOf(TFileHandler.getCurrentDirectoryPath()) + File.separator + partialPath3;
                                sound = null;
                                try {
                                    sound = TFileHandler.importFile(new File(TProjectHandler.getTempDirectory(), partialPath3));
                                }
                                catch (IOException e7) {
                                    e7.printStackTrace();
                                }
                            }
                            if (attribute.getAttribute("key").getValue().trim().equals("voiceName")) {
                                voiceName = attribute.getValue();
                                tts.addVoiceByName(voiceName);
                            }
                            if (attribute.getAttribute("key").getValue().trim().equals("voiceText")) {
                                voiceText = attribute.getValue();
                            }
                            if (attribute.getAttribute("key").getValue().trim().equals("synthMode")) {
                                synthMode = Integer.parseInt(attribute.getValue());
                            }
                            if (attribute.getAttribute("key").getValue().trim().equals("videoFile") && (videoFile = attribute.getValue()) != null) {
                                String partialPath4 = attribute.getValue();
                                partialPath4 = partialPath4.replace('\\', '/');
                                videoFile = String.valueOf(TFileHandler.getCurrentDirectoryPath()) + File.separator + partialPath4;
                                File video = null;
                                try {
                                    video = TFileHandler.importFile(new File(TProjectHandler.getTempDirectory(), partialPath4));
                                }
                                catch (IOException e8) {
                                    e8.printStackTrace();
                                }
                            }
                            if (!attribute.getAttribute("key").getValue().trim().equals("videoURL")) continue;
                            videoURL = attribute.getValue();
                        }
                        cell.setAttributes(id, r2, text, font, foregroundColor, vtp, icon, linewidth, borderColor, backgroundColor, gradientColor, transparentBackground, transparentBorder, alternativeIcon);
                        cell.setActionsAttributes(soundFile, videoFile, videoURL, command, voiceName, voiceText, synthMode);
                        cell.setAlternativeSoundPath(alternativeSoundFile);
                        if (myboard.isCellInOrderedCellList(cell.getName())) {
                            cell.addMouseListener(new TCellListener(cell));
                        }
                        myboard.insertCell(cell);
                        myboard.insertComponent(cell);
                        continue;
                    }
                    if (componentType.equals("controllerCell")) {
                        int action = 0;
                        attributesLabel2 = component.getChild("attributes");
                        attributesLabelList2 = attributesLabel2.getChildren("attribute");
                        for (Element attribute : attributesLabelList2) {
                            if (attribute.getAttribute("key").getValue().trim().equals("id")) {
                                id = attribute.getValue().trim();
                            }
                            if (attribute.getAttribute("key").getValue().trim().equals("actionCode")) {
                                action = Integer.valueOf(attribute.getValue().trim());
                            }
                            if (attribute.getAttribute("key").getValue().trim().equals("bounds")) {
                                float x3 = Float.parseFloat(attribute.getChild("x").getValue().trim());
                                r2.x = (int)x3;
                                float y3 = Float.parseFloat(attribute.getChild("y").getValue().trim());
                                r2.y = (int)y3;
                                float width = Float.parseFloat(attribute.getChild("width").getValue().trim());
                                r2.width = (int)width;
                                float height = Float.parseFloat(attribute.getChild("height").getValue().trim());
                                r2.height = (int)height;
                            }
                            if (attribute.getAttribute("key").getValue().trim().equals("font")) {
                                int size = Integer.parseInt(attribute.getChild("size").getValue());
                                String family = attribute.getChild("family").getValue();
                                font = attribute.getChild("bold") != null && attribute.getChild("italic") != null ? new Font(family, 3, size) : (attribute.getChild("bold") != null ? new Font(family, 1, size) : (attribute.getChild("italic") != null ? new Font(family, 2, size) : new Font(family, 0, size)));
                            }
                            if (attribute.getAttribute("key").getValue().trim().equals("foregroundColor")) {
                                String micolor = attribute.getValue().trim();
                                micolor = micolor.substring(2, micolor.length());
                                int red = Integer.parseInt(micolor.substring(0, 2), 16);
                                int green = Integer.parseInt(micolor.substring(2, 4), 16);
                                int blue = Integer.parseInt(micolor.substring(4, 6), 16);
                                foregroundColor = new Color(red, green, blue);
                            }
                            if (attribute.getAttribute("key").getValue().trim().equals("icon")) {
                                File imageFile = null;
                                String partialPath = attribute.getValue();
                                partialPath = partialPath.replace('\\', '/');
                                try {
                                    imageFile = TFileHandler.importFile(new File(TProjectHandler.getTempDirectory(), partialPath));
                                }
                                catch (IOException e9) {
                                    e9.printStackTrace();
                                }
                                icon = new ImageIcon(String.valueOf(TFileHandler.getCurrentDirectoryPath()) + File.separator + partialPath);
                            }
                            if (attribute.getAttribute("key").getValue().trim().equals("text")) {
                                text = attribute.getValue().trim();
                            }
                            if (!attribute.getAttribute("key").getValue().trim().equals("alternativeSoundFile") || (alternativeSoundFile = attribute.getValue()) == null) continue;
                            String partialPath = attribute.getValue();
                            partialPath = partialPath.replace('\\', '/');
                            alternativeSoundFile = String.valueOf(TFileHandler.getCurrentDirectoryPath()) + File.separator + partialPath;
                            File sound = null;
                            try {
                                sound = TFileHandler.importFile(new File(TProjectHandler.getTempDirectory(), partialPath));
                            }
                            catch (IOException e10) {
                                e10.printStackTrace();
                            }
                        }
                        if (action == 1) {
                            TInterpreterCell exitCell = new TInterpreterCell();
                            exitCell.setAttributes2(id, r2, TLanguage.getString("TInterpreterExitAction.NAME"), font, foregroundColor, icon);
                            exitCell.addMouseListener(new TExitCellListener());
                            exitCell.setAlternativeSoundPath(alternativeSoundFile);
                            myboard.insertCell(exitCell);
                            myboard.insertComponent(exitCell);
                            continue;
                        }
                        if (action == 2) {
                            TInterpreterCell undoCell = new TInterpreterCell();
                            undoCell.setAttributes2(id, r2, TLanguage.getString("TInterpreterUndoAction.NAME"), font, foregroundColor, icon);
                            undoCell.addMouseListener(new TUndoCellListener());
                            undoCell.setAlternativeSoundPath(alternativeSoundFile);
                            myboard.insertCell(undoCell);
                            myboard.insertComponent(undoCell);
                            continue;
                        }
                        if (action == 3) {
                            TInterpreterCell undoAllCell = new TInterpreterCell();
                            undoAllCell.setAttributes2(id, r2, TLanguage.getString("TInterpreterUndoAllAction.NAME"), font, foregroundColor, icon);
                            undoAllCell.addMouseListener(new TUndoAllCellListener());
                            undoAllCell.setAlternativeSoundPath(alternativeSoundFile);
                            myboard.insertCell(undoAllCell);
                            myboard.insertComponent(undoAllCell);
                            continue;
                        }
                        if (action == 4) {
                            TInterpreterCell readCell = new TInterpreterCell();
                            readCell.setAttributes2(id, r2, TLanguage.getString("TInterpreterReadAction.NAME"), font, foregroundColor, icon);
                            readCell.addMouseListener(new TReadCellListener());
                            readCell.setAlternativeSoundPath(alternativeSoundFile);
                            myboard.insertCell(readCell);
                            myboard.insertComponent(readCell);
                            continue;
                        }
                        if (action == 5) {
                            TInterpreterCell returnCell = new TInterpreterCell();
                            returnCell.setAttributes2(id, r2, TLanguage.getString("TInterpreterReturnAction.NAME"), font, foregroundColor, icon);
                            returnCell.addMouseListener(new TReturnCellListener());
                            returnCell.setAlternativeSoundPath(alternativeSoundFile);
                            myboard.insertCell(returnCell);
                            myboard.insertComponent(returnCell);
                            continue;
                        }
                        if (action == 7) {
                            TInterpreterCell homeCell = new TInterpreterCell();
                            homeCell.setAttributes2(id, r2, TLanguage.getString("TInterpreterHomeAction.NAME"), font, foregroundColor, icon);
                            homeCell.addMouseListener(new THomeCellListener());
                            homeCell.setAlternativeSoundPath(alternativeSoundFile);
                            myboard.insertCell(homeCell);
                            myboard.insertComponent(homeCell);
                            continue;
                        }
                        if (action == 6) {
                            TInterpreterCell stopCell = new TInterpreterCell();
                            stopCell.setAttributes2(id, r2, TLanguage.getString("TInterpreterStopAction.NAME"), font, foregroundColor, icon);
                            stopCell.addMouseListener(new TStopCellListener());
                            stopCell.setAlternativeSoundPath(alternativeSoundFile);
                            myboard.insertCell(stopCell);
                            myboard.insertComponent(stopCell);
                            continue;
                        }
                        if (action != 8) continue;
                        TInterpreterCell copyCell = new TInterpreterCell();
                        copyCell.setAttributes2(id, r2, TLanguage.getString("TInterpreterCopyAction.NAME"), font, foregroundColor, icon);
                        copyCell.addMouseListener(new TCopyCellListener());
                        myboard.insertCell(copyCell);
                        myboard.insertComponent(copyCell);
                        continue;
                    }
                    if (componentType.equals("line")) {
                        int startCorner = 0;
                        Element attributesLine = component.getChild("attributes");
                        List attributesList2 = attributesLine.getChildren("attribute");
                        for (Element attribute : attributesList2) {
                            if (attribute.getAttribute("key").getValue().trim().equals("linewidth")) {
                                linewidth = Float.valueOf(attribute.getValue().trim()).floatValue();
                            }
                            if (attribute.getAttribute("key").getValue().trim().equals("startCorner")) {
                                startCorner = Integer.valueOf(attribute.getValue().trim());
                            }
                            if (attribute.getAttribute("key").getValue().trim().equals("id")) {
                                id = attribute.getValue().trim();
                            }
                            if (attribute.getAttribute("key").getValue().trim().equals("bounds")) {
                                float x4 = Float.parseFloat(attribute.getChild("x").getValue().trim());
                                r2.x = (int)x4;
                                float y4 = Float.parseFloat(attribute.getChild("y").getValue().trim());
                                r2.y = (int)y4;
                                float width = Float.parseFloat(attribute.getChild("width").getValue().trim());
                                r2.width = (int)width;
                                float height = Float.parseFloat(attribute.getChild("height").getValue().trim());
                                r2.height = (int)height;
                            }
                            if (!attribute.getAttribute("key").getValue().trim().equals("bordercolor")) continue;
                            String micolor = attribute.getValue().trim();
                            micolor = micolor.substring(2, micolor.length());
                            int red = Integer.parseInt(micolor.substring(0, 2), 16);
                            int green = Integer.parseInt(micolor.substring(2, 4), 16);
                            int blue = Integer.parseInt(micolor.substring(4, 6), 16);
                            borderColor = new Color(red, green, blue);
                        }
                        TInterpreterLine line = new TInterpreterLine(borderColor, linewidth, r2, startCorner);
                        myboard.insertLine(line);
                        myboard.insertComponent(line);
                        continue;
                    }
                    if (componentType.equals("oval")) {
                        linewidth = 0.0f;
                        r2 = new Rectangle();
                        Element attributesOval = component.getChild("attributes");
                        attributesList = attributesOval.getChildren("attribute");
                        for (Element attribute : attributesList) {
                            if (attribute.getAttribute("key").getValue().trim().equals("linewidth")) {
                                linewidth = Float.valueOf(attribute.getValue().trim()).floatValue();
                            }
                            if (attribute.getAttribute("key").getValue().trim().equals("id")) {
                                id = attribute.getValue().trim();
                            }
                            if (attribute.getAttribute("key").getValue().trim().equals("bounds")) {
                                float x5 = Float.parseFloat(attribute.getChild("x").getValue().trim());
                                r2.x = (int)x5;
                                float y5 = Float.parseFloat(attribute.getChild("y").getValue().trim());
                                r2.y = (int)y5;
                                float width = Float.parseFloat(attribute.getChild("width").getValue().trim());
                                r2.width = (int)width;
                                float height = Float.parseFloat(attribute.getChild("height").getValue().trim());
                                r2.height = (int)height;
                            }
                            if (attribute.getAttribute("key").getValue().trim().equals("backgroundColor")) {
                                String micolor = attribute.getValue().trim();
                                micolor = micolor.substring(2, micolor.length());
                                int red = Integer.parseInt(micolor.substring(0, 2), 16);
                                int green = Integer.parseInt(micolor.substring(2, 4), 16);
                                int blue = Integer.parseInt(micolor.substring(4, 6), 16);
                                backgroundColor = new Color(red, green, blue);
                                transparentBackground = false;
                            }
                            if (attribute.getAttribute("key").getValue().trim().equals("gradientColor")) {
                                String micolor = attribute.getValue().trim();
                                micolor = micolor.substring(2, micolor.length());
                                int red = Integer.parseInt(micolor.substring(0, 2), 16);
                                int green = Integer.parseInt(micolor.substring(2, 4), 16);
                                int blue = Integer.parseInt(micolor.substring(4, 6), 16);
                                gradientColor = new Color(red, green, blue);
                            }
                            if (!attribute.getAttribute("key").getValue().trim().equals("bordercolor")) continue;
                            String borderColorRectangle = attribute.getValue().trim();
                            borderColorRectangle = borderColorRectangle.substring(2, borderColorRectangle.length());
                            int red = Integer.parseInt(borderColorRectangle.substring(0, 2), 16);
                            int green = Integer.parseInt(borderColorRectangle.substring(2, 4), 16);
                            int blue = Integer.parseInt(borderColorRectangle.substring(4, 6), 16);
                            borderColor = new Color(red, green, blue);
                        }
                        TInterpreterOval oval = new TInterpreterOval(borderColor, linewidth, r2, backgroundColor, gradientColor, transparentBackground);
                        myboard.insertOval(oval);
                        myboard.insertComponent(oval);
                        continue;
                    }
                    if (componentType.equals("rectangle")) {
                        linewidth = 0.0f;
                        Element attributesRect = component.getChild("attributes");
                        attributesList = attributesRect.getChildren("attribute");
                        for (Element attribute : attributesList) {
                            if (attribute.getAttribute("key").getValue().trim().equals("linewidth")) {
                                linewidth = Float.valueOf(attribute.getValue().trim()).floatValue();
                            }
                            if (attribute.getAttribute("key").getValue().trim().equals("backgroundColor")) {
                                String micolor = attribute.getValue().trim();
                                micolor = micolor.substring(2, micolor.length());
                                int red = Integer.parseInt(micolor.substring(0, 2), 16);
                                int green = Integer.parseInt(micolor.substring(2, 4), 16);
                                int blue = Integer.parseInt(micolor.substring(4, 6), 16);
                                backgroundColor = new Color(red, green, blue);
                                transparentBackground = false;
                            }
                            if (attribute.getAttribute("key").getValue().trim().equals("gradientColor")) {
                                String micolor = attribute.getValue().trim();
                                micolor = micolor.substring(2, micolor.length());
                                int red = Integer.parseInt(micolor.substring(0, 2), 16);
                                int green = Integer.parseInt(micolor.substring(2, 4), 16);
                                int blue = Integer.parseInt(micolor.substring(4, 6), 16);
                                gradientColor = new Color(red, green, blue);
                            }
                            if (attribute.getAttribute("key").getValue().trim().equals("bordercolor")) {
                                String borderColorRectangle = attribute.getValue().trim();
                                borderColorRectangle = borderColorRectangle.substring(2, borderColorRectangle.length());
                                int red = Integer.parseInt(borderColorRectangle.substring(0, 2), 16);
                                int green = Integer.parseInt(borderColorRectangle.substring(2, 4), 16);
                                int blue = Integer.parseInt(borderColorRectangle.substring(4, 6), 16);
                                borderColor = new Color(red, green, blue);
                            }
                            if (attribute.getAttribute("key").getValue().trim().equals("id")) {
                                id = attribute.getValue().trim();
                            }
                            if (!attribute.getAttribute("key").getValue().trim().equals("bounds")) continue;
                            float x6 = Float.parseFloat(attribute.getChild("x").getValue().trim());
                            r2.x = (int)x6;
                            float y6 = Float.parseFloat(attribute.getChild("y").getValue().trim());
                            r2.y = (int)y6;
                            float width = Float.parseFloat(attribute.getChild("width").getValue().trim());
                            r2.width = (int)width;
                            float height = Float.parseFloat(attribute.getChild("height").getValue().trim());
                            r2.height = (int)height;
                        }
                        TInterpreterRectangle rectangle = new TInterpreterRectangle();
                        rectangle.setAttributes(borderColor, r2, linewidth, backgroundColor, gradientColor, transparentBackground);
                        myboard.insertRectangle(rectangle);
                        myboard.insertComponent(rectangle);
                        continue;
                    }
                    if (componentType.equals("textArea")) {
                        attributesLabel = component.getChild("attributes");
                        attributesLabelList = attributesLabel.getChildren("attribute");
                        Iterator iattributes = attributesLabelList.iterator();
                        backgroundColor = null;
                        foregroundColor = null;
                        borderColor = null;
                        while (iattributes.hasNext()) {
                            Element attribute;
                            attribute = (Element)iattributes.next();
                            if (attribute.getAttribute("key").getValue().trim().equals("linewidth")) {
                                linewidth = Float.valueOf(attribute.getValue().trim()).floatValue();
                            }
                            if (attribute.getAttribute("key").getValue().trim().equals("text")) {
                                text = attribute.getValue().trim();
                            }
                            if (attribute.getAttribute("key").getValue().trim().equals("foregroundColor")) {
                                String micolor = attribute.getValue().trim();
                                micolor = micolor.substring(2, micolor.length());
                                int red = Integer.parseInt(micolor.substring(0, 2), 16);
                                int green = Integer.parseInt(micolor.substring(2, 4), 16);
                                int blue = Integer.parseInt(micolor.substring(4, 6), 16);
                                foregroundColor = new Color(red, green, blue);
                            }
                            if (attribute.getAttribute("key").getValue().trim().equals("id")) {
                                id = attribute.getValue().trim();
                            }
                            if (attribute.getAttribute("key").getValue().trim().equals("backgroundColor")) {
                                String micolor = attribute.getValue().trim();
                                micolor = micolor.substring(2, micolor.length());
                                int red = Integer.parseInt(micolor.substring(0, 2), 16);
                                int green = Integer.parseInt(micolor.substring(2, 4), 16);
                                int blue = Integer.parseInt(micolor.substring(4, 6), 16);
                                backgroundColor = new Color(red, green, blue);
                                transparentBackground = false;
                            }
                            if (attribute.getAttribute("key").getValue().trim().equals("gradientColor")) {
                                String micolor = attribute.getValue().trim();
                                micolor = micolor.substring(2, micolor.length());
                                int red = Integer.parseInt(micolor.substring(0, 2), 16);
                                int green = Integer.parseInt(micolor.substring(2, 4), 16);
                                int blue = Integer.parseInt(micolor.substring(4, 6), 16);
                                gradientColor = new Color(red, green, blue);
                            }
                            if (attribute.getAttribute("key").getValue().trim().equals("font")) {
                                int size = Integer.parseInt(attribute.getChild("size").getValue());
                                String family = attribute.getChild("family").getValue();
                                font = attribute.getChild("bold") != null && attribute.getChild("italic") != null ? new Font(family, 3, size) : (attribute.getChild("bold") != null ? new Font(family, 1, size) : (attribute.getChild("italic") != null ? new Font(family, 2, size) : new Font(family, 0, size)));
                            }
                            if (attribute.getAttribute("key").getValue().trim().equals("bounds")) {
                                float x7 = Float.parseFloat(attribute.getChild("x").getValue().trim());
                                r2.x = (int)x7;
                                float y7 = Float.parseFloat(attribute.getChild("y").getValue().trim());
                                r2.y = (int)y7;
                                float width = Float.parseFloat(attribute.getChild("width").getValue().trim());
                                r2.width = (int)width;
                                float height = Float.parseFloat(attribute.getChild("height").getValue().trim());
                                r2.height = (int)height;
                            }
                            if (attribute.getAttribute("key").getValue().trim().equals("bordercolor")) {
                                String borderColorRectangle = attribute.getValue().trim();
                                borderColorRectangle = borderColorRectangle.substring(2, borderColorRectangle.length());
                                int red = Integer.parseInt(borderColorRectangle.substring(0, 2), 16);
                                int green = Integer.parseInt(borderColorRectangle.substring(2, 4), 16);
                                int blue = Integer.parseInt(borderColorRectangle.substring(4, 6), 16);
                                borderColor = new Color(red, green, blue);
                            }
                            if (attribute.getAttribute("key").getValue().trim().equals("horizontalAlignment")) {
                                ha = Integer.parseInt(attribute.getValue());
                            }
                            if (!attribute.getAttribute("key").getValue().trim().equals("verticalAlignment")) continue;
                            va = Integer.parseInt(attribute.getValue());
                        }
                        TInterpreterTextArea textarea = new TInterpreterTextArea();
                        textarea.setAttributes(id, borderColor, linewidth, backgroundColor, gradientColor, r2, text, font, foregroundColor, ha, va, transparentBackground);
                        myboard.insertTextarea(textarea);
                        myboard.insertComponent(textarea);
                        continue;
                    }
                    if (componentType.equals("roundRect")) {
                        Element attributesRoundRect = component.getChild("attributes");
                        attributesList = attributesRoundRect.getChildren("attribute");
                        for (Element attribute : attributesList) {
                            if (attribute.getAttribute("key").getValue().trim().equals("linewidth")) {
                                linewidth = Float.valueOf(attribute.getValue().trim()).floatValue();
                            }
                            if (attribute.getAttribute("key").getValue().trim().equals("id")) {
                                id = attribute.getValue().trim();
                            }
                            if (attribute.getAttribute("key").getValue().trim().equals("bounds")) {
                                float x8 = Float.parseFloat(attribute.getChild("x").getValue().trim());
                                r2.x = (int)x8;
                                float y8 = Float.parseFloat(attribute.getChild("y").getValue().trim());
                                r2.y = (int)y8;
                                float width = Float.parseFloat(attribute.getChild("width").getValue().trim());
                                r2.width = (int)width;
                                float height = Float.parseFloat(attribute.getChild("height").getValue().trim());
                                r2.height = (int)height;
                            }
                            if (attribute.getAttribute("key").getValue().trim().equals("bordercolor")) {
                                String borderColorRectangle = attribute.getValue().trim();
                                borderColorRectangle = borderColorRectangle.substring(2, borderColorRectangle.length());
                                int red = Integer.parseInt(borderColorRectangle.substring(0, 2), 16);
                                int green = Integer.parseInt(borderColorRectangle.substring(2, 4), 16);
                                int blue = Integer.parseInt(borderColorRectangle.substring(4, 6), 16);
                                borderColor = new Color(red, green, blue);
                            }
                            if (attribute.getAttribute("key").getValue().trim().equals("backgroundColor")) {
                                String micolor = attribute.getValue().trim();
                                micolor = micolor.substring(2, micolor.length());
                                int red = Integer.parseInt(micolor.substring(0, 2), 16);
                                int green = Integer.parseInt(micolor.substring(2, 4), 16);
                                int blue = Integer.parseInt(micolor.substring(4, 6), 16);
                                backgroundColor = new Color(red, green, blue);
                                transparentBackground = false;
                            }
                            if (!attribute.getAttribute("key").getValue().trim().equals("gradientColor")) continue;
                            String micolor = attribute.getValue().trim();
                            micolor = micolor.substring(2, micolor.length());
                            int red = Integer.parseInt(micolor.substring(0, 2), 16);
                            int green = Integer.parseInt(micolor.substring(2, 4), 16);
                            int blue = Integer.parseInt(micolor.substring(4, 6), 16);
                            gradientColor = new Color(red, green, blue);
                        }
                        TInterpreterRoundRectangle roundRectangle = new TInterpreterRoundRectangle(borderColor, backgroundColor, gradientColor, linewidth, r2, transparentBackground);
                        myboard.insertRoundRectangle(roundRectangle);
                        myboard.insertComponent(roundRectangle);
                        continue;
                    }
                    if (!componentType.equals("label")) continue;
                    attributesLabel = component.getChild("attributes");
                    attributesLabelList = attributesLabel.getChildren("attribute");
                    for (Element attribute : attributesLabelList) {
                        if (attribute.getAttribute("key").getValue().trim().equals("linewidth")) {
                            linewidth = Float.valueOf(attribute.getValue().trim()).floatValue();
                        }
                        if (attribute.getAttribute("key").getValue().trim().equals("text")) {
                            text = attribute.getValue().trim();
                        }
                        if (attribute.getAttribute("key").getValue().trim().equals("font")) {
                            int size = Integer.parseInt(attribute.getChild("size").getValue());
                            String family = attribute.getChild("family").getValue();
                            font = attribute.getChild("bold") != null && attribute.getChild("italic") != null ? new Font(family, 3, size) : (attribute.getChild("bold") != null ? new Font(family, 1, size) : (attribute.getChild("italic") != null ? new Font(family, 2, size) : new Font(family, 0, size)));
                        }
                        if (attribute.getAttribute("key").getValue().trim().equals("bordercolor")) {
                            String borderColorRectangle = attribute.getValue().trim();
                            borderColorRectangle = borderColorRectangle.substring(2, borderColorRectangle.length());
                            int red = Integer.parseInt(borderColorRectangle.substring(0, 2), 16);
                            int green = Integer.parseInt(borderColorRectangle.substring(2, 4), 16);
                            int blue = Integer.parseInt(borderColorRectangle.substring(4, 6), 16);
                            borderColor = new Color(red, green, blue);
                        }
                        if (attribute.getAttribute("key").getValue().trim().equals("backgroundColor")) {
                            String micolor = attribute.getValue().trim();
                            micolor = micolor.substring(2, micolor.length());
                            int red = Integer.parseInt(micolor.substring(0, 2), 16);
                            int green = Integer.parseInt(micolor.substring(2, 4), 16);
                            int blue = Integer.parseInt(micolor.substring(4, 6), 16);
                            backgroundColor = new Color(red, green, blue);
                            transparentBackground = false;
                        }
                        if (attribute.getAttribute("key").getValue().trim().equals("gradientColor")) {
                            String micolor = attribute.getValue().trim();
                            micolor = micolor.substring(2, micolor.length());
                            int red = Integer.parseInt(micolor.substring(0, 2), 16);
                            int green = Integer.parseInt(micolor.substring(2, 4), 16);
                            int blue = Integer.parseInt(micolor.substring(4, 6), 16);
                            gradientColor = new Color(red, green, blue);
                        }
                        if (attribute.getAttribute("key").getValue().trim().equals("foregroundColor")) {
                            String micolor = attribute.getValue().trim();
                            micolor = micolor.substring(2, micolor.length());
                            int red = Integer.parseInt(micolor.substring(0, 2), 16);
                            int green = Integer.parseInt(micolor.substring(2, 4), 16);
                            int blue = Integer.parseInt(micolor.substring(4, 6), 16);
                            foregroundColor = new Color(red, green, blue);
                        }
                        if (attribute.getAttribute("key").getValue().trim().equals("id")) {
                            id = attribute.getValue().trim();
                        }
                        if (!attribute.getAttribute("key").getValue().trim().equals("bounds")) continue;
                        float x9 = Float.parseFloat(attribute.getChild("x").getValue().trim());
                        r2.x = (int)x9;
                        float y9 = Float.parseFloat(attribute.getChild("y").getValue().trim());
                        r2.y = (int)y9;
                        float width = Float.parseFloat(attribute.getChild("width").getValue().trim());
                        r2.width = (int)width;
                        float height = Float.parseFloat(attribute.getChild("height").getValue().trim());
                        r2.height = (int)height;
                    }
                    TInterpreterLabel label = new TInterpreterLabel();
                    label.setAttributes(borderColor, linewidth, backgroundColor, gradientColor, r2, text, font, foregroundColor, transparentBackground);
                    myboard.insertLabel(label);
                    myboard.insertComponent(label);
                }
                project.insertBoard(myboard);
                if (!myboard.getName().equals(TInterpreterProject.getInitialBoardname()) || myboard.getOrderedCellListNames().isEmpty()) continue;
                project.setCellToReturn(myboard.getOrderedCellListNames().get(0).toString());
            }
        }
        catch (Exception e11) {
            e11.printStackTrace();
        }
        return project;
    }
}

