/*
 * Decompiled with CFR 0.152.
 */
package tico.interpreter;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.File;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import tico.editor.TFileHandler;
import tico.interpreter.TInterpreter;
import tico.interpreter.TPanel;
import tico.interpreter.components.TInterpreterCell;
import tico.interpreter.components.TInterpreterLabel;
import tico.interpreter.components.TInterpreterLine;
import tico.interpreter.components.TInterpreterOval;
import tico.interpreter.components.TInterpreterRectangle;
import tico.interpreter.components.TInterpreterRoundRectangle;
import tico.interpreter.components.TInterpreterTextArea;
import tico.interpreter.threads.TInterpreterBoardSound;

public class TInterpreterBoard {
    private String name;
    private float width;
    private float height;
    private String soundPath = null;
    private String imagePath = null;
    private Color backgroundColor = null;
    private Color gradientColor = null;
    private int imageResizeStyle;
    private ArrayList<TInterpreterLine> lineList;
    private ArrayList<TInterpreterOval> ovalList;
    private ArrayList<TInterpreterRectangle> rectangleList;
    private ArrayList<TInterpreterRoundRectangle> roundRectangleList;
    private ArrayList<TInterpreterCell> cellList;
    private ArrayList<TInterpreterTextArea> textAreaList;
    private ArrayList<TInterpreterLabel> labelList;
    private ArrayList<String> orderedCellListNames;
    private ArrayList<Object> repaintOrderedComponents;
    boolean firstTimeFullscreen = false;
    Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
    Dimension antDim;
    float scaleW;
    float scaleH;

    public TInterpreterBoard() {
        this.initializeArrays();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public float getWidth() {
        return this.width;
    }

    public void setWidth(float width) {
        this.width = width;
    }

    public float getHeight() {
        return this.height;
    }

    public void setHeight(float height) {
        this.height = height;
    }

    public String getSoundFile() {
        return this.soundPath;
    }

    public void setSoundFile(String newSoundPath) {
        this.soundPath = newSoundPath;
    }

    public String getImageFile() {
        return this.imagePath;
    }

    public void setImageFile(String newImagePath) {
        this.imagePath = newImagePath;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public Color getGradientColor() {
        return this.gradientColor;
    }

    public void setGradientColor(Color gradientColor) {
        this.gradientColor = gradientColor;
    }

    public int getImageResizeStyle() {
        return this.imageResizeStyle;
    }

    public void setImageResizeStyle(int newImageResizeStyle) {
        this.imageResizeStyle = newImageResizeStyle;
    }

    public TInterpreterTextArea getTextAreaByName(String nameTextArea) {
        int i2 = 0;
        while (i2 < this.textAreaList.size()) {
            if (this.textAreaList.get(i2).getName().equals(nameTextArea)) {
                return this.textAreaList.get(i2);
            }
            ++i2;
        }
        return null;
    }

    public TInterpreterCell getCellByName(String nameCell) {
        int i2 = 0;
        while (i2 < this.cellList.size()) {
            if (this.cellList.get(i2).getName().equals(nameCell)) {
                return this.cellList.get(i2);
            }
            ++i2;
        }
        return null;
    }

    public ArrayList<TInterpreterLine> getLineList() {
        return this.lineList;
    }

    public void setLineList(ArrayList<TInterpreterLine> newLineList) {
        this.lineList = newLineList;
    }

    public ArrayList<TInterpreterLabel> getLabelList() {
        return this.labelList;
    }

    public void setLabelList(ArrayList<TInterpreterLabel> newLabelList) {
        this.labelList = newLabelList;
    }

    public ArrayList<Object> getRepaintOrderedComponents() {
        return this.repaintOrderedComponents;
    }

    public void setRepaintOrderedComponents(ArrayList<Object> newObjectList) {
        this.repaintOrderedComponents = newObjectList;
    }

    public ArrayList<TInterpreterOval> getOvalList() {
        return this.ovalList;
    }

    public void setOvalList(ArrayList<TInterpreterOval> newOvalList) {
        this.ovalList = newOvalList;
    }

    public ArrayList<TInterpreterRectangle> getRectangleList() {
        return this.rectangleList;
    }

    public void setRectangleList(ArrayList<TInterpreterRectangle> newRectangleList) {
        this.rectangleList = newRectangleList;
    }

    public ArrayList<TInterpreterRoundRectangle> getRoundRectangleList() {
        return this.roundRectangleList;
    }

    public void setRoundRectangleList(ArrayList<TInterpreterRoundRectangle> newRoundRectangleList) {
        this.roundRectangleList = newRoundRectangleList;
    }

    public ArrayList<TInterpreterCell> getCellList() {
        return this.cellList;
    }

    public void setCellList(ArrayList<TInterpreterCell> newCellList) {
        this.cellList = newCellList;
    }

    public ArrayList<String> getOrderedCellListNames() {
        return this.orderedCellListNames;
    }

    public void setOrderedCellListNames(ArrayList<String> newOrderedCellListNames) {
        this.orderedCellListNames = newOrderedCellListNames;
    }

    public boolean isCellInOrderedCellList(String idCell) {
        int i2 = 0;
        boolean found = false;
        while (i2 < this.orderedCellListNames.size() && !found) {
            found = this.orderedCellListNames.get(i2).equals(idCell);
            ++i2;
        }
        return found;
    }

    public void goToInitialState() {
        ArrayList<TInterpreterCell> cellList = TInterpreter.getCurrentBoard().getCellList();
        int i2 = 0;
        while (i2 < cellList.size()) {
            TInterpreterCell cell = cellList.get(i2);
            if (cell.isTransparentBorder()) {
                cell.setBorderPainted(false);
            }
            cell.setBorder(new LineBorder(cell.getBorderColor(), (int)cell.getBorderSize()));
            if (cell.getBackground() != null) {
                cell.setBackground(cell.getBackground());
            }
            cell.setIcon(cell.getDefaultIcon());
            ++i2;
        }
    }

    public void paintBoard(JPanel interpreterArea, boolean playBoardSound) {
        TInterpreter.setCurrentBoard(this);
        int i2 = this.repaintOrderedComponents.size() - 1;
        while (i2 >= 0) {
            interpreterArea.add((Component)this.repaintOrderedComponents.get(i2));
            --i2;
        }
        Dimension boardSize = new Dimension((int)this.width, (int)this.height);
        interpreterArea.setPreferredSize(boardSize);
        if (this.backgroundColor != null) {
            interpreterArea.setBackground(this.backgroundColor);
        }
        if (this.gradientColor != null) {
            GradientPanel gradientPanel = new GradientPanel(this.backgroundColor, this.gradientColor);
            interpreterArea.add(gradientPanel);
        }
        if (this.imagePath != null) {
            ImageIcon imageFile = new ImageIcon(String.valueOf(TFileHandler.getCurrentDirectoryPath()) + File.separator + this.imagePath);
            JLabel backgroundImageContainer = new JLabel();
            backgroundImageContainer.setSize((int)boardSize.getWidth() - 2, (int)boardSize.getHeight() - 2);
            backgroundImageContainer.setHorizontalAlignment(0);
            backgroundImageContainer.setVerticalAlignment(0);
            if ((float)imageFile.getIconHeight() >= this.getHeight() && (float)imageFile.getIconWidth() >= this.getWidth()) {
                imageFile = new ImageIcon(imageFile.getImage().getScaledInstance((int)boardSize.getWidth() - 2, (int)boardSize.getHeight() - 2, 4));
            } else if ((float)imageFile.getIconHeight() < this.getHeight() && (float)imageFile.getIconWidth() < this.getWidth()) {
                if (this.getImageResizeStyle() == 0) {
                    imageFile = new ImageIcon(imageFile.getImage().getScaledInstance((int)boardSize.getWidth() - 2, (int)boardSize.getHeight() - 2, 4));
                }
                if (this.getImageResizeStyle() == 1) {
                    float factor;
                    if (this.getWidth() > this.getHeight()) {
                        factor = (float)(boardSize.getHeight() / (double)imageFile.getIconHeight());
                        imageFile = new ImageIcon(imageFile.getImage().getScaledInstance((int)((float)imageFile.getIconWidth() * factor - 2.0f), (int)boardSize.getHeight() - 2, 4));
                    }
                    if (this.getWidth() < this.getHeight()) {
                        factor = (float)(boardSize.getWidth() / (double)imageFile.getIconWidth());
                        imageFile = new ImageIcon(imageFile.getImage().getScaledInstance((int)boardSize.getWidth() - 2, (int)((float)imageFile.getIconHeight() * factor - 2.0f), 4));
                    }
                }
            } else if ((float)imageFile.getIconHeight() > this.getHeight() && (float)imageFile.getIconWidth() < this.getWidth()) {
                float factor = (float)(boardSize.getHeight() / (double)imageFile.getIconHeight());
                if (this.getImageResizeStyle() == 1 || this.getImageResizeStyle() == 2) {
                    imageFile = new ImageIcon(imageFile.getImage().getScaledInstance((int)((float)imageFile.getIconWidth() * factor - 2.0f), (int)boardSize.getHeight() - 2, 4));
                }
                if (this.getImageResizeStyle() == 0) {
                    imageFile = new ImageIcon(imageFile.getImage().getScaledInstance((int)boardSize.getWidth() - 2, (int)boardSize.getHeight() - 2, 4));
                }
            } else if ((float)imageFile.getIconHeight() < this.getHeight() && (float)imageFile.getIconWidth() > this.getWidth()) {
                float factor = (float)(boardSize.getWidth() / (double)imageFile.getIconWidth());
                if (this.getImageResizeStyle() == 1 || this.getImageResizeStyle() == 2) {
                    imageFile = new ImageIcon(imageFile.getImage().getScaledInstance((int)boardSize.getWidth() - 2, (int)((float)imageFile.getIconHeight() * factor - 2.0f), 4));
                }
                if (this.getImageResizeStyle() == 0) {
                    imageFile = new ImageIcon(imageFile.getImage().getScaledInstance((int)boardSize.getWidth() - 2, (int)boardSize.getHeight() - 2, 4));
                }
            }
            backgroundImageContainer.setIcon(imageFile);
            backgroundImageContainer.setVisible(true);
            backgroundImageContainer.setLocation(1, 1);
            interpreterArea.add(backgroundImageContainer);
        }
        interpreterArea.updateUI();
        TInterpreter.interpretArea.requestFocusInWindow();
        if (TInterpreter.run == 1 && this.soundPath != null && playBoardSound) {
            TInterpreterBoardSound boardSound = new TInterpreterBoardSound(this.soundPath);
            SwingUtilities.invokeLater(boardSound);
        }
        if (TInterpreter.fullscreen) {
            this.resize();
        } else if (!TInterpreter.fullscreen && this.firstTimeFullscreen) {
            this.unResize();
        }
    }

    private void resize() {
        TPanel b2 = TInterpreter.interpretArea;
        this.antDim = b2.getPreferredSize().getSize();
        Dimension newDim = new Dimension(this.screenSize.width, this.screenSize.height - 50);
        b2.setPreferredSize(newDim);
        this.scaleW = (float)newDim.width / (float)this.antDim.width;
        this.scaleH = (float)newDim.height / (float)this.antDim.height;
        if (!this.firstTimeFullscreen) {
            Component[] componentArray = b2.getComponents();
            int n2 = componentArray.length;
            int n3 = 0;
            while (n3 < n2) {
                Component c2 = componentArray[n3];
                Dimension antSize = c2.getSize();
                int newWidth = Math.round((float)antSize.width * this.scaleW);
                int newHeight = Math.round((float)antSize.height * this.scaleH);
                c2.setSize(new Dimension(newWidth, newHeight));
                Point antLocation = c2.getLocation();
                int newX = Math.round((float)antLocation.x * this.scaleW);
                int newY = Math.round((float)antLocation.y * this.scaleH);
                c2.setLocation(newX, newY);
                ++n3;
            }
        }
        this.firstTimeFullscreen = true;
    }

    private void unResize() {
        TPanel b2 = TInterpreter.interpretArea;
        Dimension newDim = new Dimension(this.screenSize.width, this.screenSize.height - 50);
        b2.setPreferredSize(this.antDim);
        Component[] componentArray = b2.getComponents();
        int n2 = componentArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Component c2 = componentArray[n3];
            Dimension antSize = c2.getSize();
            int newWidth = Math.round((float)antSize.width / this.scaleW);
            int newHeight = Math.round((float)antSize.height / this.scaleH);
            c2.setSize(new Dimension(newWidth, newHeight));
            Point antLocation = c2.getLocation();
            int newX = Math.round((float)antLocation.x / this.scaleW);
            int newY = Math.round((float)antLocation.y / this.scaleH);
            c2.setLocation(newX, newY);
            ++n3;
        }
    }

    public void initializeArrays() {
        this.lineList = new ArrayList();
        this.labelList = new ArrayList();
        this.ovalList = new ArrayList();
        this.rectangleList = new ArrayList();
        this.roundRectangleList = new ArrayList();
        this.cellList = new ArrayList();
        this.textAreaList = new ArrayList();
        this.orderedCellListNames = new ArrayList();
        this.repaintOrderedComponents = new ArrayList();
    }

    public void insertLine(TInterpreterLine line) {
        this.lineList.add(line);
    }

    public void insertLabel(TInterpreterLabel label) {
        this.labelList.add(label);
    }

    public void insertOval(TInterpreterOval oval) {
        this.ovalList.add(oval);
    }

    public void insertRectangle(TInterpreterRectangle rectangle) {
        this.rectangleList.add(rectangle);
    }

    public void insertRoundRectangle(TInterpreterRoundRectangle roundRectangle) {
        this.roundRectangleList.add(roundRectangle);
    }

    public void insertCell(TInterpreterCell cell) {
        this.cellList.add(cell);
    }

    public void insertTextarea(TInterpreterTextArea textArea) {
        this.textAreaList.add(textArea);
    }

    public void insertOrderedCellName(String cellName) {
        this.orderedCellListNames.add(cellName);
    }

    public void insertComponent(Object component) {
        this.repaintOrderedComponents.add(component);
    }

    class GradientPanel
    extends JPanel {
        private Color startColor;
        private Color endColor;

        public GradientPanel(Color startColor, Color endColor) {
            this.startColor = startColor;
            this.endColor = endColor;
            this.setSize((int)TInterpreterBoard.this.width - 2, (int)TInterpreterBoard.this.height - 2);
            this.setLocation(1, 1);
        }

        @Override
        public void paint(Graphics g2) {
            int panelHeight = this.getHeight();
            int panelWidth = this.getWidth();
            GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, this.startColor, panelWidth, panelHeight, this.endColor);
            if (g2 instanceof Graphics2D) {
                Graphics2D graphics2D = (Graphics2D)g2;
                graphics2D.setPaint(gradientPaint);
                graphics2D.fillRect(0, 0, panelWidth, panelHeight);
            }
        }
    }
}

