/*
 * Decompiled with CFR 0.152.
 */
package tico.interpreter;

import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.border.LineBorder;
import tico.components.TMenuItem;
import tico.components.resources.TResourceManager;
import tico.configuration.TLanguage;
import tico.interpreter.TInterpreterActionSet;
import tico.interpreter.TInterpreterBoard;
import tico.interpreter.TInterpreterConstants;
import tico.interpreter.TInterpreterProject;
import tico.interpreter.TPanel;
import tico.interpreter.actions.TInterpreterExitAction;
import tico.interpreter.listeners.TBoardListener;
import tico.interpreter.threads.TThreads;

public class TInterpreter
extends JFrame {
    public static String DEFAULT_TITLE = TLanguage.getString("TInterpreter.INTERPRETER_WINDOW_TITLE");
    private TInterpreterProject project;
    private static TInterpreterBoard currentBoard = null;
    private Dimension initLocation = new Dimension(0, 0);
    private Dimension initSize = Toolkit.getDefaultToolkit().getScreenSize();
    public static ArrayList accumulatedCellsList = null;
    public static int run = 0;
    public static TThreads interpretationThread;
    public Robot interpreterRobot;
    private static TMenuItem menuItemStart;
    private static TMenuItem menuItemStop;
    private static TMenuItem menuItemRead;
    private static TMenuItem menuItemUndo;
    private static TMenuItem menuItemUndoAll;
    public JPanel backgroundPanel;
    public static TPanel interpretArea;
    public static JPanel interpretAreaBackground;
    public static JSplitPane splitPane;
    public static JPanel accumulatedCells;
    public static TBoardListener boardListener;
    private TInterpreterActionSet actionSet;
    public static boolean fullscreen;

    static {
        fullscreen = false;
    }

    public TInterpreter() {
        super(DEFAULT_TITLE);
        accumulatedCellsList = new ArrayList();
        try {
            this.interpreterRobot = new Robot();
        }
        catch (AWTException e2) {
            e2.printStackTrace();
        }
        this.setDefaultCloseOperation(3);
        this.setWindowAtributes();
        this.createActions();
        this.createMenu();
        this.createInterpreterArea();
        this.createWindowListener();
        this.updateMenuButtons();
        this.setResizable(true);
        this.setVisible(true);
        TInterpreterConstants.interpreter = this;
        String os = System.getProperty("os.name");
        if (os.startsWith("Windows")) {
            TInterpreterConstants.operatingSystem = "windows";
        }
        if (os.startsWith("Linux")) {
            TInterpreterConstants.operatingSystem = "linux";
        }
    }

    public TInterpreter(TInterpreterProject project) {
        this();
        this.setProject(project);
        this.setTitle(String.valueOf(DEFAULT_TITLE) + " - " + project.getName());
    }

    public static TInterpreterBoard getCurrentBoard() {
        return currentBoard;
    }

    public static void setCurrentBoard(TInterpreterBoard currentBoard) {
        TInterpreter.currentBoard = currentBoard;
    }

    public void changeBoard(String boardName) {
        TInterpreterBoard board = this.project.getBoard(boardName);
        interpretArea.removeAll();
        this.setVisible(true);
        board.paintBoard(interpretArea, true);
        interpretArea.repaint();
    }

    public void repaintCurrentBoard(boolean playBoardSound) {
        interpretArea.removeAll();
        TInterpreter.getCurrentBoard().goToInitialState();
        TInterpreter.getCurrentBoard().paintBoard(interpretArea, playBoardSound);
        interpretArea.repaint();
    }

    public TInterpreterProject getIntepreterProject() {
        return this.project;
    }

    protected void setWindowAtributes() {
        this.setIconImage(TResourceManager.getImage("interpreter-icon-24.png"));
        this.setLocation(this.initLocation.width, this.initLocation.height);
        this.setSize(this.initSize.width, this.initSize.height);
    }

    private void createActions() {
        this.actionSet = new TInterpreterActionSet(this);
    }

    private void createMenu() {
        JMenuBar menuBar = new JMenuBar();
        JMenu menuFile = new JMenu(TLanguage.getString("TInterpreter.FILE_MENU"));
        menuFile.setMnemonic(65);
        TMenuItem menuItem = new TMenuItem(this.actionSet.getAction("proyectOpenAction"));
        menuItem.setMnemonic(65);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        menuFile.add(menuItem);
        menuFile.add(new JSeparator());
        menuItem = new TMenuItem(this.actionSet.getAction("interpreterExitAction"));
        menuItem.setMnemonic(83);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        menuFile.add(menuItem);
        menuBar.add(menuFile);
        JMenu menuHelp = new JMenu(TLanguage.getString("TEditorMenuBar.HELP_MENU"));
        menuHelp.setMnemonic(89);
        menuItem = new TMenuItem(this.actionSet.getAction("interpreterShowAbout"));
        menuItem.setMnemonic(112);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(112, 2));
        menuHelp.add(menuItem);
        JMenu menuActions = new JMenu(TLanguage.getString("TInterpreterMenuBar.ACTION_MENU"));
        menuItemStart = new TMenuItem(this.actionSet.getAction("interpreterRun"));
        menuItemStart.setMnemonic(116);
        menuItemStart.setAccelerator(KeyStroke.getKeyStroke(116, 2));
        menuActions.add(menuItemStart);
        menuItemStop = new TMenuItem(this.actionSet.getAction("interpreterStop"));
        menuItemStop.setMnemonic(27);
        menuItemStop.setAccelerator(KeyStroke.getKeyStroke(27, 0));
        menuActions.add(menuItemStop);
        menuItemRead = new TMenuItem(this.actionSet.getAction("interpreterRead"));
        menuItemRead.setMnemonic(118);
        menuItemRead.setAccelerator(KeyStroke.getKeyStroke(118, 2));
        menuActions.add(menuItemRead);
        menuItemUndo = new TMenuItem(this.actionSet.getAction("interpreterUndo"));
        menuItemUndo.setMnemonic(90);
        menuItemUndo.setAccelerator(KeyStroke.getKeyStroke(90, 2));
        menuActions.add(menuItemUndo);
        menuItemUndoAll = new TMenuItem(this.actionSet.getAction("interpreterUndoAll"));
        menuItemUndoAll.setMnemonic(119);
        menuItemUndoAll.setAccelerator(KeyStroke.getKeyStroke(119, 2));
        menuActions.add(menuItemUndoAll);
        JMenu menuView = new JMenu(TLanguage.getString("TInterpreterMenuBar.VIEW_MENU"));
        menuItem = new TMenuItem(this.actionSet.getAction("interpreterOptions"));
        menuView.add(menuItem);
        menuItem = new TMenuItem(this.actionSet.getAction("interpreterLanguajes"));
        menuView.add(menuItem);
        menuItem = new TMenuItem(this.actionSet.getAction("interpreterFullscreen"));
        menuView.add(menuItem);
        menuBar.add(menuView);
        menuBar.add(menuActions);
        menuBar.add(this.createValidationMenu());
        menuBar.add(menuHelp);
        this.setJMenuBar(menuBar);
        TInterpreter.setEnabledActions(false);
    }

    public static void setEnabledActions(boolean enabled) {
        menuItemStart.setEnabled(enabled);
        menuItemUndo.setEnabled(enabled);
        menuItemUndoAll.setEnabled(enabled);
        menuItemRead.setEnabled(enabled);
        menuItemStop.setEnabled(enabled);
    }

    public TInterpreter getInterpreter() {
        return this;
    }

    private void createInterpreterArea() {
        this.backgroundPanel = new JPanel(new BorderLayout());
        interpretArea = new TPanel();
        interpretArea.setLayout(null);
        Dimension d2 = new Dimension(800, 600);
        interpretArea.setPreferredSize(d2);
        interpretArea.setBackground(Color.white);
        interpretArea.setVisible(true);
        interpretArea.setBorder(new LineBorder(Color.black, 1));
        interpretAreaBackground = new JPanel();
        interpretAreaBackground.setLayout(new GridBagLayout());
        GridBagConstraints c2 = new GridBagConstraints();
        c2.anchor = 10;
        interpretAreaBackground.add((Component)interpretArea, c2);
        accumulatedCells = new JPanel();
        accumulatedCells.setLayout(new FlowLayout(0));
        splitPane = new JSplitPane(0, new JScrollPane(interpretAreaBackground), accumulatedCells);
        splitPane.setResizeWeight(0.5);
        splitPane.setEnabled(false);
        splitPane.setDividerSize(10);
        splitPane.setDividerLocation(Toolkit.getDefaultToolkit().getScreenSize().height - 157);
        this.backgroundPanel.add((Component)splitPane, "Center");
        this.add(this.backgroundPanel);
    }

    private void createWindowListener() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e2) {
                new TInterpreterExitAction(TInterpreter.this.getInterpreter()).actionPerformed(null);
            }
        });
    }

    public TInterpreterProject getProject() {
        return this.project;
    }

    public void setProject(TInterpreterProject myproject) {
        if (this.getProject() != null) {
            this.deleteProject();
        }
        this.project = myproject;
        this.setTitle(String.valueOf(DEFAULT_TITLE) + " - " + myproject.getName());
        this.changeBoard(TInterpreterProject.getInitialBoardname());
        this.updateMenuButtons();
    }

    public void deleteProject() {
        this.project = null;
        accumulatedCellsList.removeAll(accumulatedCellsList);
        accumulatedCells.removeAll();
        this.updateMenuButtons();
    }

    public TInterpreterActionSet getActionSet() {
        return this.actionSet;
    }

    public void TIntepreterChangeCursor() {
        if (TInterpreterConstants.interpreterCursor == null) {
            ImageIcon ii = TResourceManager.getImageIcon("flecha2.png");
            if (ii == null) {
                ii = TResourceManager.getImageIcon("flecha2.png");
            }
            Image imageCursor = ii.getImage();
            Cursor customCursor = this.getToolkit().createCustomCursor(imageCursor, new Point(), "MyCursor");
            this.setCursor(customCursor);
        } else {
            ImageIcon ii = new ImageIcon(TInterpreterConstants.interpreterCursor);
            if (ii == null) {
                ii = TResourceManager.getImageIcon("flecha2.png");
            }
            Image imageCursor = ii.getImage();
            Cursor customCursor = this.getToolkit().createCustomCursor(imageCursor, new Point(), "MyCursor");
            this.setCursor(customCursor);
        }
    }

    public void TIntepreterWaitingCursor() {
        this.setCursor(Cursor.getPredefinedCursor(3));
    }

    public void TInterpreterRestoreCursor() {
        Cursor cursorBar = new Cursor(0);
        this.setCursor(cursorBar);
    }

    private JMenu createValidationMenu() {
        JMenu menu = new JMenu(TLanguage.getString("TInterpreter.VALIDATION_MENU"));
        menu.setMnemonic(76);
        TMenuItem menuItem = new TMenuItem(this.actionSet.getAction("interpreterValidation"));
        menu.add(menuItem);
        this.add(menu);
        return menu;
    }

    public void updateMenuButtons() {
        boolean projectExists = this.project != null;
        this.actionSet.getAction("interpreterValidation").setEnabled(projectExists);
    }

    public static String returnMouseMode() {
        return TInterpreterConstants.mouseModeSelected;
    }
}

