/*
 * Decompiled with CFR 0.152.
 */
package tico.imageGallery.tasks;

import java.util.LinkedList;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import tico.configuration.TLanguage;

public class TIGTableModel
extends AbstractTableModel {
    final String[] columnNames = new String[]{TLanguage.getString("TIGTableModel.FIRST_COLUMN"), TLanguage.getString("TIGTableModel.SECOND_COLUMN")};
    private Vector data = new Vector();
    Class[] types = new Class[]{String.class, Boolean.class};
    private LinkedList listeners = new LinkedList();

    public TIGTableModel(Vector keyWords) {
        int i2 = 0;
        while (i2 < keyWords.size()) {
            Vector row = new Vector(2);
            row.addElement(keyWords.elementAt(i2));
            row.addElement(new Boolean(false));
            this.data.addElement(row);
            ++i2;
        }
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public Object getValueAt(int row, int col) {
        Vector myRow = new Vector(2);
        if (row < this.data.size() & col < 2) {
            myRow = (Vector)this.data.elementAt(row);
            return myRow.elementAt(col);
        }
        return null;
    }

    public Class getColumnClass(int c2) {
        return this.types[c2];
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col == 1;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (row < this.getRowCount() & col < 2) {
            Vector myRow = new Vector(2);
            myRow = (Vector)this.data.elementAt(row);
            myRow.setElementAt(value, col);
            this.data.setElementAt(myRow, row);
            TableModelEvent evento = new TableModelEvent(this, row, row, 0, 0);
            this.tellListeners(evento);
        }
    }

    public Vector returnData() {
        return (Vector)this.data.clone();
    }

    public void addElement(String element) {
        Vector<Object> newRow = new Vector<Object>(2);
        if (!this.isElement(element)) {
            newRow.add(element);
            newRow.add(new Boolean(true));
            int i2 = 0;
            boolean inserted = false;
            while (i2 < this.data.size() && !inserted) {
                if (TIGTableModel.order((String)this.getValueAt(i2, 0)).compareTo(TIGTableModel.order(element)) > 0) {
                    this.data.insertElementAt(newRow, i2);
                    inserted = true;
                    continue;
                }
                ++i2;
            }
            if (!inserted) {
                this.data.addElement(newRow);
            }
            TableModelEvent evento = new TableModelEvent(this, this.getRowCount() - 1, this.getRowCount() - 1, -1, 1);
            this.tellListeners(evento);
        } else {
            this.setValueAt(new Boolean(true), this.whereIsElement(element), 1);
        }
    }

    public boolean isElement(String word) {
        boolean is = false;
        int i2 = 0;
        while (i2 < this.data.size() && !is) {
            if (TIGTableModel.order(word).equals(TIGTableModel.order((String)this.getValueAt(i2, 0)))) {
                is = true;
                continue;
            }
            ++i2;
        }
        return is;
    }

    public int whereIsElement(String word) {
        boolean is = false;
        int i2 = 0;
        while (i2 < this.data.size() && !is) {
            if (TIGTableModel.order(word).equals(TIGTableModel.order((String)this.getValueAt(i2, 0)))) {
                is = true;
                continue;
            }
            ++i2;
        }
        if (is) {
            return i2;
        }
        return 0;
    }

    public void deleteKeyWord(int row) {
        this.data.remove(row);
        TableModelEvent evento = new TableModelEvent(this, row, row, -1, -1);
        this.tellListeners(evento);
    }

    @Override
    public void addTableModelListener(TableModelListener l2) {
        this.listeners.add(l2);
    }

    private void tellListeners(TableModelEvent evento) {
        int i2 = 0;
        while (i2 < this.listeners.size()) {
            ((TableModelListener)this.listeners.get(i2)).tableChanged(evento);
            ++i2;
        }
    }

    public void updateTable(int row) {
        TableModelEvent evento = new TableModelEvent(this, row, row, -1, -1);
        this.tellListeners(evento);
    }

    private static String order(String word) {
        String result = word.replace(' ', '_').replace(',', '-').replace('\u00e1', 'a').replace('\u00e9', 'e').replace('\u00ed', 'i').replace('\u00f3', 'o').replace('\u00fa', 'u').replace('\u00c1', 'A').replace('\u00c9', 'E').replace('\u00cd', 'I').replace('\u00d3', 'O').replace('\u00da', 'U').toLowerCase();
        return result;
    }
}

