/*
 * Decompiled with CFR 0.152.
 */
package tico.imageGallery.tasks;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import tico.configuration.TLanguage;
import tico.editor.TEditor;
import tico.imageGallery.dataBase.TIGDataBase;
import tico.imageGallery.tasks.SwingWorker;

public class TIGImportTask {
    private int lengthOfTask = 1000;
    private int current = 0;
    private String statMessage;
    private TEditor myEditor;
    private TIGDataBase myDataBase;
    private String myDirectoryPath;
    private String myImagesBehaviour;
    private String errorImages = "";
    private boolean stop = false;
    private boolean cancel = false;
    private boolean running = false;

    public void go(TEditor editor, TIGDataBase dataBase, String directoryPath, String imagesBehaviour) {
        this.current = 0;
        this.running = true;
        this.myEditor = editor;
        this.myDataBase = dataBase;
        this.myDirectoryPath = directoryPath;
        this.myImagesBehaviour = imagesBehaviour;
        SwingWorker worker = new SwingWorker(){

            @Override
            public Object construct() {
                return new ActualTask(TIGImportTask.this.myEditor, TIGImportTask.this.myDataBase, TIGImportTask.this.myDirectoryPath, TIGImportTask.this.myImagesBehaviour);
            }
        };
    }

    public int getLengthOfTask() {
        return this.lengthOfTask;
    }

    public void setLengthOfTask(int num) {
        this.lengthOfTask = num;
    }

    public int getCurrent() {
        return this.current;
    }

    public String getErrorImages() {
        return this.errorImages;
    }

    public void stop() {
        this.stop = true;
        this.running = false;
    }

    public void cancel() {
        this.cancel = true;
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean done() {
        return this.current >= this.lengthOfTask;
    }

    public String getMessage() {
        return this.statMessage;
    }

    private boolean exists(String[] list, String name) {
        boolean exists = false;
        int i2 = 0;
        while (i2 < list.length && !exists) {
            exists = name.equals(list[i2]);
            ++i2;
        }
        return exists;
    }

    public class ActualTask {
        public ActualTask(TEditor editor, TIGDataBase dataBase, String directoryPath, String myImagesBehaviour) {
            File myDirectory = new File(directoryPath);
            String[] list = myDirectory.list();
            File fileXML = new File(String.valueOf(directoryPath) + "images.xml");
            SAXBuilder builder = new SAXBuilder(false);
            try {
                Document docXML = builder.build(fileXML);
                Element root = docXML.getRootElement();
                List images = root.getChildren("image");
                Iterator j2 = images.iterator();
                int i2 = 0;
                TIGDataBase.activateTransactions();
                while (j2.hasNext() && !TIGImportTask.this.stop && !TIGImportTask.this.cancel) {
                    TIGImportTask.this.current = i2;
                    ++i2;
                    Element image = (Element)j2.next();
                    String name = image.getAttributeValue("name");
                    List categories = image.getChildren("category");
                    Iterator k2 = categories.iterator();
                    if (TIGImportTask.this.exists(list, name)) {
                        Vector<Vector<String>> aux;
                        String pathSrc = directoryPath.concat(name);
                        String pathDst = String.valueOf(System.getProperty("user.dir")) + File.separator + "images" + File.separator + name.substring(0, 1).toUpperCase() + File.separator;
                        String folder = String.valueOf(System.getProperty("user.dir")) + File.separator + "images" + File.separator + name.substring(0, 1).toUpperCase();
                        if (myImagesBehaviour.equals(TLanguage.getString("TIGImportDBDialog.REPLACE_IMAGES"))) {
                            aux = TIGDataBase.imageSearchByName(name.substring(0, name.lastIndexOf(46)));
                            if (aux.size() != 0) {
                                int idImage = TIGDataBase.imageKeySearchName(name.substring(0, name.lastIndexOf(46)));
                                TIGDataBase.deleteAsociatedOfImage(idImage);
                            }
                            pathDst = pathDst.concat(name);
                        }
                        if (myImagesBehaviour.equals(TLanguage.getString("TIGImportDBDialog.ADD_IMAGES"))) {
                            aux = new Vector();
                            aux = TIGDataBase.imageSearchByName(name.substring(0, name.lastIndexOf(46)));
                            int fileCount = 0;
                            if (aux.size() != 0) {
                                while (aux.size() != 0) {
                                    aux = TIGDataBase.imageSearchByName(String.valueOf(name.substring(0, name.lastIndexOf(46))) + "_" + ++fileCount);
                                }
                                pathDst = String.valueOf(pathDst) + name.substring(0, name.lastIndexOf(46)) + '_' + fileCount + name.substring(name.lastIndexOf(46), name.length());
                                name = String.valueOf(name.substring(0, name.lastIndexOf(46))) + '_' + fileCount + name.substring(name.lastIndexOf(46), name.length());
                            } else {
                                pathDst = pathDst.concat(name);
                            }
                        }
                        String pathThumbnail = pathDst.substring(0, pathDst.lastIndexOf(".")).concat("_th.jpg");
                        File newDirectoryFolder = new File(folder);
                        if (!newDirectoryFolder.exists()) {
                            newDirectoryFolder.mkdirs();
                        }
                        try {
                            FileChannel srcChannel = new FileInputStream(pathSrc).getChannel();
                            FileChannel dstChannel = new FileOutputStream(pathDst).getChannel();
                            dstChannel.transferFrom(srcChannel, 0L, srcChannel.size());
                            srcChannel.close();
                            dstChannel.close();
                        }
                        catch (IOException exc) {
                            System.out.println(exc.getMessage());
                            System.out.println(exc.toString());
                        }
                        TIGDataBase.insertImageDB(name.substring(0, name.lastIndexOf(46)), name);
                        int idImage = TIGDataBase.imageKeySearchName(name.substring(0, name.lastIndexOf(46)));
                        while (k2.hasNext()) {
                            Element category = (Element)k2.next();
                            int idCategory = TIGDataBase.insertConceptDB(category.getValue());
                            TIGDataBase.insertAsociatedDB(idCategory, idImage);
                        }
                        continue;
                    }
                    TIGImportTask.this.errorImages = String.valueOf(TIGImportTask.this.errorImages) + System.getProperty("line.separator") + name;
                }
                TIGDataBase.executeQueries();
                TIGImportTask.this.current = TIGImportTask.this.lengthOfTask;
            }
            catch (JDOMException e2) {
                e2.printStackTrace();
            }
            catch (IOException e3) {
                e3.printStackTrace();
            }
        }
    }
}

