/*
 * Decompiled with CFR 0.152.
 */
package tico.imageGallery.tasks;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.util.Vector;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;
import tico.editor.TEditor;
import tico.imageGallery.dataBase.TIGDataBase;
import tico.imageGallery.tasks.SwingWorker;

public class TIGExportTask {
    private int lengthOfTask = 1000;
    private int current = 0;
    private String statMessage;
    private TEditor myEditor;
    private TIGDataBase myDataBase;
    private String myDirectoryPath;
    private boolean stop = false;
    private boolean cancel = false;
    private boolean running = false;
    private Vector myImages;

    public void go(TEditor editor, TIGDataBase dataBase, String directoryPath, Vector images) {
        this.current = 0;
        this.running = true;
        this.myEditor = editor;
        this.myDataBase = dataBase;
        this.myDirectoryPath = directoryPath;
        this.myImages = images;
        SwingWorker worker = new SwingWorker(){

            @Override
            public Object construct() {
                return new ActualTask(TIGExportTask.this.myEditor, TIGExportTask.this.myDataBase, TIGExportTask.this.myDirectoryPath, TIGExportTask.this.myImages);
            }
        };
    }

    public int getLengthOfTask() {
        return this.lengthOfTask;
    }

    public void setLengthOfTask(int num) {
        this.lengthOfTask = num;
    }

    public int getCurrent() {
        return this.current;
    }

    public void stop() {
        this.stop = true;
        this.running = false;
    }

    public void cancel() {
        this.cancel = true;
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean done() {
        return this.current >= this.lengthOfTask;
    }

    public String getMessage() {
        return this.statMessage;
    }

    public class ActualTask {
        public ActualTask(TEditor editor, TIGDataBase dataBase, String directoryPath, Vector images) {
            TIGExportTask.this.lengthOfTask = images.size();
            Element dataBaseXML = new Element("dataBase");
            int i2 = 0;
            while (i2 < images.size() && !TIGExportTask.this.stop && !TIGExportTask.this.cancel) {
                Vector imagen = new Vector(2);
                imagen = (Vector)images.elementAt(i2);
                String element = (String)imagen.elementAt(0);
                TIGExportTask.this.current = i2;
                String pathSrc = String.valueOf(System.getProperty("user.dir")) + File.separator + "images" + File.separator + element.substring(0, 1).toUpperCase() + File.separator + element;
                String name = pathSrc.substring(pathSrc.lastIndexOf(File.separator) + 1, pathSrc.length());
                String pathDst = String.valueOf(directoryPath) + name;
                try {
                    FileChannel srcChannel = new FileInputStream(pathSrc).getChannel();
                    FileChannel dstChannel = new FileOutputStream(pathDst).getChannel();
                    dstChannel.transferFrom(srcChannel, 0L, srcChannel.size());
                    srcChannel.close();
                    dstChannel.close();
                }
                catch (IOException exc) {
                    System.out.println(exc.getMessage());
                    System.out.println(exc.toString());
                }
                Vector<Object> keyWords = new Vector();
                keyWords = TIGDataBase.asociatedConceptSearch(element);
                Element image = new Element("image");
                image.setAttribute("name", name);
                if (keyWords.size() != 0) {
                    int k2 = 0;
                    while (k2 < keyWords.size()) {
                        Element category = new Element("category");
                        category.setText(((String)keyWords.get(k2)).trim());
                        image.addContent(category);
                        ++k2;
                    }
                }
                dataBaseXML.addContent(image);
                ++i2;
            }
            Document doc = new Document(dataBaseXML);
            try {
                XMLOutputter out = new XMLOutputter();
                FileOutputStream f2 = new FileOutputStream(String.valueOf(directoryPath) + "images.xml");
                out.output(doc, (OutputStream)f2);
                f2.flush();
                f2.close();
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            TIGExportTask.this.current = TIGExportTask.this.lengthOfTask;
        }
    }
}

