/*
 * Decompiled with CFR 0.152.
 */
package tico.imageGallery.dialogs;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import tico.components.TButton;
import tico.components.TDialog;
import tico.configuration.TLanguage;
import tico.editor.TEditor;
import tico.imageGallery.components.TIGSearchKeyWord;
import tico.imageGallery.components.TIGSearchName;
import tico.imageGallery.components.TIGThumbnails;
import tico.imageGallery.dataBase.TIGDataBase;
import tico.imageGallery.dialogs.TIGImageDataDialog;

public class TIGModifyImageDialog
extends TDialog {
    private ImageIcon icon;
    private TEditor myEditor;
    private String imagePath;
    private Vector<Vector<String>> images;
    private TIGThumbnails thumbnailsDialog;
    private JPanel thumbnailsPanel;
    private TIGDataBase myDataBase;
    private GridBagConstraints c = new GridBagConstraints();

    public TIGModifyImageDialog(TEditor editor, TIGDataBase dataBase) {
        super((Frame)editor, true);
        this.myEditor = editor;
        this.myDataBase = dataBase;
        TIGDataBase.conectDB();
        this.addWindowListener(new WindowListener(){

            @Override
            public void windowClosing(WindowEvent e2) {
                TIGModifyImageDialog.this.dispose();
            }

            @Override
            public void windowActivated(WindowEvent e2) {
            }

            @Override
            public void windowDeactivated(WindowEvent e2) {
            }

            @Override
            public void windowDeiconified(WindowEvent e2) {
            }

            @Override
            public void windowIconified(WindowEvent e2) {
            }

            @Override
            public void windowOpened(WindowEvent e2) {
            }

            @Override
            public void windowClosed(WindowEvent e2) {
            }
        });
        this.setDefaultCloseOperation(2);
        this.setTitle(TLanguage.getString("TIGSearchImageDialog.NAME"));
        this.images = TIGDataBase.imageSearchByName("*");
        this.thumbnailsPanel = new JPanel();
        this.thumbnailsDialog = new TIGThumbnails(true);
        this.thumbnailsPanel = this.thumbnailsDialog.createThumbnailsPanel(this.images, true);
        TIGSearchName searchNamePanel = new TIGSearchName(this.thumbnailsDialog);
        TIGSearchKeyWord keyWordSearchPanel = new TIGSearchKeyWord(this.thumbnailsDialog);
        this.images = new Vector();
        JPanel buttons = new JPanel();
        TButton modifyButton = new TButton(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TIGModifyImageDialog.this.icon = TIGModifyImageDialog.this.thumbnailsDialog.imageSelected();
                TIGModifyImageDialog.this.imagePath = TIGModifyImageDialog.this.thumbnailsDialog.pathImageSelected();
                if (TIGModifyImageDialog.this.icon == null) {
                    JOptionPane.showConfirmDialog(null, TLanguage.getString("TIGSearchImageDialog.MESSAGE"), TLanguage.getString("TIGSearchImageDialog.ERROR"), -1, 2);
                } else {
                    TIGImageDataDialog imageData = new TIGImageDataDialog(TIGModifyImageDialog.this.myEditor, TIGModifyImageDialog.this.myDataBase, TIGModifyImageDialog.this.icon, TIGModifyImageDialog.this.imagePath);
                    TIGModifyImageDialog.this.thumbnailsPanel = TIGModifyImageDialog.this.thumbnailsDialog.updateThumbnailsPanel();
                }
            }
        });
        modifyButton.setText(TLanguage.getString("TIGSearchImageDialog.MODIFY"));
        TButton deleteButton = new TButton(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TIGModifyImageDialog.this.icon = TIGModifyImageDialog.this.thumbnailsDialog.imageSelected();
                TIGModifyImageDialog.this.imagePath = TIGModifyImageDialog.this.thumbnailsDialog.pathImageSelected();
                if (TIGModifyImageDialog.this.icon == null) {
                    JOptionPane.showConfirmDialog(null, TLanguage.getString("TIGSearchImageDialog.MESSAGE"), TLanguage.getString("TIGSearchImageDialog.ERROR"), -1, 2);
                } else {
                    int choosenOption = JOptionPane.showConfirmDialog(null, TLanguage.getString("TIGSearchImageDialog.ASK"), TLanguage.getString("TIGSearchImageDialog.DELETE"), 1);
                    if (choosenOption == 0) {
                        int key = TIGDataBase.imageKeySearch(TIGModifyImageDialog.this.imagePath);
                        TIGDataBase.deleteImageDB(key);
                        File image = new File("images" + File.separator + TIGModifyImageDialog.this.imagePath.substring(0, 1).toUpperCase() + File.separator + TIGModifyImageDialog.this.imagePath);
                        image.delete();
                        File imageTh = new File("images" + File.separator + TIGModifyImageDialog.this.imagePath.substring(0, 1).toUpperCase() + File.separator + TIGModifyImageDialog.this.imagePath.substring(0, TIGModifyImageDialog.this.imagePath.lastIndexOf(46)) + "_th.jpg");
                        imageTh.delete();
                        TIGModifyImageDialog.this.thumbnailsPanel = TIGModifyImageDialog.this.thumbnailsDialog.deleteImage();
                    }
                }
            }
        });
        deleteButton.setText(TLanguage.getString("TIGSearchImageDialog.DELETE"));
        TButton cancelButton = new TButton(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TIGModifyImageDialog.this.dispose();
            }
        });
        cancelButton.setText(TLanguage.getString("TIGSearchImageDialog.END"));
        ButtonGroup actionGroup = new ButtonGroup();
        actionGroup.add(modifyButton);
        actionGroup.add(deleteButton);
        actionGroup.add(cancelButton);
        GridBagConstraints but = new GridBagConstraints();
        buttons.setLayout(new GridBagLayout());
        but.fill = 1;
        but.insets = new Insets(10, 10, 10, 10);
        but.gridx = 0;
        but.gridy = 0;
        buttons.add((Component)modifyButton, but);
        but.fill = 1;
        but.insets = new Insets(10, 10, 10, 10);
        but.gridx = 1;
        but.gridy = 0;
        buttons.add((Component)deleteButton, but);
        but.fill = 1;
        but.insets = new Insets(10, 10, 10, 10);
        but.gridx = 2;
        but.gridy = 0;
        buttons.add((Component)cancelButton, but);
        this.getContentPane().setLayout(new GridBagLayout());
        this.c.fill = 1;
        this.c.insets = new Insets(10, 10, 10, 10);
        this.c.gridx = 0;
        this.c.gridy = 0;
        this.getContentPane().add((Component)keyWordSearchPanel, this.c);
        this.c.fill = 1;
        this.c.insets = new Insets(10, 10, 10, 10);
        this.c.gridx = 0;
        this.c.gridy = 1;
        this.getContentPane().add((Component)searchNamePanel, this.c);
        this.c.fill = 1;
        this.c.insets = new Insets(10, 10, 10, 10);
        this.c.gridx = 0;
        this.c.gridy = 2;
        this.getContentPane().add((Component)this.thumbnailsPanel, this.c);
        this.c.fill = 0;
        this.c.insets = new Insets(10, 10, 10, 10);
        this.c.gridx = 0;
        this.c.gridy = 3;
        this.getContentPane().add((Component)buttons, this.c);
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.pack();
        this.setLocationRelativeTo(editor);
        this.setVisible(true);
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public void update(Vector result) {
        this.thumbnailsPanel = this.thumbnailsDialog.updateThumbnailsPanel(result, 0);
    }
}

