/*
 * Decompiled with CFR 0.152.
 */
package tico.imageGallery.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import tico.components.TButton;
import tico.components.TDialog;
import tico.configuration.TLanguage;
import tico.editor.TEditor;
import tico.imageGallery.actions.TIGInsertImageAction;
import tico.imageGallery.components.TIGInsertKeyWord;
import tico.imageGallery.components.TIGSelectNewImage;
import tico.imageGallery.dataBase.TIGDataBase;

public class TIGManageGalleryDialog
extends TDialog {
    protected TEditor myEditor;
    protected String image;
    protected String name;
    protected Vector concepts;
    protected TIGSelectNewImage imagePanel;
    protected JPanel repeatedImages;
    protected ButtonGroup imagesBehaviour;
    protected TIGInsertKeyWord keyWordPanel;
    protected TIGDataBase myDataBase;

    public TIGManageGalleryDialog(TEditor editor, TIGDataBase dataBase) {
        super(editor, TLanguage.getString("TIGManageGalleryDialog.NAME"), true);
        this.myEditor = editor;
        this.myDataBase = dataBase;
        TIGDataBase.conectDB();
        this.addWindowListener(new WindowListener(){

            @Override
            public void windowClosing(WindowEvent e2) {
                TIGManageGalleryDialog.this.dispose();
            }

            @Override
            public void windowActivated(WindowEvent e2) {
            }

            @Override
            public void windowDeactivated(WindowEvent e2) {
            }

            @Override
            public void windowDeiconified(WindowEvent e2) {
            }

            @Override
            public void windowIconified(WindowEvent e2) {
            }

            @Override
            public void windowOpened(WindowEvent e2) {
            }

            @Override
            public void windowClosed(WindowEvent e2) {
            }
        });
        this.imagePanel = new TIGSelectNewImage(TLanguage.getString("TIGManageGalleryDialog.IMAGE"));
        this.repeatedImages = new JPanel(new GridLayout(1, 0));
        this.repeatedImages.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.WHITE, new Color(165, 163, 151)), TLanguage.getString("TIGManageGalleryDialog.REPEATED_IMAGES_TITLE")));
        this.imagesBehaviour = new ButtonGroup();
        JRadioButton replaceImages = new JRadioButton(TLanguage.getString("TIGManageGalleryDialog.REPLACE_IMAGE"), true);
        replaceImages.setActionCommand(TLanguage.getString("TIGManageGalleryDialog.REPLACE_IMAGE"));
        JRadioButton renameImages = new JRadioButton(TLanguage.getString("TIGManageGalleryDialog.ADD_IMAGE"), false);
        renameImages.setActionCommand(TLanguage.getString("TIGManageGalleryDialog.ADD_IMAGE"));
        this.imagesBehaviour.add(replaceImages);
        this.imagesBehaviour.add(renameImages);
        this.repeatedImages.add(replaceImages);
        this.repeatedImages.add(renameImages);
        this.keyWordPanel = new TIGInsertKeyWord();
        JPanel buttons = new JPanel();
        TButton insertButton = new TButton(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TIGManageGalleryDialog.this.image = TIGManageGalleryDialog.this.imagePanel.returnImage();
                if (TIGManageGalleryDialog.this.image != null) {
                    TIGManageGalleryDialog.this.concepts = TIGManageGalleryDialog.this.keyWordPanel.returnKeyWords();
                    String behaviour = TIGManageGalleryDialog.this.imagesBehaviour.getSelection().getActionCommand();
                    TIGInsertImageAction action = new TIGInsertImageAction(TIGManageGalleryDialog.this.myEditor, TIGManageGalleryDialog.this.concepts, TIGManageGalleryDialog.this.image, TIGManageGalleryDialog.this.myDataBase, behaviour);
                    action.actionPerformed(e2);
                }
                TIGManageGalleryDialog.this.dispose();
            }
        });
        insertButton.setText(TLanguage.getString("TIGManageGalleryDialog.END"));
        TButton cancelButton = new TButton(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TIGManageGalleryDialog.this.dispose();
            }
        });
        cancelButton.setText(TLanguage.getString("TIGManageGalleryDialog.CANCEL"));
        GridBagConstraints but = new GridBagConstraints();
        buttons.setLayout(new GridBagLayout());
        but.fill = 10;
        but.insets = new Insets(5, 5, 5, 5);
        but.gridx = 1;
        but.gridy = 0;
        buttons.add((Component)insertButton, but);
        but.fill = 10;
        but.insets = new Insets(5, 5, 5, 5);
        but.gridx = 2;
        but.gridy = 0;
        buttons.add((Component)cancelButton, but);
        GridBagConstraints c2 = new GridBagConstraints();
        this.getContentPane().setLayout(new GridBagLayout());
        c2.fill = 10;
        c2.insets = new Insets(5, 5, 5, 5);
        c2.gridx = 0;
        c2.gridy = 0;
        this.getContentPane().add((Component)this.imagePanel, c2);
        c2.fill = 1;
        c2.insets = new Insets(5, 5, 5, 5);
        c2.gridx = 0;
        c2.gridy = 1;
        this.getContentPane().add((Component)this.repeatedImages, c2);
        c2.fill = 1;
        c2.insets = new Insets(5, 5, 5, 5);
        c2.gridx = 0;
        c2.gridy = 2;
        this.getContentPane().add((Component)this.keyWordPanel, c2);
        c2.fill = 0;
        c2.insets = new Insets(5, 5, 5, 5);
        c2.gridx = 0;
        c2.gridy = 3;
        this.getContentPane().add((Component)buttons, c2);
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.pack();
        this.setLocationRelativeTo(editor);
        this.setVisible(true);
    }
}

