/*
 * Decompiled with CFR 0.152.
 */
package tico.imageGallery.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.border.TitledBorder;
import tico.components.TButton;
import tico.components.TDialog;
import tico.configuration.TLanguage;
import tico.editor.TEditor;
import tico.imageGallery.actions.TIGAddKeyWordAction;
import tico.imageGallery.actions.TIGDeleteKeyWordAction;
import tico.imageGallery.actions.TIGUpdateKeyWordAction;
import tico.imageGallery.dataBase.TIGDataBase;
import tico.imageGallery.tasks.TIGTableModelOneColumn;

public class TIGKeyWordGalleryDialog
extends TDialog {
    private GridBagConstraints c;
    private JPanel keyWordsPanel;
    private JPanel buttonPanel;
    private TButton addButton;
    private TButton modifyButton;
    private TButton deleteButton;
    private TButton acceptButton;
    private JTextField text;
    private JTable table;
    private TIGTableModelOneColumn myModel;
    private JScrollPane scrollPaneList;
    protected Vector keyWordList;
    private TEditor editor;
    private TIGDataBase myDataBase;

    public TIGKeyWordGalleryDialog(TEditor editor, TIGDataBase dataBase) {
        super(editor, TLanguage.getString("TIGKeyWordGalleryDialog.NAME"), true);
        this.editor = editor;
        this.myDataBase = dataBase;
        TIGDataBase.conectDB();
        this.addWindowListener(new WindowListener(){

            @Override
            public void windowClosing(WindowEvent e2) {
                TIGKeyWordGalleryDialog.this.dispose();
            }

            @Override
            public void windowActivated(WindowEvent e2) {
            }

            @Override
            public void windowDeactivated(WindowEvent e2) {
            }

            @Override
            public void windowDeiconified(WindowEvent e2) {
            }

            @Override
            public void windowIconified(WindowEvent e2) {
            }

            @Override
            public void windowOpened(WindowEvent e2) {
            }

            @Override
            public void windowClosed(WindowEvent e2) {
            }
        });
        this.createWordPanel();
        this.acceptButton = new TButton(new AbstractAction(TLanguage.getString("TIGKeyWordGalleryDialog.END")){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TIGKeyWordGalleryDialog.this.dispose();
            }
        });
        this.c = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        this.c.fill = 10;
        this.c.insets = new Insets(5, 30, 5, 30);
        this.c.weightx = 1.0;
        this.c.weighty = 0.0;
        this.c.gridx = 0;
        this.c.gridy = 1;
        this.add((Component)this.keyWordsPanel, this.c);
        this.c.fill = 10;
        this.c.insets = new Insets(5, 30, 5, 30);
        this.c.weightx = 1.0;
        this.c.weighty = 0.0;
        this.c.gridx = 0;
        this.c.gridy = 2;
        this.add((Component)this.acceptButton, this.c);
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.pack();
        this.setLocationRelativeTo(editor);
        this.setVisible(true);
    }

    private void createWordPanel() {
        this.keyWordsPanel = new JPanel();
        this.keyWordsPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.WHITE, new Color(165, 163, 151))));
        this.keyWordList = new Vector();
        this.keyWordList = TIGDataBase.getKeyWords();
        this.myModel = new TIGTableModelOneColumn(this.keyWordList);
        this.table = new JTable(this.myModel);
        ListSelectionModel selection = this.table.getSelectionModel();
        selection.setSelectionMode(0);
        this.table.setSelectionModel(selection);
        this.table.setPreferredScrollableViewportSize(new Dimension(168, 302));
        this.scrollPaneList = new JScrollPane(this.table);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e2) {
                TIGKeyWordGalleryDialog.this.text.setText((String)TIGKeyWordGalleryDialog.this.myModel.getValueAt(TIGKeyWordGalleryDialog.this.table.getSelectedRow(), 0));
            }
        });
        this.table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e2) {
                char letter = e2.getKeyChar();
                int i2 = 0;
                if ('A' < letter && letter < 'z') {
                    i2 = TIGKeyWordGalleryDialog.this.getVectorIndex(letter);
                    TIGKeyWordGalleryDialog.this.table.setRowSelectionInterval(i2, i2);
                    Rectangle r2 = TIGKeyWordGalleryDialog.this.table.getCellRect(i2, 0, false);
                    TIGKeyWordGalleryDialog.this.scrollPaneList.getViewport().scrollRectToVisible(r2);
                }
                TIGKeyWordGalleryDialog.this.text.setText((String)TIGKeyWordGalleryDialog.this.myModel.getValueAt(TIGKeyWordGalleryDialog.this.table.getSelectedRow(), 0));
            }
        });
        this.text = new JTextField();
        this.text.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e2) {
            }
        });
        this.text.setEditable(true);
        this.text.setPreferredSize(new Dimension(174, 25));
        this.buttonPanel = new JPanel();
        this.addButton = new TButton(new AbstractAction(TLanguage.getString("TIGKeyWordGalleryDialog.ADD")){

            @Override
            public void actionPerformed(ActionEvent e2) {
                String theText = TIGKeyWordGalleryDialog.this.text.getText();
                if (theText.contains(",")) {
                    String[] temp = null;
                    temp = theText.split(",");
                    int i2 = 0;
                    while (i2 < temp.length) {
                        String item = temp[i2].trim();
                        if (!TIGKeyWordGalleryDialog.this.myModel.isElement(item) && item.compareToIgnoreCase("") != 0) {
                            TIGKeyWordGalleryDialog.this.myModel.addElement(item);
                            TIGAddKeyWordAction action = new TIGAddKeyWordAction(TIGKeyWordGalleryDialog.this.editor, item, TIGKeyWordGalleryDialog.this.myDataBase);
                            action.actionPerformed(e2);
                        }
                        ++i2;
                    }
                } else if (!TIGKeyWordGalleryDialog.this.myModel.isElement(theText) && theText.compareToIgnoreCase("") != 0) {
                    TIGKeyWordGalleryDialog.this.myModel.addElement(theText);
                    TIGAddKeyWordAction action = new TIGAddKeyWordAction(TIGKeyWordGalleryDialog.this.editor, theText, TIGKeyWordGalleryDialog.this.myDataBase);
                    action.actionPerformed(e2);
                }
                TIGKeyWordGalleryDialog.this.text.setText("");
            }
        });
        this.modifyButton = new TButton(new AbstractAction(TLanguage.getString("TIGKeyWordGalleryDialog.MODIFY")){

            @Override
            public void actionPerformed(ActionEvent e2) {
                String newConcept;
                String oldConcept;
                if (TIGKeyWordGalleryDialog.this.text.getText().compareTo("") != 0 && TIGKeyWordGalleryDialog.this.text.getText().compareTo("Todas") != 0 && TIGKeyWordGalleryDialog.this.table.getSelectedRow() > 0 && (oldConcept = (String)TIGKeyWordGalleryDialog.this.myModel.getValueAt(TIGKeyWordGalleryDialog.this.table.getSelectedRow(), 0)).compareTo(newConcept = TIGKeyWordGalleryDialog.this.text.getText()) != 0) {
                    TIGUpdateKeyWordAction action = new TIGUpdateKeyWordAction(TIGKeyWordGalleryDialog.this.editor, TIGKeyWordGalleryDialog.this.myDataBase, oldConcept, newConcept);
                    action.actionPerformed(e2);
                    TIGKeyWordGalleryDialog.this.myModel.setValueAt(newConcept, TIGKeyWordGalleryDialog.this.table.getSelectedRow());
                }
                TIGKeyWordGalleryDialog.this.text.setText("");
            }
        });
        this.deleteButton = new TButton(new AbstractAction(TLanguage.getString("TIGKeyWordGalleryDialog.DELETE")){

            @Override
            public void actionPerformed(ActionEvent e2) {
                if (TIGKeyWordGalleryDialog.this.text.getText().compareTo("") != 0 && TIGKeyWordGalleryDialog.this.text.getText().compareTo("Todas") != 0 && TIGKeyWordGalleryDialog.this.myModel.isElement(TIGKeyWordGalleryDialog.this.text.getText())) {
                    String theText = TIGKeyWordGalleryDialog.this.text.getText();
                    TIGDeleteKeyWordAction action = new TIGDeleteKeyWordAction(TIGKeyWordGalleryDialog.this.editor, theText, TIGKeyWordGalleryDialog.this.myDataBase);
                    action.actionPerformed(e2);
                    if (action.delete() != 0) {
                        TIGKeyWordGalleryDialog.this.myModel.deleteKeyWord2(theText);
                    }
                }
                TIGKeyWordGalleryDialog.this.text.setText("");
            }
        });
        this.buttonPanel.add(this.addButton);
        this.buttonPanel.add(this.modifyButton);
        this.buttonPanel.add(this.deleteButton);
        this.c = new GridBagConstraints();
        this.keyWordsPanel.setLayout(new GridBagLayout());
        this.c.fill = 1;
        this.c.insets = new Insets(5, 30, 5, 30);
        this.c.gridx = 0;
        this.c.gridy = 0;
        this.keyWordsPanel.add((Component)this.scrollPaneList, this.c);
        this.c.fill = 1;
        this.c.insets = new Insets(5, 30, 5, 30);
        this.c.gridx = 0;
        this.c.gridy = 1;
        this.keyWordsPanel.add((Component)this.text, this.c);
        this.c.fill = 1;
        this.c.insets = new Insets(5, 10, 5, 10);
        this.c.gridx = 0;
        this.c.gridy = 2;
        this.keyWordsPanel.add((Component)this.buttonPanel, this.c);
    }

    protected int getVectorIndex(char letter) {
        int i2 = 0;
        boolean founded = false;
        while (i2 < this.keyWordList.size() && !founded) {
            String name = TIGKeyWordGalleryDialog.order((String)this.keyWordList.elementAt(i2));
            if (name.charAt(0) >= letter) {
                founded = true;
                continue;
            }
            ++i2;
        }
        if (!founded) {
            --i2;
        }
        return i2;
    }

    private static String order(String word) {
        String result = word.replace(' ', '_').replace(',', '-').replace('\u00e1', 'a').replace('\u00e9', 'e').replace('\u00ed', 'i').replace('\u00f3', 'o').replace('\u00fa', 'u').replace('\u00c1', 'A').replace('\u00c9', 'E').replace('\u00cd', 'I').replace('\u00d3', 'O').replace('\u00da', 'U').toLowerCase();
        return result;
    }
}

