/*
 * Decompiled with CFR 0.152.
 */
package tico.imageGallery.dialogs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.border.TitledBorder;
import tico.components.TButton;
import tico.components.TDialog;
import tico.configuration.TLanguage;
import tico.editor.TEditor;
import tico.imageGallery.dataBase.TIGDataBase;
import tico.imageGallery.tasks.TIGImportTask;

public class TIGImportDBDialog
extends TDialog {
    private GridBagConstraints c;
    private TButton importButton;
    private TButton openButton;
    private TButton exitButton;
    private ButtonGroup imagesBehaviour;
    private JTextField directory;
    private JTextField text;
    private TIGDataBase myDataBase;
    private String pathImages;
    private static File defaultDirectory = null;
    private TEditor myEditor;
    public static final int ONE_SECOND = 1000;
    private Timer timer;
    private JProgressBar progressBar;
    private TIGImportTask task;
    private JPanel contentPane;
    private boolean stop = false;
    private boolean cancel = false;

    public TIGImportDBDialog(TEditor editor, TIGDataBase dataBase) {
        super(editor, TLanguage.getString("TIGImportDBDialog.NAME"), true);
        this.myEditor = editor;
        this.myDataBase = dataBase;
        this.addWindowListener(new WindowListener(){

            @Override
            public void windowClosing(WindowEvent e2) {
                if (TIGImportDBDialog.this.task.isRunning()) {
                    TIGImportDBDialog.this.stop = true;
                    TIGImportDBDialog.this.cancel = true;
                    JOptionPane.showConfirmDialog(null, TLanguage.getString("TIGOperationDB.CANCELED"), "", -1, 1);
                }
                TIGImportDBDialog.this.dispose();
            }

            @Override
            public void windowActivated(WindowEvent e2) {
            }

            @Override
            public void windowDeactivated(WindowEvent e2) {
            }

            @Override
            public void windowDeiconified(WindowEvent e2) {
            }

            @Override
            public void windowIconified(WindowEvent e2) {
            }

            @Override
            public void windowOpened(WindowEvent e2) {
            }

            @Override
            public void windowClosed(WindowEvent e2) {
            }
        });
        this.task = new TIGImportTask();
        this.contentPane = this.createProgressDialog();
        JPanel setDirectory = new JPanel();
        setDirectory.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.WHITE, new Color(165, 163, 151)), TLanguage.getString("TIGImportDBDialog.IMAGES_SEL")));
        JPanel buttons = new JPanel();
        JPanel repeatedImages = new JPanel(new GridLayout(1, 0));
        repeatedImages.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.WHITE, new Color(165, 163, 151)), TLanguage.getString("TIGImportDBDialog.REPEATED_IMAGES_TITLE")));
        this.imagesBehaviour = new ButtonGroup();
        JRadioButton replaceImages = new JRadioButton(TLanguage.getString("TIGImportDBDialog.REPLACE_IMAGES"), true);
        replaceImages.setActionCommand(TLanguage.getString("TIGImportDBDialog.REPLACE_IMAGES"));
        JRadioButton renameImages = new JRadioButton(TLanguage.getString("TIGImportDBDialog.ADD_IMAGES"), false);
        renameImages.setActionCommand(TLanguage.getString("TIGImportDBDialog.ADD_IMAGES"));
        this.imagesBehaviour.add(replaceImages);
        this.imagesBehaviour.add(renameImages);
        repeatedImages.add(replaceImages);
        repeatedImages.add(renameImages);
        this.directory = new JTextField(40);
        this.directory.setEditable(false);
        this.openButton = new TButton(new AbstractAction(TLanguage.getString("TIGImportDBDialog.IMAGES")){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TIGImportDBDialog.this.pathImages = TIGImportDBDialog.this.createFileChooser();
                if (TIGImportDBDialog.this.pathImages.compareTo("") != 0) {
                    TIGImportDBDialog.this.directory.setText(TIGImportDBDialog.this.pathImages);
                    File myDirectory = new File(TIGImportDBDialog.this.pathImages);
                    String[] list = myDirectory.list();
                    TIGImportDBDialog.this.task.setLengthOfTask(list.length);
                    TIGImportDBDialog.this.progressBar.setMaximum(list.length);
                }
            }
        });
        this.exitButton = new TButton(new AbstractAction(TLanguage.getString("TIGImportDBDialog.EXIT")){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TIGImportDBDialog.this.stop = true;
                TIGImportDBDialog.this.cancel = true;
                JOptionPane.showConfirmDialog(null, TLanguage.getString("TIGOperationDB.CANCELED"), "", -1, 1);
                TIGImportDBDialog.this.dispose();
            }
        });
        this.importButton = new TButton(new AbstractAction(TLanguage.getString("TIGImportDBDialog.IMPORT_BUTTON")){

            @Override
            public void actionPerformed(ActionEvent e2) {
                if (TIGImportDBDialog.this.directory.getText().trim().compareTo("") == 0) {
                    JOptionPane.showConfirmDialog(null, TLanguage.getString("TIGImportDBDialog.ERROR_EMPTY_DIRECTORY"), TLanguage.getString("TIGImportDBDialog.ERROR"), -1, 2);
                } else {
                    File myDirectory = new File(TIGImportDBDialog.this.pathImages);
                    String[] list = myDirectory.list();
                    boolean findXML = false;
                    int i2 = 0;
                    while (!findXML && i2 < list.length) {
                        findXML = list[i2].equals("images.xml");
                        ++i2;
                    }
                    if (findXML) {
                        TIGDataBase.conectDB();
                        TIGImportDBDialog.this.pathImages = TIGImportDBDialog.this.directory.getText();
                        TIGImportDBDialog.this.text.setText(TLanguage.getString("TIGImportDBDialog.PROGRESS_TASK"));
                        TIGImportDBDialog.this.importButton.setEnabled(false);
                        TIGImportDBDialog.this.progressBar.setIndeterminate(false);
                        TIGImportDBDialog.this.progressBar.setValue(0);
                        String behaviour = TIGImportDBDialog.this.imagesBehaviour.getSelection().getActionCommand();
                        TIGImportDBDialog.this.task.go(TIGImportDBDialog.this.myEditor, TIGImportDBDialog.this.myDataBase, TIGImportDBDialog.this.pathImages, behaviour);
                        TIGImportDBDialog.this.timer.start();
                    } else {
                        JOptionPane.showConfirmDialog(null, TLanguage.getString("TIGImportDBDialog.ERROR_FORMAT_DATABASE"), TLanguage.getString("TIGImportDBDialog.ERROR"), -1, 2);
                    }
                }
            }
        });
        this.c = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        this.c.fill = 10;
        this.c.insets = new Insets(5, 10, 5, 10);
        this.c.gridx = 0;
        this.c.gridy = 0;
        setDirectory.add((Component)this.openButton, this.c);
        this.c.fill = 10;
        this.c.insets = new Insets(5, 10, 5, 10);
        this.c.gridx = 1;
        this.c.gridy = 0;
        setDirectory.add((Component)this.directory, this.c);
        buttons.add(this.importButton);
        buttons.add(this.exitButton);
        this.c = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        this.c.fill = 10;
        this.c.insets = new Insets(5, 10, 5, 10);
        this.c.weightx = 1.0;
        this.c.weighty = 0.0;
        this.c.gridx = 0;
        this.c.gridy = 0;
        this.add((Component)setDirectory, this.c);
        this.c.fill = 1;
        this.c.insets = new Insets(5, 10, 5, 10);
        this.c.weightx = 1.0;
        this.c.weighty = 0.0;
        this.c.gridx = 0;
        this.c.gridy = 2;
        this.add((Component)repeatedImages, this.c);
        this.c.fill = 10;
        this.c.insets = new Insets(5, 10, 5, 10);
        this.c.weightx = 1.0;
        this.c.weighty = 0.0;
        this.c.gridx = 0;
        this.c.gridy = 3;
        this.add((Component)buttons, this.c);
        this.c.fill = 1;
        this.c.insets = new Insets(5, 5, 5, 5);
        this.c.gridx = 0;
        this.c.gridy = 4;
        this.add((Component)this.contentPane, this.c);
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.pack();
        this.setLocationRelativeTo(editor);
        this.setVisible(true);
    }

    private String createFileChooser() {
        String path = "";
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(1);
        fileChooser.setDialogTitle(TLanguage.getString("TIGImportDBDialog.IMAGES_DIRECTORY"));
        fileChooser.setCurrentDirectory(defaultDirectory);
        int returnValue = fileChooser.showOpenDialog(null);
        if (returnValue == 0) {
            File selectedFile = fileChooser.getSelectedFile();
            defaultDirectory = selectedFile.getParentFile();
            path = selectedFile.getPath();
            path = String.valueOf(path) + File.separator;
        }
        return path;
    }

    public JPanel createProgressDialog() {
        this.progressBar = new JProgressBar();
        this.progressBar.setValue(0);
        this.progressBar.setStringPainted(true);
        JPanel panel = new JPanel();
        this.text = new JTextField("", 20);
        this.text.setEditable(false);
        this.c = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        this.c.fill = 10;
        this.c.insets = new Insets(5, 10, 5, 10);
        this.c.gridx = 0;
        this.c.gridy = 0;
        panel.add((Component)this.text, this.c);
        this.c.fill = 1;
        this.c.insets = new Insets(5, 10, 5, 10);
        this.c.gridx = 0;
        this.c.gridy = 1;
        panel.add((Component)this.progressBar, this.c);
        this.contentPane = new JPanel();
        this.contentPane.setLayout(new BorderLayout());
        this.contentPane.add((Component)panel, "North");
        this.contentPane.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.WHITE, new Color(165, 163, 151)), TLanguage.getString("TIGImportDBDialog.PROGRESS")));
        this.timer = new Timer(100, new TimerListener());
        return this.contentPane;
    }

    class TimerListener
    implements ActionListener {
        TimerListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            TIGImportDBDialog.this.progressBar.setValue(TIGImportDBDialog.this.task.getCurrent());
            if (TIGImportDBDialog.this.stop) {
                TIGImportDBDialog.this.task.stop();
            }
            if (TIGImportDBDialog.this.cancel) {
                TIGImportDBDialog.this.task.cancel();
            }
            if (TIGImportDBDialog.this.task.done()) {
                Toolkit.getDefaultToolkit().beep();
                TIGImportDBDialog.this.timer.stop();
                TIGImportDBDialog.this.importButton.setEnabled(true);
                TIGImportDBDialog.this.progressBar.setValue(TIGImportDBDialog.this.progressBar.getMinimum());
                String errors = TIGImportDBDialog.this.task.getErrorImages();
                if (errors.equals("")) {
                    if (!TIGImportDBDialog.this.cancel) {
                        JOptionPane.showConfirmDialog(null, TLanguage.getString("TIGImportDBDialog.IMPORT_COMPLETED"), "", -1, 1);
                    }
                } else {
                    String pathFile = String.valueOf(System.getProperty("user.dir")) + File.separator + "import_failed.txt";
                    File importFailed = new File(pathFile);
                    Calendar calendar = Calendar.getInstance();
                    Date dateNow = calendar.getTime();
                    SimpleDateFormat formatDateHour = new SimpleDateFormat("dd/MM/yyyy HH:mm");
                    try {
                        BufferedWriter bw = new BufferedWriter(new FileWriter(importFailed, false));
                        bw.write(String.valueOf(formatDateHour.format(dateNow)) + System.getProperty("line.separator"));
                        bw.write(TLanguage.getString("TIGImportDBDialog.IMPORT_WITH_ERRORS_MESSAGE"));
                        bw.write(System.getProperty("line.separator"));
                        bw.write(errors);
                        bw.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    if (!TIGImportDBDialog.this.cancel) {
                        JOptionPane.showConfirmDialog(null, String.valueOf(TLanguage.getString("TIGImportDBDialog.IMPORT_INFO")) + System.getProperty("line.separator") + pathFile, TLanguage.getString("TIGImportDBDialog.IMPORT_WITH_ERRORS"), -1, 2);
                    }
                }
                TIGImportDBDialog.this.dispose();
            }
        }
    }
}

