/*
 * Decompiled with CFR 0.152.
 */
package tico.imageGallery.dialogs;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import tico.components.TButton;
import tico.components.TDialog;
import tico.configuration.TLanguage;
import tico.editor.TEditor;
import tico.imageGallery.components.TIGSearchKeyWord;
import tico.imageGallery.components.TIGSearchName;
import tico.imageGallery.components.TIGThumbnails;
import tico.imageGallery.dataBase.TIGDataBase;

public class TIGImageGalleryDialog
extends TDialog {
    private boolean selected = false;
    private ImageIcon icon;
    private Vector<Vector<String>> images;
    private GridBagConstraints c;
    private TIGThumbnails thumbnailsDialog;
    private JPanel thumbnailsPanel;
    private String pathImageSelected;

    public TIGImageGalleryDialog(TEditor editor, int index) {
        super((Frame)editor, true);
        new TIGDataBase();
        TIGDataBase.conectDB();
        this.addWindowListener(new WindowListener(){

            @Override
            public void windowClosing(WindowEvent e2) {
                TIGImageGalleryDialog.this.dispose();
            }

            @Override
            public void windowActivated(WindowEvent e2) {
            }

            @Override
            public void windowDeactivated(WindowEvent e2) {
            }

            @Override
            public void windowDeiconified(WindowEvent e2) {
            }

            @Override
            public void windowIconified(WindowEvent e2) {
            }

            @Override
            public void windowOpened(WindowEvent e2) {
            }

            @Override
            public void windowClosed(WindowEvent e2) {
            }
        });
        this.setDefaultCloseOperation(2);
        this.setTitle(TLanguage.getString("TImageGalleryDialog.TITLE"));
        this.images = TIGDataBase.imageSearchByName("*");
        this.thumbnailsPanel = new JPanel();
        this.thumbnailsDialog = new TIGThumbnails(false);
        this.thumbnailsPanel = this.thumbnailsDialog.createThumbnailsPanel(this.images, true);
        this.thumbnailsPanel = this.thumbnailsDialog.updateThumbnailsPanel(this.images, index);
        this.thumbnailsPanel.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e2) {
                if (e2.getKeyCode() == 10) {
                    TIGImageGalleryDialog.this.icon = TIGImageGalleryDialog.this.thumbnailsDialog.imageSelected();
                    TIGImageGalleryDialog.this.pathImageSelected = TIGImageGalleryDialog.this.thumbnailsDialog.pathImageSelected();
                    if (TIGImageGalleryDialog.this.icon == null) {
                        JOptionPane.showConfirmDialog(null, TLanguage.getString("TImageGalleryDialog.MESSAGE"), TLanguage.getString("TImageGalleryDialog.ERROR"), -1, 2);
                    } else {
                        TIGImageGalleryDialog.this.selected = true;
                        TIGImageGalleryDialog.this.dispose();
                    }
                }
            }
        });
        this.images = new Vector();
        TIGSearchName searchNamePanel = new TIGSearchName(this.thumbnailsDialog);
        TIGSearchKeyWord keyWordSearchPanel = new TIGSearchKeyWord(this.thumbnailsDialog);
        JPanel buttons = new JPanel();
        TButton insertButton = new TButton(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TIGImageGalleryDialog.this.icon = TIGImageGalleryDialog.this.thumbnailsDialog.imageSelected();
                TIGImageGalleryDialog.this.pathImageSelected = TIGImageGalleryDialog.this.thumbnailsDialog.pathImageSelected();
                if (TIGImageGalleryDialog.this.icon == null) {
                    JOptionPane.showConfirmDialog(null, TLanguage.getString("TImageGalleryDialog.MESSAGE"), TLanguage.getString("TImageGalleryDialog.ERROR"), -1, 2);
                } else {
                    TIGImageGalleryDialog.this.selected = true;
                    TIGImageGalleryDialog.this.dispose();
                }
            }
        });
        insertButton.setText(TLanguage.getString("TImageGalleryDialog.INSERT"));
        TButton cancelButton = new TButton(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TIGImageGalleryDialog.this.dispose();
            }
        });
        cancelButton.setText(TLanguage.getString("TImageGalleryDialog.CANCEL"));
        ButtonGroup actionGroup = new ButtonGroup();
        actionGroup.add(insertButton);
        actionGroup.add(cancelButton);
        GridBagConstraints but = new GridBagConstraints();
        buttons.setLayout(new GridBagLayout());
        but.fill = 1;
        but.insets = new Insets(10, 10, 10, 10);
        but.gridx = 0;
        but.gridy = 0;
        buttons.add((Component)insertButton, but);
        but.fill = 1;
        but.insets = new Insets(10, 10, 10, 10);
        but.gridx = 1;
        but.gridy = 0;
        buttons.add((Component)cancelButton, but);
        this.getContentPane().setLayout(new GridBagLayout());
        this.c = new GridBagConstraints();
        this.c.fill = 1;
        this.c.insets = new Insets(5, 5, 5, 5);
        this.c.gridx = 0;
        this.c.gridy = 0;
        this.getContentPane().add((Component)keyWordSearchPanel, this.c);
        this.c.fill = 1;
        this.c.insets = new Insets(5, 5, 5, 5);
        this.c.gridx = 0;
        this.c.gridy = 1;
        this.getContentPane().add((Component)searchNamePanel, this.c);
        this.c.fill = 1;
        this.c.insets = new Insets(5, 5, 5, 5);
        this.c.gridx = 0;
        this.c.gridy = 2;
        this.getContentPane().add((Component)this.thumbnailsPanel, this.c);
        this.c.fill = 0;
        this.c.insets = new Insets(5, 5, 5, 5);
        this.c.gridx = 0;
        this.c.gridy = 3;
        this.getContentPane().add((Component)buttons, this.c);
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.pack();
        this.setLocationRelativeTo(editor);
        this.setVisible(true);
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public String pathImageSelected() {
        return "images" + File.separator + this.pathImageSelected.substring(0, 1).toUpperCase() + File.separator + this.pathImageSelected;
    }

    public void update(Vector result) {
        this.thumbnailsPanel = this.thumbnailsDialog.updateThumbnailsPanel(result, 0);
    }

    public boolean isImageSelected() {
        return this.selected;
    }

    public int indexImageSelected() {
        return this.thumbnailsDialog.indexImageSelected();
    }
}

