/*
 * Decompiled with CFR 0.152.
 */
package tico.imageGallery.dialogs;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import tico.components.TButton;
import tico.components.TDialog;
import tico.configuration.TLanguage;
import tico.editor.TEditor;
import tico.imageGallery.actions.TIGModifyImageAction;
import tico.imageGallery.components.TIGImageInformation;
import tico.imageGallery.components.TIGInsertKeyWord;
import tico.imageGallery.dataBase.TIGDataBase;

public class TIGImageDataDialog
extends TDialog {
    private TEditor myEditor;
    private String imageName;
    private String imagePath;
    private TIGDataBase myDataBase;
    private TIGInsertKeyWord keyWordPanel;
    private TIGImageInformation imagePanel;

    public TIGImageDataDialog(TEditor editor, TIGDataBase dataBase, ImageIcon icon, String path) {
        super(editor, TLanguage.getString("TIGImageDataDialog.NAME"), true);
        this.myEditor = editor;
        this.myDataBase = dataBase;
        TIGDataBase.conectDB();
        this.imageName = TIGDataBase.imageNameSearch(path);
        this.imagePath = path;
        this.addWindowListener(new WindowListener(){

            @Override
            public void windowClosing(WindowEvent e2) {
                TIGImageDataDialog.this.dispose();
            }

            @Override
            public void windowActivated(WindowEvent e2) {
            }

            @Override
            public void windowDeactivated(WindowEvent e2) {
            }

            @Override
            public void windowDeiconified(WindowEvent e2) {
            }

            @Override
            public void windowIconified(WindowEvent e2) {
            }

            @Override
            public void windowOpened(WindowEvent e2) {
            }

            @Override
            public void windowClosed(WindowEvent e2) {
            }
        });
        this.imagePanel = new TIGImageInformation(TLanguage.getString("TIGImageDataDialog.DATANAME"), icon, this.imageName);
        this.keyWordPanel = new TIGInsertKeyWord(path);
        JPanel buttons = new JPanel();
        TButton acceptButton = new TButton(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                Vector concepts = new Vector();
                concepts = TIGImageDataDialog.this.keyWordPanel.returnKeyWords();
                TIGModifyImageAction action = new TIGModifyImageAction(TIGImageDataDialog.this.myEditor, TIGImageDataDialog.this.myDataBase, TIGImageDataDialog.this.imagePath, TIGImageDataDialog.this.imageName, concepts);
                action.actionPerformed(e2);
                TIGImageDataDialog.this.dispose();
            }
        });
        acceptButton.setText(TLanguage.getString("TIGImageDataDialog.END"));
        TButton cancelButton = new TButton(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TIGImageDataDialog.this.dispose();
            }
        });
        cancelButton.setText(TLanguage.getString("TIGImageDataDialog.CANCEL"));
        GridBagConstraints but = new GridBagConstraints();
        buttons.setLayout(new GridBagLayout());
        but.fill = 10;
        but.insets = new Insets(10, 5, 10, 5);
        but.gridx = 1;
        but.gridy = 0;
        buttons.add((Component)acceptButton, but);
        but.fill = 10;
        but.insets = new Insets(10, 5, 10, 5);
        but.gridx = 2;
        but.gridy = 0;
        buttons.add((Component)cancelButton, but);
        GridBagConstraints c2 = new GridBagConstraints();
        this.getContentPane().setLayout(new GridBagLayout());
        c2.fill = 10;
        c2.insets = new Insets(10, 10, 10, 10);
        c2.gridx = 0;
        c2.gridy = 0;
        this.getContentPane().add((Component)this.imagePanel, c2);
        c2.fill = 10;
        c2.insets = new Insets(10, 10, 10, 10);
        c2.gridx = 0;
        c2.gridy = 1;
        this.getContentPane().add((Component)this.keyWordPanel, c2);
        c2.fill = 0;
        c2.insets = new Insets(10, 5, 10, 5);
        c2.gridx = 0;
        c2.gridy = 3;
        this.getContentPane().add((Component)buttons, c2);
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.pack();
        this.setLocationRelativeTo(editor);
        this.setVisible(true);
    }
}

