/*
 * Decompiled with CFR 0.152.
 */
package tico.imageGallery.dialogs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.border.TitledBorder;
import tico.components.TButton;
import tico.components.TDialog;
import tico.configuration.TLanguage;
import tico.editor.TEditor;
import tico.imageGallery.components.TIGSearchKeyWord;
import tico.imageGallery.components.TIGSearchName;
import tico.imageGallery.components.TIGThumbnails;
import tico.imageGallery.dataBase.TIGDataBase;
import tico.imageGallery.tasks.TIGExportTask;

public class TIGExportDBDialog
extends TDialog {
    private GridBagConstraints c;
    private TButton exportButton;
    private TButton openButton;
    private TButton exitButton;
    private JTextField directory;
    private JTextField text;
    private TIGDataBase myDataBase;
    private String pathImages = "";
    private static File defaultDirectory = null;
    private TEditor myEditor;
    public static final int ONE_SECOND = 1000;
    private Timer timer;
    private JProgressBar progressBar;
    private TIGExportTask task;
    private JPanel contentPane;
    private boolean stop = false;
    private boolean cancel = false;
    private Vector<Vector<String>> images;
    public Vector myResults;
    private TIGThumbnails thumbnailsDialog;
    private JPanel thumbnailsPanel;

    public TIGExportDBDialog(TEditor editor, TIGDataBase dataBase) {
        super(editor, TLanguage.getString("TIGExportDBDialog.NAME"), true);
        this.myEditor = editor;
        this.myDataBase = dataBase;
        TIGDataBase.conectDB();
        this.addWindowListener(new WindowListener(){

            @Override
            public void windowClosing(WindowEvent e2) {
                if (TIGExportDBDialog.this.task.isRunning()) {
                    TIGExportDBDialog.this.stop = true;
                    TIGExportDBDialog.this.cancel = true;
                    JOptionPane.showConfirmDialog(null, TLanguage.getString("TIGOperationDB.CANCELED"), "", -1, 1);
                }
                TIGExportDBDialog.this.dispose();
            }

            @Override
            public void windowActivated(WindowEvent e2) {
            }

            @Override
            public void windowDeactivated(WindowEvent e2) {
            }

            @Override
            public void windowDeiconified(WindowEvent e2) {
            }

            @Override
            public void windowIconified(WindowEvent e2) {
            }

            @Override
            public void windowOpened(WindowEvent e2) {
            }

            @Override
            public void windowClosed(WindowEvent e2) {
            }
        });
        this.task = new TIGExportTask();
        this.contentPane = this.createProgressDialog();
        JPanel setDirectory = new JPanel();
        setDirectory.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.WHITE, new Color(165, 163, 151)), TLanguage.getString("TIGExportDBDialog.IMAGES_SEL")));
        JPanel buttons = new JPanel();
        this.images = TIGDataBase.imageSearchByName("*");
        this.myResults = null;
        this.thumbnailsPanel = new JPanel();
        this.thumbnailsDialog = new TIGThumbnails(true);
        this.thumbnailsPanel = this.thumbnailsDialog.createThumbnailsPanel(this.images, false);
        TIGSearchName searchNamePanel = new TIGSearchName(this.thumbnailsDialog, this);
        TIGSearchKeyWord keyWordSearchPanel = new TIGSearchKeyWord(this.thumbnailsDialog, this);
        this.directory = new JTextField(40);
        this.directory.setEditable(false);
        this.openButton = new TButton(new AbstractAction(TLanguage.getString("TIGExportDBDialog.IMAGES")){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TIGExportDBDialog.this.pathImages = TIGExportDBDialog.this.createFileChooser();
                if (TIGExportDBDialog.this.pathImages.compareTo("") != 0) {
                    TIGExportDBDialog.this.directory.setText(TIGExportDBDialog.this.pathImages);
                }
            }
        });
        this.exitButton = new TButton(new AbstractAction(TLanguage.getString("TIGExportDBDialog.EXIT")){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TIGExportDBDialog.this.stop = true;
                TIGExportDBDialog.this.cancel = true;
                JOptionPane.showConfirmDialog(null, TLanguage.getString("TIGOperationDB.CANCELED"), "", -1, 1);
                TIGExportDBDialog.this.dispose();
            }
        });
        this.exportButton = new TButton(new AbstractAction(TLanguage.getString("TIGExportDBDialog.DB")){

            @Override
            public void actionPerformed(ActionEvent e2) {
                if (TIGExportDBDialog.this.directory.getText().compareTo("") == 0) {
                    JOptionPane.showConfirmDialog(null, TLanguage.getString("TIGExportDBDialog.ERROR_IM"), TLanguage.getString("TIGExportDBDialog.NAME"), -1, 2);
                } else if (TIGExportDBDialog.this.myResults == null) {
                    JOptionPane.showConfirmDialog(null, TLanguage.getString("TIGSearchImageDialog.MESSAGE_NO_SEARCH"), TLanguage.getString("TIGExportDBDialog.NAME"), -1, 2);
                } else if (TIGExportDBDialog.this.myResults.size() == 0) {
                    JOptionPane.showConfirmDialog(null, TLanguage.getString("TIGExportDBDialog.MESSAGE_NO_IMAGES_FOUND"), TLanguage.getString("TIGExportDBDialog.NAME"), -1, 2);
                } else {
                    TIGExportDBDialog.this.pathImages = TIGExportDBDialog.this.directory.getText();
                    TIGExportDBDialog.this.text.setText(TLanguage.getString("TIGImportDBDialog.PROGRESS_TASK"));
                    TIGExportDBDialog.this.exportButton.setEnabled(false);
                    TIGExportDBDialog.this.progressBar.setIndeterminate(false);
                    TIGExportDBDialog.this.progressBar.setMaximum(TIGExportDBDialog.this.myResults.size());
                    TIGExportDBDialog.this.progressBar.setValue(0);
                    TIGExportDBDialog.this.task.go(TIGExportDBDialog.this.myEditor, TIGExportDBDialog.this.myDataBase, TIGExportDBDialog.this.pathImages, TIGExportDBDialog.this.images);
                    TIGExportDBDialog.this.timer.start();
                }
            }
        });
        this.c = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        this.c.fill = 1;
        this.c.insets = new Insets(5, 10, 5, 10);
        this.c.gridx = 0;
        this.c.gridy = 0;
        setDirectory.add((Component)this.openButton, this.c);
        this.c.fill = 0;
        this.c.insets = new Insets(5, 10, 5, 10);
        this.c.gridx = 1;
        this.c.gridy = 0;
        setDirectory.add((Component)this.directory, this.c);
        buttons.add(this.exportButton);
        buttons.add(this.exitButton);
        this.c = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        this.c.fill = 1;
        this.c.insets = new Insets(10, 10, 10, 10);
        this.c.gridx = 0;
        this.c.gridy = 0;
        this.getContentPane().add((Component)keyWordSearchPanel, this.c);
        this.c.fill = 1;
        this.c.insets = new Insets(10, 10, 10, 10);
        this.c.gridx = 0;
        this.c.gridy = 1;
        this.getContentPane().add((Component)searchNamePanel, this.c);
        this.c.fill = 1;
        this.c.insets = new Insets(10, 10, 10, 10);
        this.c.gridx = 0;
        this.c.gridy = 2;
        this.getContentPane().add((Component)this.thumbnailsPanel, this.c);
        this.c.fill = 1;
        this.c.insets = new Insets(5, 10, 5, 10);
        this.c.weightx = 1.0;
        this.c.weighty = 0.0;
        this.c.gridx = 0;
        this.c.gridy = 3;
        this.add((Component)setDirectory, this.c);
        this.c.fill = 1;
        this.c.insets = new Insets(5, 10, 5, 10);
        this.c.weightx = 1.0;
        this.c.weighty = 0.0;
        this.c.gridx = 0;
        this.c.gridy = 4;
        this.add((Component)buttons, this.c);
        this.c.fill = 1;
        this.c.insets = new Insets(5, 5, 5, 5);
        this.c.gridx = 0;
        this.c.gridy = 5;
        this.add((Component)this.contentPane, this.c);
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.pack();
        this.setLocationRelativeTo(editor);
        this.setVisible(true);
    }

    private String createFileChooser() {
        String path = "";
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(1);
        fileChooser.setDialogTitle(TLanguage.getString("TIGExportDBDialog.IMAGES_DIRECTORY"));
        fileChooser.setCurrentDirectory(defaultDirectory);
        int returnValue = fileChooser.showOpenDialog(null);
        if (returnValue == 0) {
            File selectedFile = fileChooser.getSelectedFile();
            defaultDirectory = selectedFile.getParentFile();
            path = selectedFile.getPath();
            path = String.valueOf(path) + File.separator;
        }
        return path;
    }

    public JPanel createProgressDialog() {
        this.progressBar = new JProgressBar();
        this.progressBar.setValue(0);
        this.progressBar.setStringPainted(true);
        this.progressBar.setMaximum(this.task.getLengthOfTask());
        JPanel panel = new JPanel();
        this.text = new JTextField("", 20);
        this.text.setEditable(false);
        this.c = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        this.c.fill = 10;
        this.c.insets = new Insets(5, 10, 5, 10);
        this.c.gridx = 0;
        this.c.gridy = 0;
        panel.add((Component)this.text, this.c);
        this.c.fill = 1;
        this.c.insets = new Insets(5, 10, 5, 10);
        this.c.gridx = 0;
        this.c.gridy = 1;
        panel.add((Component)this.progressBar, this.c);
        this.contentPane = new JPanel();
        this.contentPane.setLayout(new BorderLayout());
        this.contentPane.add((Component)panel, "North");
        this.contentPane.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.WHITE, new Color(165, 163, 151)), TLanguage.getString("TIGExportDBDialog.PROGRESS")));
        this.timer = new Timer(100, new TimerListener());
        return this.contentPane;
    }

    public void update(Vector result) {
        this.thumbnailsPanel = this.thumbnailsDialog.updateThumbnailsPanel(result, 0);
        this.images = this.myResults = result;
    }

    class TimerListener
    implements ActionListener {
        TimerListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            TIGExportDBDialog.this.progressBar.setValue(TIGExportDBDialog.this.task.getCurrent());
            if (TIGExportDBDialog.this.stop) {
                TIGExportDBDialog.this.task.stop();
            }
            if (TIGExportDBDialog.this.cancel) {
                TIGExportDBDialog.this.task.cancel();
            }
            if (TIGExportDBDialog.this.task.done()) {
                Toolkit.getDefaultToolkit().beep();
                TIGExportDBDialog.this.timer.stop();
                TIGExportDBDialog.this.exportButton.setEnabled(true);
                TIGExportDBDialog.this.progressBar.setValue(TIGExportDBDialog.this.progressBar.getMinimum());
                if (!TIGExportDBDialog.this.cancel) {
                    JOptionPane.showConfirmDialog(null, TLanguage.getString("TIGExportDBDialog.EXPORT_COMPLETED"), "", -1, 1);
                }
                TIGExportDBDialog.this.dispose();
            }
        }
    }
}

