/*
 * Decompiled with CFR 0.152.
 */
package tico.imageGallery.dialogs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.border.TitledBorder;
import tico.components.TButton;
import tico.components.TDialog;
import tico.configuration.TLanguage;
import tico.editor.TEditor;
import tico.imageGallery.components.TIGSearchKeyWord;
import tico.imageGallery.components.TIGSearchName;
import tico.imageGallery.components.TIGThumbnails;
import tico.imageGallery.dataBase.TIGDataBase;
import tico.imageGallery.tasks.TIGDeleteTask;

public class TIGDeleteImagesDialog
extends TDialog {
    private ImageIcon icon;
    private TEditor myEditor;
    private TButton deleteButton;
    private String imagePath;
    private Vector<Vector<String>> images;
    public Vector myResults;
    private JTextField text;
    private JProgressBar progressBar;
    private JPanel contentPane;
    private Timer timer;
    private TIGDeleteTask task;
    private boolean stop = false;
    private boolean cancel = false;
    private TIGThumbnails thumbnailsDialog;
    private JPanel thumbnailsPanel;
    private TIGDataBase myDataBase;
    private GridBagConstraints c = new GridBagConstraints();

    public TIGDeleteImagesDialog(TEditor editor, TIGDataBase dataBase) {
        super((Frame)editor, true);
        this.myEditor = editor;
        this.myDataBase = dataBase;
        TIGDataBase.conectDB();
        this.addWindowListener(new WindowListener(){

            @Override
            public void windowClosing(WindowEvent e2) {
                if (TIGDeleteImagesDialog.this.task.isRunning()) {
                    TIGDeleteImagesDialog.this.stop = true;
                    TIGDeleteImagesDialog.this.cancel = true;
                    JOptionPane.showConfirmDialog(null, TLanguage.getString("TIGOperationDB.CANCELED"), "", -1, 1);
                }
                TIGDeleteImagesDialog.this.dispose();
            }

            @Override
            public void windowActivated(WindowEvent e2) {
            }

            @Override
            public void windowDeactivated(WindowEvent e2) {
            }

            @Override
            public void windowDeiconified(WindowEvent e2) {
            }

            @Override
            public void windowIconified(WindowEvent e2) {
            }

            @Override
            public void windowOpened(WindowEvent e2) {
            }

            @Override
            public void windowClosed(WindowEvent e2) {
            }
        });
        this.setDefaultCloseOperation(2);
        this.setTitle(TLanguage.getString("TEditorMenuBar.IMAGES_DELETE"));
        this.images = TIGDataBase.imageSearchByName("*");
        this.myResults = null;
        this.thumbnailsPanel = new JPanel();
        this.thumbnailsDialog = new TIGThumbnails(true);
        this.thumbnailsPanel = this.thumbnailsDialog.createThumbnailsPanel(this.images, false);
        TIGSearchName searchNamePanel = new TIGSearchName(this.thumbnailsDialog, this);
        TIGSearchKeyWord keyWordSearchPanel = new TIGSearchKeyWord(this.thumbnailsDialog, this);
        JPanel buttons = new JPanel();
        this.task = new TIGDeleteTask();
        this.contentPane = this.createProgressDialog();
        this.deleteButton = new TButton(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TIGDeleteImagesDialog.this.imagePath = TIGDeleteImagesDialog.this.thumbnailsDialog.pathImageSelected();
                if (TIGDeleteImagesDialog.this.myResults == null) {
                    JOptionPane.showConfirmDialog(null, TLanguage.getString("TIGSearchImageDialog.MESSAGE_NO_SEARCH"), TLanguage.getString("TIGSearchImageDialog.DELETE_ALL"), -1, 2);
                } else if (TIGDeleteImagesDialog.this.myResults.size() == 0) {
                    JOptionPane.showConfirmDialog(null, TLanguage.getString("TIGSearchImageDialog.MESSAGE_NO_IMAGES_FOUND"), TLanguage.getString("TIGSearchImageDialog.DELETE_ALL"), -1, 2);
                } else {
                    int choosenOption = JOptionPane.showConfirmDialog(null, String.valueOf(TLanguage.getString("TIGSearchImageDialog.DELETE_MESSAGE")) + " " + TIGDeleteImagesDialog.this.myResults.size() + " " + TLanguage.getString("TIGSearchImageDialog.ENSURE_DELETE"), TLanguage.getString("TIGSearchImageDialog.DELETE_ALL"), 1);
                    if (choosenOption == 0) {
                        TIGDeleteImagesDialog.this.text.setText(TLanguage.getString("TIGImportDBDialog.PROGRESS_TASK"));
                        TIGDeleteImagesDialog.this.deleteButton.setEnabled(false);
                        TIGDeleteImagesDialog.this.progressBar.setIndeterminate(false);
                        TIGDeleteImagesDialog.this.progressBar.setMaximum(TIGDeleteImagesDialog.this.myResults.size());
                        TIGDeleteImagesDialog.this.progressBar.setValue(0);
                        TIGDeleteImagesDialog.this.task.go(TIGDeleteImagesDialog.this.myEditor, TIGDeleteImagesDialog.this.myDataBase, TIGDeleteImagesDialog.this.myResults);
                        TIGDeleteImagesDialog.this.timer.start();
                    }
                }
            }
        });
        this.deleteButton.setText(TLanguage.getString("TIGSearchImageDialog.DELETE_ALL"));
        TButton cancelButton = new TButton(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TIGDeleteImagesDialog.this.stop = true;
                TIGDeleteImagesDialog.this.cancel = true;
                JOptionPane.showConfirmDialog(null, TLanguage.getString("TIGOperationDB.CANCELED"), "", -1, 1);
                TIGDeleteImagesDialog.this.dispose();
            }
        });
        cancelButton.setText(TLanguage.getString("TIGSearchImageDialog.CANCEL"));
        ButtonGroup actionGroup = new ButtonGroup();
        actionGroup.add(this.deleteButton);
        actionGroup.add(cancelButton);
        GridBagConstraints but = new GridBagConstraints();
        buttons.setLayout(new GridBagLayout());
        but.fill = 1;
        but.insets = new Insets(10, 10, 10, 10);
        but.gridx = 0;
        but.gridy = 0;
        buttons.add((Component)this.deleteButton, but);
        but.fill = 1;
        but.insets = new Insets(10, 10, 10, 10);
        but.gridx = 2;
        but.gridy = 0;
        buttons.add((Component)cancelButton, but);
        this.getContentPane().setLayout(new GridBagLayout());
        this.c.fill = 1;
        this.c.insets = new Insets(10, 10, 10, 10);
        this.c.gridx = 0;
        this.c.gridy = 0;
        this.getContentPane().add((Component)keyWordSearchPanel, this.c);
        this.c.fill = 1;
        this.c.insets = new Insets(10, 10, 10, 10);
        this.c.gridx = 0;
        this.c.gridy = 1;
        this.getContentPane().add((Component)searchNamePanel, this.c);
        this.c.fill = 1;
        this.c.insets = new Insets(10, 10, 10, 10);
        this.c.gridx = 0;
        this.c.gridy = 2;
        this.getContentPane().add((Component)this.thumbnailsPanel, this.c);
        this.c.fill = 0;
        this.c.insets = new Insets(10, 10, 10, 10);
        this.c.gridx = 0;
        this.c.gridy = 3;
        this.getContentPane().add((Component)buttons, this.c);
        this.c.fill = 1;
        this.c.insets = new Insets(5, 5, 5, 5);
        this.c.gridx = 0;
        this.c.gridy = 4;
        this.getContentPane().add((Component)this.contentPane, this.c);
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.pack();
        this.setLocationRelativeTo(editor);
        this.setVisible(true);
    }

    public JPanel createProgressDialog() {
        this.progressBar = new JProgressBar();
        this.progressBar.setValue(0);
        this.progressBar.setStringPainted(true);
        this.progressBar.setMaximum(this.task.getLengthOfTask());
        JPanel panel = new JPanel();
        this.text = new JTextField("", 20);
        this.text.setEditable(false);
        this.c = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        this.c.fill = 10;
        this.c.insets = new Insets(5, 10, 5, 10);
        this.c.gridx = 0;
        this.c.gridy = 0;
        panel.add((Component)this.text, this.c);
        this.c.fill = 1;
        this.c.insets = new Insets(5, 10, 5, 10);
        this.c.gridx = 0;
        this.c.gridy = 1;
        panel.add((Component)this.progressBar, this.c);
        this.contentPane = new JPanel();
        this.contentPane.setLayout(new BorderLayout());
        this.contentPane.add((Component)panel, "North");
        this.contentPane.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.WHITE, new Color(165, 163, 151)), TLanguage.getString("TIGImportDBDialog.PROGRESS")));
        this.timer = new Timer(100, new TimerListener());
        return this.contentPane;
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public void update(Vector result) {
        this.thumbnailsPanel = this.thumbnailsDialog.updateThumbnailsPanel(result, 0);
        this.myResults = result;
    }

    class TimerListener
    implements ActionListener {
        TimerListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            TIGDeleteImagesDialog.this.progressBar.setValue(TIGDeleteImagesDialog.this.task.getCurrent());
            if (TIGDeleteImagesDialog.this.stop) {
                TIGDeleteImagesDialog.this.task.stop();
            }
            if (TIGDeleteImagesDialog.this.cancel) {
                TIGDeleteImagesDialog.this.task.cancel();
            }
            if (TIGDeleteImagesDialog.this.task.done()) {
                Toolkit.getDefaultToolkit().beep();
                TIGDeleteImagesDialog.this.timer.stop();
                TIGDeleteImagesDialog.this.myResults.clear();
                TIGDeleteImagesDialog.this.update(TIGDeleteImagesDialog.this.myResults);
                TIGDeleteImagesDialog.this.deleteButton.setEnabled(true);
                TIGDeleteImagesDialog.this.progressBar.setValue(TIGDeleteImagesDialog.this.progressBar.getMinimum());
                if (!TIGDeleteImagesDialog.this.cancel) {
                    JOptionPane.showConfirmDialog(null, TLanguage.getString("TIGDeleteImagesDialog.DELETE_COMPLETED"), "", -1, 1);
                }
                TIGDeleteImagesDialog.this.dispose();
            }
        }
    }
}

