/*
 * Decompiled with CFR 0.152.
 */
package tico.imageGallery.dataBase;

import database.DB;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;

public class TIGDataBase {
    private static final int SEARCH_OPTIONS_AND = 1;
    private static final int SEARCH_OPTIONS_OR = 2;
    private static String fileName = "images" + File.separator + "images.db";
    private static Connection conn;
    private static PreparedStatement imageConcepts;

    public static void conectDB() {
        try {
            Class.forName("org.sqlite.JDBC");
            File dataBase = new File(fileName);
            if (!dataBase.exists()) {
                File directory = new File("images");
                directory.mkdir();
                conn = DriverManager.getConnection("jdbc:sqlite:" + fileName);
                TIGDataBase.createTablesDB();
            }
            conn = DriverManager.getConnection("jdbc:sqlite:" + fileName);
        }
        catch (Exception e2) {
            System.out.println(e2.getMessage());
            System.out.println(e2.toString());
        }
    }

    public static void closeDB() {
        try {
            conn.close();
        }
        catch (Exception e2) {
            System.out.println(e2.getMessage());
            System.out.println(e2.toString());
        }
    }

    public static void createTablesDB() {
        try {
            Statement stmt = conn.createStatement();
            String query = "CREATE TABLE Concept (id INTEGER PRIMARY KEY AUTOINCREMENT, word char(30) UNIQUE NOT NULL,noaccents char(30) NOT NULL)";
            stmt.addBatch(query);
            query = "CREATE TABLE Image (id INTEGER PRIMARY KEY AUTOINCREMENT,name char(50) NOT NULL,path char(80) NOT NULL,noaccents char(50) NOT NULL)";
            stmt.addBatch(query);
            query = "CREATE TABLE Asociated (concept INTEGER NOT NULL CONSTRAINT fk_concept REFERENCES Concept(id),image INTEGER NOT NULL CONSTRAINT fk_image REFERENCES Image(id),PRIMARY KEY (concept,image))";
            stmt.addBatch(query);
            stmt.executeBatch();
            stmt.close();
        }
        catch (Exception e2) {
            System.out.println(e2.getMessage());
            System.out.println(e2.toString());
        }
    }

    public static int insertConceptDB(String concept) {
        int conceptKey = -1;
        try {
            Statement stmt = conn.createStatement();
            String conceptQuery = "SELECT * FROM Concept WHERE word = \"" + concept + "\"";
            String insertConceptQuery = "INSERT INTO Concept (word,noaccents) VALUES (\"" + concept + "\", \"" + TIGDataBase.order(concept) + "\")";
            try {
                stmt.executeUpdate(insertConceptQuery);
                ResultSet rsIm = stmt.executeQuery("SELECT last_insert_rowid()");
                conceptKey = rsIm.getInt(1);
            }
            catch (SQLException e2) {
                ResultSet rsIm = stmt.executeQuery(conceptQuery);
                conceptKey = rsIm.getInt("id");
            }
            stmt.close();
        }
        catch (Exception e3) {
            System.out.println(e3.getMessage());
            System.out.println(e3.toString());
        }
        return conceptKey;
    }

    public static int updateConceptDB(String oldConcept, String newConcept) {
        int conceptKey = -1;
        try {
            Statement stmt = conn.createStatement();
            String oldConceptQuery = "SELECT * FROM Concept WHERE word = \"" + oldConcept + "\"";
            String newConceptQuery = "SELECT * FROM Concept WHERE word = \"" + newConcept + "\"";
            ResultSet rsIm = stmt.executeQuery(oldConceptQuery);
            if (!rsIm.next()) {
                rsIm = stmt.executeQuery(newConceptQuery);
                if (!rsIm.next()) {
                    String insertConceptQuery = "INSERT INTO Concept (word,noaccents) VALUES (\"" + newConcept + "\", \"" + TIGDataBase.order(newConcept) + "\")";
                    stmt.executeUpdate(insertConceptQuery);
                }
            } else {
                rsIm = stmt.executeQuery(newConceptQuery);
                if (!rsIm.next()) {
                    String updateConceptQuery = "UPDATE Concept SET word = \"" + newConcept + "\", noaccents = \"" + TIGDataBase.order(newConcept) + "\" WHERE word = \"" + oldConcept + "\"";
                    stmt.executeUpdate(updateConceptQuery);
                    rsIm = stmt.executeQuery(newConceptQuery);
                }
            }
            conceptKey = rsIm.getInt("id");
            stmt.close();
        }
        catch (Exception e2) {
            System.out.println(e2.getMessage());
            System.out.println(e2.toString());
        }
        return conceptKey;
    }

    public static int deleteAsociatedOfImage(int image) {
        int result = -1;
        try {
            Statement stmt = conn.createStatement();
            String deleteQuery = "DELETE FROM Asociated WHERE image = \"" + image + "\"";
            result = stmt.executeUpdate(deleteQuery);
            stmt.close();
        }
        catch (Exception e2) {
            System.out.println(e2.getMessage());
            System.out.println(e2.toString());
        }
        return result;
    }

    public static void activateTransactions() {
        try {
            conn.setAutoCommit(false);
        }
        catch (SQLException e2) {
            e2.printStackTrace();
        }
    }

    public static void executeQueries() {
        try {
            conn.commit();
        }
        catch (SQLException e2) {
            e2.printStackTrace();
        }
    }

    public static int deleteImageDB(int key) {
        int result = -1;
        try {
            Statement stmt = conn.createStatement();
            String deleteAsociationQuery = "DELETE FROM Asociated WHERE image = \"" + key + "\"";
            String deleteImageQuery = "DELETE FROM Image WHERE id = \"" + key + "\"";
            stmt.executeUpdate(deleteAsociationQuery);
            result = stmt.executeUpdate(deleteImageQuery);
            stmt.close();
        }
        catch (Exception e2) {
            System.out.println(e2.getMessage());
            System.out.println(e2.toString());
        }
        return result;
    }

    public static int deleteConceptDB(String concept) {
        int conceptKey = -1;
        try {
            Statement stmt = conn.createStatement();
            String conceptQuery = "SELECT * FROM Concept WHERE word = \"" + concept + "\"";
            ResultSet rsIm = stmt.executeQuery(conceptQuery);
            if (rsIm.next()) {
                conceptKey = rsIm.getInt("id");
                String deleteAsociationQuery = "DELETE FROM Asociated WHERE concept = \"" + conceptKey + "\"";
                String deleteConceptQuery = "DELETE FROM Concept WHERE word = \"" + concept + "\"";
                stmt.executeUpdate(deleteAsociationQuery);
                stmt.executeUpdate(deleteConceptQuery);
                rsIm = stmt.executeQuery(conceptQuery);
                if (!rsIm.next()) {
                    conceptKey = 0;
                }
            }
            stmt.close();
        }
        catch (Exception e2) {
            System.out.println(e2.getMessage());
            System.out.println(e2.toString());
        }
        return conceptKey;
    }

    public static void insertImageDB(String name, String path) {
        String insertImageQuery = "";
        try {
            Statement stmt = conn.createStatement();
            String imageQuery = "SELECT id FROM Image WHERE path = \"" + path + "\"";
            ResultSet rsIm = stmt.executeQuery(imageQuery);
            if (!rsIm.next()) {
                insertImageQuery = "INSERT INTO Image (name,path,noaccents) VALUES (\"" + name + "\",\"" + path + "\",\"" + TIGDataBase.order(name) + "\")";
                stmt.executeUpdate(insertImageQuery);
                rsIm = stmt.executeQuery(imageQuery);
            }
            stmt.close();
        }
        catch (Exception e2) {
            System.out.println(e2.getMessage());
            System.out.println(e2.toString());
        }
    }

    public static void insertAsociatedDB(int concept, int image) {
        try {
            Statement stmt = conn.createStatement();
            String asociatedQuery = "SELECT * FROM Asociated WHERE concept = \"" + concept + "\" " + "AND image = \"" + image + "\"";
            ResultSet rsIm = stmt.executeQuery(asociatedQuery);
            if (!rsIm.next()) {
                String insertAsociatedQuery = "INSERT INTO Asociated (concept,image) VALUES (\"" + concept + "\", \"" + image + "\")";
                stmt.executeUpdate(insertAsociatedQuery);
                rsIm = stmt.executeQuery(asociatedQuery);
            }
            stmt.close();
        }
        catch (Exception e2) {
            System.out.println(e2.getMessage());
            System.out.println(e2.toString());
        }
    }

    public static void insertDB(Vector concepts, String imagePath, String imageName) {
        TIGDataBase.insertImageDB(imageName, imagePath);
        int imageKey = TIGDataBase.imageKeySearch(imagePath);
        int i2 = 0;
        while (i2 < concepts.size()) {
            String concept = (String)concepts.elementAt(i2);
            int conceptKey = TIGDataBase.insertConceptDB(concept);
            TIGDataBase.insertAsociatedDB(conceptKey, imageKey);
            ++i2;
        }
    }

    public static Vector<String> getKeyWords() {
        Vector<String> data = new Vector<String>();
        try {
            Statement stmt = conn.createStatement();
            String query = "SELECT word, noaccents FROM Concept ORDER BY noaccents";
            ResultSet res = stmt.executeQuery(query);
            while (res.next()) {
                data.add(res.getString("word"));
            }
            stmt.close();
        }
        catch (Exception e2) {
            System.out.println(e2.getMessage());
            System.out.println(e2.toString());
        }
        return data;
    }

    public static String imageNameSearch(String path) {
        String result = "";
        try {
            Statement stmt = conn.createStatement();
            String query = "SELECT name FROM Image WHERE path == \"" + path + "\"";
            ResultSet res = stmt.executeQuery(query);
            if (res.next()) {
                result = res.getString("name");
            }
            stmt.close();
        }
        catch (Exception e2) {
            System.out.println(e2.getMessage());
            System.out.println(e2.toString());
        }
        return result;
    }

    public static Vector<Vector<String>> imageSearchByName(String imagen) {
        Vector<Vector<String>> data = new Vector<Vector<String>>();
        try {
            String query = "SELECT * FROM main WHERE name LIKE '" + imagen.replace('*', '%') + "' OR nameNN LIKE '" + imagen.replace('*', '%') + "' GROUP BY nameNN ORDER BY nameNN";
            ResultSet rs = DB.getInstance().query(query);
            while (rs.next()) {
                Vector<String> result = new Vector<String>(2);
                result.add(rs.getString("nameNN"));
                result.add(rs.getString("name"));
                data.add(result);
            }
        }
        catch (Exception e2) {
            System.out.println(e2.getMessage());
            System.out.println(e2.toString());
        }
        return data;
    }

    public static int imageKeySearch(String imagen) {
        int key = -1;
        try {
            Statement stmt = conn.createStatement();
            String query = "SELECT id FROM Image WHERE path = \"" + imagen + "\"";
            ResultSet res = stmt.executeQuery(query);
            if (res.next()) {
                key = res.getInt("id");
            }
            stmt.close();
        }
        catch (Exception e2) {
            System.out.println(e2.getMessage());
            System.out.println(e2.toString());
        }
        return key;
    }

    public static int imageKeySearchName(String imagen) {
        int key = -1;
        try {
            Statement stmt = conn.createStatement();
            String query = "SELECT id FROM Image WHERE name = \"" + imagen + "\"";
            ResultSet res = stmt.executeQuery(query);
            if (res.next()) {
                key = res.getInt("id");
            }
            stmt.close();
        }
        catch (Exception e2) {
            System.out.println(e2.getMessage());
            System.out.println(e2.toString());
        }
        return key;
    }

    public static int conceptKeySearch(String concept) {
        int key = -1;
        try {
            Statement stmt = conn.createStatement();
            String query = "SELECT id FROM Concept WHERE word = \"" + concept + "\"";
            ResultSet res = stmt.executeQuery(query);
            if (res.next()) {
                key = res.getInt("id");
            }
            stmt.close();
        }
        catch (Exception e2) {
            System.out.println(e2.getMessage());
            System.out.println(e2.toString());
        }
        return key;
    }

    public static Vector<String> asociatedConceptSearch(String path) {
        Vector<String> data = new Vector<String>();
        try {
            Statement stmt = conn.createStatement();
            String query = "SELECT id FROM Image WHERE path=\"" + path + "\"";
            ResultSet res = stmt.executeQuery(query);
            int id = res.getInt(1);
            if (imageConcepts == null) {
                stmt.addBatch("create index if not exists kk on Asociated (image)");
                stmt.executeBatch();
                imageConcepts = conn.prepareStatement("SELECT word FROM Concept C left join Asociated A on C.id = A.concept WHERE A.image = ?");
            }
            imageConcepts.setInt(1, id);
            res = imageConcepts.executeQuery();
            while (res.next()) {
                data.add(res.getString("word"));
            }
            stmt.close();
        }
        catch (Exception e2) {
            System.out.println(e2.getMessage());
            System.out.println(e2.toString());
        }
        return data;
    }

    public static int deleteAsociatedDB(int concept, int image) {
        int result = -1;
        try {
            Statement stmt = conn.createStatement();
            String deleteQuery = "DELETE FROM Asociated WHERE image = \"" + image + "\" AND concept =  \"" + concept + "\"";
            result = stmt.executeUpdate(deleteQuery);
            stmt.close();
        }
        catch (Exception e2) {
            System.out.println(e2.getMessage());
            System.out.println(e2.toString());
        }
        return result;
    }

    public static int modifyImage(String path, Vector concepts) {
        int conceptKey;
        int i2 = 0;
        int image = TIGDataBase.imageKeySearch(path);
        if (image == -1) {
            System.out.println("Error con la imagen");
        }
        Vector<String> oldConcepts = TIGDataBase.asociatedConceptSearch(path);
        int j2 = 0;
        while (j2 < oldConcepts.size()) {
            if (!concepts.contains(oldConcepts.elementAt(j2))) {
                conceptKey = TIGDataBase.conceptKeySearch(oldConcepts.elementAt(j2));
                TIGDataBase.deleteAsociatedDB(conceptKey, image);
            }
            ++j2;
        }
        j2 = 0;
        while (j2 < concepts.size()) {
            conceptKey = TIGDataBase.conceptKeySearch((String)concepts.elementAt(j2));
            if (conceptKey == -1) {
                TIGDataBase.insertConceptDB((String)concepts.elementAt(j2));
                conceptKey = TIGDataBase.conceptKeySearch((String)concepts.elementAt(j2));
            }
            if (!TIGDataBase.areAsociated(conceptKey, image)) {
                TIGDataBase.insertAsociatedDB(conceptKey, image);
            }
            ++j2;
        }
        return i2;
    }

    public static boolean areAsociated(int concept, int image) {
        boolean success = false;
        try {
            Statement stmt = conn.createStatement();
            String query = "SELECT * FROM Asociated A WHERE A.concept = \"" + concept + "\" AND A.image = \"" + image + "\"";
            ResultSet res = stmt.executeQuery(query);
            if (res.next()) {
                success = true;
            }
            stmt.close();
        }
        catch (Exception e2) {
            System.out.println(e2.getMessage());
            System.out.println(e2.toString());
        }
        return success;
    }

    public static Vector<Vector<String>> imageSearchByKeyWords(String keyWord1, int searchOptions1, String keyWord2, int searchOptions2, String keyWord3) {
        Vector<Vector<String>> data = new Vector<Vector<String>>();
        String firstKeyWord = TIGDataBase.order(keyWord1.trim()).replace('*', '%');
        String secondKeyWord = TIGDataBase.order(keyWord2.trim()).replace('*', '%');
        String thirdKeyWord = TIGDataBase.order(keyWord3.trim()).replace('*', '%');
        try {
            Statement stmt = conn.createStatement();
            String query = "SELECT DISTINCT I.path path, I.name name, I.noaccents noaccents FROM Concept C, Asociated A, Image I ";
            if (searchOptions1 == 0 && searchOptions2 == 0) {
                query = String.valueOf(query) + "WHERE C.noaccents LIKE \"" + firstKeyWord + "\" AND I.id = A.image AND A.concept = C.id";
            } else if (searchOptions2 == 0) {
                switch (searchOptions1) {
                    case 1: {
                        query = String.valueOf(query) + "WHERE C.noaccents LIKE \"" + firstKeyWord + "\" AND I.id = A.image AND A.concept = C.id " + "AND I.name IN (SELECT DISTINCT I.name name FROM Concept C, Asociated A, Image I " + "WHERE C.noaccents LIKE \"" + secondKeyWord + "\" AND I.id = A.image AND A.concept = C.id)";
                        break;
                    }
                    case 2: {
                        query = String.valueOf(query) + "WHERE (C.noaccents LIKE \"" + firstKeyWord + "\" OR C.noaccents LIKE \"" + secondKeyWord + "\") AND I.id = A.image AND A.concept = C.id";
                    }
                }
            } else {
                block5 : switch (searchOptions1) {
                    case 1: {
                        switch (searchOptions2) {
                            case 1: {
                                query = String.valueOf(query) + "WHERE C.noaccents LIKE \"" + firstKeyWord + "\" AND I.id = A.image AND A.concept = C.id " + "AND I.name IN (SELECT DISTINCT I.name name FROM Concept C, Asociated A, Image I " + "WHERE C.noaccents LIKE \"" + secondKeyWord + "\" AND I.id = A.image AND A.concept = C.id) " + "AND I.name IN (SELECT DISTINCT I.name name FROM Concept C, Asociated A, Image I " + "WHERE C.noaccents LIKE \"" + thirdKeyWord + "\" AND I.id = A.image AND A.concept = C.id)";
                                break;
                            }
                            case 2: {
                                query = String.valueOf(query) + "WHERE C.noaccents LIKE \"" + firstKeyWord + "\" AND I.id = A.image AND A.concept = C.id " + "AND I.name IN (SELECT DISTINCT I.name name FROM Concept C, Asociated A, Image I " + "WHERE C.noaccents LIKE \"" + secondKeyWord + "\" AND I.id = A.image AND A.concept = C.id) " + "UNION SELECT DISTINCT I.path path, I.name name, I.noaccents noaccents FROM Concept C, Asociated A, Image I " + "WHERE C.noaccents LIKE \"" + thirdKeyWord + "\" AND I.id = A.image AND A.concept = C.id";
                            }
                        }
                        break;
                    }
                    case 2: {
                        switch (searchOptions2) {
                            case 1: {
                                query = String.valueOf(query) + "WHERE (C.noaccents LIKE \"" + firstKeyWord + "\" OR C.noaccents LIKE \"" + secondKeyWord + "\") AND I.id = A.image AND A.concept = C.id " + "AND I.name IN (SELECT DISTINCT I.name name FROM Concept C, Asociated A, Image I " + "WHERE C.word LIKE \"" + thirdKeyWord + "\" AND I.id = A.image AND A.concept = C.id)";
                                break block5;
                            }
                            case 2: {
                                query = String.valueOf(query) + "WHERE (C.noaccents LIKE \"" + firstKeyWord + "\" OR C.noaccents LIKE \"" + secondKeyWord + "\" OR C.noaccents LIKE \"" + thirdKeyWord + "\") AND I.id = A.image AND A.concept = C.id";
                            }
                        }
                    }
                }
            }
            query = String.valueOf(query) + " ORDER BY I.noaccents";
            ResultSet res = stmt.executeQuery(query);
            while (res.next()) {
                Vector<String> result = new Vector<String>(2);
                result.add(res.getString("path"));
                result.add(res.getString("name"));
                data.add(result);
            }
            stmt.close();
        }
        catch (Exception e2) {
            System.out.println(e2.getMessage());
            System.out.println(e2.toString());
        }
        return data;
    }

    private static String order(String word) {
        String seq_nz = "nz";
        String seq_\u00f1 = "\u00f1";
        String seq_NZ = "NZ";
        String seq_\u00d1 = "\u00d1";
        String result = word.replace(' ', '_').replace(',', '-').replace('\u00e1', 'a').replace('\u00e9', 'e').replace('\u00ed', 'i').replace('\u00f3', 'o').replace('\u00fa', 'u').replace('\u00c1', 'A').replace('\u00c9', 'E').replace('\u00cd', 'I').replace('\u00d3', 'O').replace('\u00da', 'U').replace(seq_\u00f1, seq_nz).replace(seq_\u00d1, seq_NZ).toLowerCase();
        return result;
    }
}

