/*
 * Decompiled with CFR 0.152.
 */
package tico.imageGallery.components;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import database.DB;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Vector;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import tico.components.TButton;
import tico.components.resources.TFileUtils;
import tico.components.resources.TResourceManager;
import tico.configuration.TLanguage;
import tico.imageGallery.components.TIGThumbImage;

public class TIGThumbnails
extends JPanel
implements KeyListener,
MouseListener {
    protected int index = 0;
    private final int IMAGES_DISPLAYED = 4;
    protected int total;
    protected String nImagesString;
    protected ImageIcon imageSelected;
    private TButton leftButton;
    private TButton rightButton;
    private Boolean enabledSelection;
    private String path;
    private Vector result;
    private String[] pathImage = new String[4];
    private String imageName;
    JLabel nImagesTextField;
    JLabel thumbnail = new JLabel();
    JLabel thumbnails1 = new JLabel();
    JLabel thumbnails2 = new JLabel();
    JLabel thumbnails3 = new JLabel();
    JLabel thumbnails4 = new JLabel();
    TIGThumbImage thum = new TIGThumbImage();
    TIGThumbImage thum1 = new TIGThumbImage();
    TIGThumbImage thum2 = new TIGThumbImage();
    TIGThumbImage thum3 = new TIGThumbImage();
    TIGThumbImage thum4 = new TIGThumbImage();
    TIGThumbImage[] thumbImages = new TIGThumbImage[4];
    JLabel[] thumbnails = new JLabel[4];
    Boolean[] containsImage = new Boolean[4];
    GridBagConstraints gridBag;
    boolean select;

    public TIGThumbnails(boolean select) {
        this.select = select;
        this.addMouseListener(this);
        this.addKeyListener(this);
    }

    public JPanel createThumbnailsPanel(Vector result, Boolean enabled) {
        this.enabledSelection = enabled;
        this.result = result;
        this.total = result.size();
        this.gridBag = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        this.leftButton = new TButton(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e2) {
            }
        });
        this.leftButton.setIcon(TResourceManager.getImageIcon("move-left-16.png"));
        this.leftButton.setMargin(new Insets(2, 2, 2, 2));
        this.leftButton.setToolTipText(TLanguage.getString("TIGThumbnailsDialog.PREVIOUS"));
        this.leftButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e2) {
                TIGThumbnails.this.index = (TIGThumbnails.this.index - 4) % TIGThumbnails.this.total;
                if (TIGThumbnails.this.index < 0) {
                    TIGThumbnails.this.index += TIGThumbnails.this.total;
                }
                TIGThumbnails.this.updateThumbnailsPanel(TIGThumbnails.this.index);
            }
        });
        this.rightButton = new TButton(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e2) {
            }
        });
        this.rightButton.setIcon(TResourceManager.getImageIcon("move-right-16.png"));
        this.rightButton.setMargin(new Insets(2, 2, 2, 2));
        this.rightButton.setToolTipText(TLanguage.getString("TIGThumbnailsDialog.NEXT"));
        this.rightButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e2) {
                TIGThumbnails.this.index = (TIGThumbnails.this.index + 4) % TIGThumbnails.this.total;
                TIGThumbnails.this.updateThumbnailsPanel(TIGThumbnails.this.index);
            }
        });
        this.nImagesString = result.size() == 1 ? TLanguage.getString("TIGThumbnailsDialog.ONE_IMAGE_FOUND") : String.valueOf(result.size()) + " " + TLanguage.getString("TIGThumbnailsDialog.IMAGES_FOUND");
        this.nImagesTextField = new JLabel(this.nImagesString);
        this.setOpaque(true);
        this.setBackground(Color.WHITE);
        this.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.WHITE, new Color(165, 163, 151))));
        if (result.size() <= 4) {
            this.leftButton.setEnabled(false);
            this.rightButton.setEnabled(false);
        }
        int i2 = 0;
        while (i2 < 4) {
            this.thumbImages[i2] = new TIGThumbImage();
            ++i2;
        }
        i2 = 0;
        while (i2 < 4) {
            if (i2 < result.size()) {
                Vector data = new Vector(2);
                data = (Vector)result.elementAt(i2 % 4);
                this.pathImage[i2] = (String)data.elementAt(0);
                try {
                    String pathSrc = String.valueOf(DB.getInstance().getImagesPath()) + File.separator + this.pathImage[i2];
                    String pathTh = String.valueOf(DB.getInstance().getImagesPath()) + File.separator + this.pathImage[i2];
                    this.createThumbnail(pathSrc, pathTh);
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                this.thumbnails[i2] = this.thumbImages[i2].createImageLabel(this.pathImage[i2]);
                this.imageName = (String)data.elementAt(1);
                this.thumbnails[i2].setToolTipText(this.imageName);
                this.thumbnails[i2].setPreferredSize(new Dimension(130, 130));
                if (this.enabledSelection.booleanValue()) {
                    this.thumbnails[i2].addMouseListener(new selectedImageListener(i2));
                }
                this.containsImage[i2] = true;
            } else {
                this.thumbnails[i2] = this.thumbImages[i2].createImageLabel(null);
                this.thumbnails[i2].setPreferredSize(new Dimension(125, 125));
                this.thumbnails[i2].setText("");
                this.thumbnails[i2].setToolTipText(null);
                this.thumbnails[i2].setPreferredSize(new Dimension(130, 130));
                this.thumbImages[i2].updateBorder(Color.WHITE);
                this.containsImage[i2] = false;
            }
            ++i2;
        }
        this.gridBag.fill = 1;
        this.gridBag.insets = new Insets(10, 10, 10, 10);
        this.gridBag.gridy = 0;
        i2 = 0;
        while (i2 < 4) {
            this.gridBag.gridx = i2;
            this.add((Component)this.thumbnails[i2], this.gridBag);
            ++i2;
        }
        this.gridBag.fill = 1;
        this.gridBag.insets = new Insets(10, 30, 10, 30);
        this.gridBag.gridx = 0;
        this.gridBag.gridy = 1;
        this.add((Component)this.leftButton, this.gridBag);
        this.gridBag.fill = 10;
        this.gridBag.insets = new Insets(10, 30, 10, 30);
        this.gridBag.gridwidth = 2;
        this.gridBag.gridx = 1;
        this.gridBag.gridy = 1;
        this.add((Component)this.nImagesTextField, this.gridBag);
        this.gridBag.fill = 1;
        this.gridBag.insets = new Insets(10, 30, 10, 30);
        this.gridBag.gridx = 3;
        this.gridBag.gridy = 1;
        this.add((Component)this.rightButton, this.gridBag);
        return this;
    }

    public JPanel updateThumbnailsPanel() {
        this.path = null;
        return this.updateThumbnailsPanel(this.result, this.index);
    }

    public JPanel updateThumbnailsPanel(int first) {
        return this.updateThumbnailsPanel(this.result, first);
    }

    public JPanel updateThumbnailsPanel(Vector result, int first) {
        this.result = result;
        this.total = result.size();
        if (result.size() == 0) {
            int i2 = 0;
            while (i2 < 4) {
                this.thumbnails[i2] = this.thumbImages[i2].createImageLabel(null);
                this.thumbnails[i2].setPreferredSize(new Dimension(125, 125));
                this.thumbnails[i2].setText("");
                this.thumbnails[i2].setToolTipText(null);
                this.thumbnails[i2].setPreferredSize(new Dimension(130, 130));
                this.thumbImages[i2].updateBorder(Color.WHITE);
                this.containsImage[i2] = false;
                ++i2;
            }
            this.leftButton.setEnabled(false);
            this.rightButton.setEnabled(false);
            this.nImagesString = String.valueOf(result.size()) + " " + TLanguage.getString("TIGThumbnailsDialog.IMAGES_FOUND");
            this.nImagesTextField.setText(this.nImagesString);
        } else {
            this.nImagesString = result.size() == 1 ? TLanguage.getString("TIGThumbnailsDialog.ONE_IMAGE_FOUND") : String.valueOf(result.size()) + " " + TLanguage.getString("TIGThumbnailsDialog.IMAGES_FOUND");
            this.nImagesTextField.setText(this.nImagesString);
            if (result.size() <= 4) {
                int i3 = 0;
                while (i3 < 4) {
                    if (i3 < result.size()) {
                        Vector data = new Vector(2);
                        data = (Vector)result.elementAt(i3 % 4);
                        this.pathImage[i3] = (String)data.elementAt(0);
                        String thumbName = this.pathImage[i3];
                        try {
                            String pathSrc = String.valueOf(DB.getInstance().getImagesPath()) + File.separator + this.pathImage[i3];
                            String pathTh = String.valueOf(DB.getInstance().getImagesPath()) + File.separator + thumbName;
                            this.createThumbnail(pathSrc, pathTh);
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                        }
                        this.thumbnails[i3] = this.thumbImages[i3].createImageLabel(thumbName);
                        this.imageName = (String)data.elementAt(1);
                        this.thumbnails[i3].setToolTipText(this.imageName);
                        this.thumbnails[i3].setPreferredSize(new Dimension(130, 130));
                        this.thumbImages[i3].updateBorder(Color.GREEN);
                        if (this.enabledSelection.booleanValue()) {
                            this.thumbnails[i3].addMouseListener(new selectedImageListener(i3));
                        }
                        this.containsImage[i3] = true;
                    } else {
                        this.thumbnails[i3] = this.thumbImages[i3].createImageLabel(null);
                        this.thumbnails[i3].setPreferredSize(new Dimension(125, 125));
                        this.thumbnails[i3].setText("");
                        this.thumbnails[i3].setToolTipText(null);
                        this.thumbnails[i3].setPreferredSize(new Dimension(130, 130));
                        this.thumbImages[i3].updateBorder(Color.WHITE);
                        this.containsImage[i3] = false;
                    }
                    ++i3;
                }
                this.leftButton.setEnabled(false);
                this.rightButton.setEnabled(false);
            } else {
                int indexThumb = 0;
                int restartIndex = 0;
                int i4 = first;
                while (i4 < 4 + first) {
                    String pathTh;
                    String pathSrc;
                    String thumbName;
                    Vector data;
                    if (i4 < result.size()) {
                        data = new Vector(2);
                        data = (Vector)result.elementAt(i4);
                        this.pathImage[indexThumb] = (String)data.elementAt(0);
                        thumbName = this.pathImage[indexThumb];
                        try {
                            pathSrc = String.valueOf(DB.getInstance().getImagesPath()) + File.separator + this.pathImage[indexThumb];
                            pathTh = String.valueOf(DB.getInstance().getImagesPath()) + File.separator + thumbName;
                            this.createThumbnail(pathSrc, pathTh);
                        }
                        catch (Exception e3) {
                            e3.printStackTrace();
                        }
                        this.thumbnails[indexThumb] = this.thumbImages[indexThumb].createImageLabel(thumbName);
                        this.imageName = (String)data.elementAt(1);
                        this.thumbnails[indexThumb].setToolTipText(this.imageName);
                        this.thumbnails[indexThumb].setPreferredSize(new Dimension(130, 130));
                        this.thumbImages[indexThumb].updateBorder(Color.GREEN);
                        if (this.enabledSelection.booleanValue()) {
                            this.thumbnails[indexThumb].addMouseListener(new selectedImageListener(indexThumb));
                        }
                        this.containsImage[indexThumb] = true;
                    } else {
                        data = new Vector(2);
                        data = (Vector)result.elementAt(restartIndex);
                        this.pathImage[indexThumb] = (String)data.elementAt(0);
                        thumbName = String.valueOf(this.pathImage[indexThumb].substring(0, this.pathImage[indexThumb].lastIndexOf(46))) + "_th.jpg";
                        pathSrc = String.valueOf(System.getProperty("user.dir")) + File.separator + "images" + File.separator + this.pathImage[indexThumb].substring(0, 1).toUpperCase() + File.separator + this.pathImage[indexThumb];
                        pathTh = String.valueOf(System.getProperty("user.dir")) + File.separator + "images" + File.separator + this.pathImage[indexThumb].substring(0, 1).toUpperCase() + File.separator + thumbName;
                        this.createThumbnail(pathSrc, pathTh);
                        this.thumbnails[indexThumb] = this.thumbImages[indexThumb].createImageLabel(thumbName);
                        this.imageName = (String)data.elementAt(1);
                        this.thumbnails[indexThumb].setToolTipText(this.imageName);
                        this.thumbnails[indexThumb].setPreferredSize(new Dimension(130, 130));
                        this.thumbImages[indexThumb].updateBorder(Color.GREEN);
                        if (this.enabledSelection.booleanValue()) {
                            this.thumbnails[indexThumb].addMouseListener(new selectedImageListener(indexThumb));
                        }
                        this.containsImage[indexThumb] = true;
                        ++restartIndex;
                    }
                    ++indexThumb;
                    ++i4;
                }
                this.leftButton.setEnabled(true);
                this.rightButton.setEnabled(true);
            }
        }
        return this;
    }

    public void selectThumbnail(int imageClicked) {
        this.path = this.pathImage[imageClicked];
        if (this.containsImage[imageClicked].booleanValue()) {
            int i2 = 0;
            while (i2 < 4) {
                if (i2 == imageClicked) {
                    this.thumbImages[i2].updateBorder(Color.RED);
                    this.imageSelected = this.thumbImages[i2].returnIcon();
                } else if (this.containsImage[i2].booleanValue()) {
                    this.thumbImages[i2].updateBorder(Color.GREEN);
                } else {
                    this.thumbImages[i2].updateBorder(Color.WHITE);
                }
                ++i2;
            }
        }
    }

    public ImageIcon imageSelected() {
        if (this.path != null) {
            TIGThumbImage image = new TIGThumbImage();
            image.createImageLabel(this.path);
            return image.returnIcon();
        }
        return null;
    }

    public String pathImageSelected() {
        return this.path;
    }

    public String imageClickedText(int imageClicked) {
        switch (imageClicked) {
            case 1: {
                return this.thum1.returnText();
            }
            case 2: {
                return this.thum2.returnText();
            }
            case 3: {
                return this.thum3.returnText();
            }
            case 4: {
                return this.thum4.returnText();
            }
        }
        return "";
    }

    public JPanel deleteImage() {
        int i2 = 0;
        boolean deleted = false;
        Vector image = new Vector(2);
        if (this.path != null) {
            while (i2 < this.result.size() && !deleted) {
                image = (Vector)this.result.elementAt(i2);
                String pathImage = (String)image.elementAt(0);
                if (pathImage.equals(this.path)) {
                    this.result.removeElementAt(i2);
                    deleted = true;
                }
                ++i2;
            }
            this.path = null;
        }
        this.updateThumbnailsPanel(this.result, this.index);
        return this;
    }

    public int getVectorIndex(char letter) {
        int i2 = 0;
        boolean founded = false;
        while (i2 < this.result.size() && !founded) {
            Vector data = new Vector(2);
            data = (Vector)this.result.elementAt(i2);
            String name = ((String)data.elementAt(1)).toLowerCase();
            if (letter == '\u00f1') {
                String aux = TIGThumbnails.replace(name);
                if (aux.charAt(0) == 'n' && aux.length() > 1) {
                    if (aux.charAt(1) == 'y') {
                        founded = true;
                        continue;
                    }
                    ++i2;
                    continue;
                }
                ++i2;
                continue;
            }
            if (TIGThumbnails.replace(name).charAt(0) >= letter) {
                founded = true;
                continue;
            }
            ++i2;
        }
        if (!founded) {
            return 0;
        }
        if (i2 >= this.result.size() || this.result.size() - 4 <= i2 && i2 < this.result.size()) {
            return this.result.size() - 4;
        }
        return i2;
    }

    @Override
    public boolean isFocusable() {
        return true;
    }

    @Override
    public void mousePressed(MouseEvent e2) {
    }

    @Override
    public void mouseReleased(MouseEvent e2) {
    }

    @Override
    public void mouseClicked(MouseEvent e2) {
    }

    @Override
    public void mouseEntered(MouseEvent e2) {
        this.requestFocus();
    }

    @Override
    public void mouseExited(MouseEvent e2) {
    }

    @Override
    public void keyReleased(KeyEvent e2) {
        char letter = e2.getKeyChar();
        if ('a' <= letter && letter <= 'z' || '0' <= letter && letter <= '9' || letter == '\u00f1') {
            int i2 = this.getVectorIndex(letter);
            this.updateThumbnailsPanel(i2);
        }
        if (e2.getKeyCode() == 39) {
            this.index = (this.index + 4) % this.total;
            this.updateThumbnailsPanel(this.index);
        }
        if (e2.getKeyCode() == 37) {
            this.index = (this.index - 4) % this.total;
            if (this.index < 0) {
                this.index += this.total;
            }
            this.updateThumbnailsPanel(this.index);
        }
    }

    @Override
    public void keyTyped(KeyEvent e2) {
    }

    @Override
    public void keyPressed(KeyEvent e2) {
    }

    private static String replace(String word) {
        String seq_nz = "nz";
        String seq_\u00f1 = "\u00f1";
        String seq_NZ = "NZ";
        String seq_\u00d1 = "\u00d1";
        String result = word.replace(' ', '_').replace(',', '-').replace('\u00e1', 'a').replace('\u00e9', 'e').replace('\u00ed', 'i').replace('\u00f3', 'o').replace('\u00fa', 'u').replace('\u00c1', 'A').replace('\u00c9', 'E').replace('\u00cd', 'I').replace('\u00d3', 'O').replace('\u00da', 'U').replace(seq_\u00f1, seq_nz).replace(seq_\u00d1, seq_NZ).toLowerCase();
        return result;
    }

    private void createThumbnail(String pathImage, String pathThumbnail) {
        File thum;
        int PREVIEW_WIDTH = 125;
        int PREVIEW_HEIGHT = 125;
        File srcImage = new File(pathImage);
        ImageIcon imageIcon = null;
        if (srcImage != null) {
            if (TFileUtils.isJAIRequired(srcImage)) {
                RenderedOp src_aux = JAI.create("fileload", srcImage.getAbsolutePath());
                BufferedImage bufferedImage = src_aux.getAsBufferedImage();
                imageIcon = new ImageIcon(bufferedImage);
            } else {
                imageIcon = new ImageIcon(srcImage.getAbsolutePath());
            }
        }
        if (!(thum = new File(pathThumbnail)).exists()) {
            try {
                int thumbWidth = 125;
                int thumbHeight = 125;
                double thumbRatio = (double)thumbWidth / (double)thumbHeight;
                int imageWidth = imageIcon.getIconWidth();
                int imageHeight = imageIcon.getIconHeight();
                double imageRatio = (double)imageWidth / (double)imageHeight;
                if (thumbRatio < imageRatio) {
                    thumbHeight = (int)((double)thumbWidth / imageRatio);
                } else {
                    thumbWidth = (int)((double)thumbHeight * imageRatio);
                }
                BufferedImage thumbImage = new BufferedImage(thumbWidth, thumbHeight, 1);
                Graphics2D graphics2D = thumbImage.createGraphics();
                graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                graphics2D.drawImage(imageIcon.getImage(), 0, 0, thumbWidth, thumbHeight, null);
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(pathThumbnail));
                JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)out);
                JPEGEncodeParam param = encoder.getDefaultJPEGEncodeParam(thumbImage);
                int quality = 100;
                quality = Math.max(0, Math.min(quality, 100));
                param.setQuality((float)quality / 100.0f, false);
                encoder.setJPEGEncodeParam(param);
                encoder.encode(thumbImage);
                out.close();
            }
            catch (Exception ex) {
                System.out.println("Error creating THUMBNAIL");
                System.out.println(ex.toString());
            }
        }
    }

    public int indexImageSelected() {
        int i2 = 0;
        boolean found = false;
        Vector image = new Vector(2);
        if (this.path != null) {
            while (i2 < this.result.size() && !found) {
                image = (Vector)this.result.elementAt(i2);
                String pathImage = (String)image.elementAt(0);
                if (pathImage.equals(this.path)) {
                    found = true;
                    continue;
                }
                ++i2;
            }
        }
        if (!found) {
            i2 = 0;
        }
        return i2;
    }

    class selectedImageListener
    implements MouseListener {
        int selected;

        public selectedImageListener(int imageSelected) {
            this.selected = imageSelected;
        }

        @Override
        public void mouseClicked(MouseEvent arg0) {
            TIGThumbnails.this.selectThumbnail(this.selected);
        }

        @Override
        public void mouseEntered(MouseEvent arg0) {
        }

        @Override
        public void mouseExited(MouseEvent arg0) {
        }

        @Override
        public void mousePressed(MouseEvent arg0) {
        }

        @Override
        public void mouseReleased(MouseEvent arg0) {
        }
    }
}

