/*
 * Decompiled with CFR 0.152.
 */
package tico.imageGallery.components;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.border.LineBorder;
import tico.components.resources.TFileUtils;
import tico.configuration.TLanguage;

public class TIGThumbImage
extends JLabel {
    private ImageIcon image;

    public TIGThumbImage() {
        this.setPreferredSize(new Dimension(125, 125));
        this.setBorder(new LineBorder(Color.GREEN, 2));
    }

    protected void updateBorder(Color color) {
        this.setBorder(new LineBorder(color, 2));
    }

    protected JLabel createImageLabel(String image_path) {
        if (image_path != null) {
            String path = "images" + File.separator + image_path.substring(0, 1).toUpperCase() + File.separator + image_path;
            File image = new File(path);
            this.setImageFile(image);
        } else {
            this.image = null;
            this.setIcon(null);
        }
        return this;
    }

    private void setImageFile(File imageFile) {
        this.image = null;
        if (imageFile != null) {
            if (TFileUtils.isJAIRequired(imageFile)) {
                RenderedOp src = JAI.create("fileload", imageFile.getAbsolutePath());
                BufferedImage bufferedImage = src.getAsBufferedImage();
                this.image = new ImageIcon(bufferedImage);
            } else {
                this.image = new ImageIcon(imageFile.getAbsolutePath());
            }
            if (this.image.getImageLoadStatus() == 4) {
                this.setText(TLanguage.getString("TIGThumbImageDialog.TEXT"));
                this.setIcon(null);
            } else {
                this.setText("");
            }
            this.setIcon(this.image);
        }
    }

    public ImageIcon returnIcon() {
        return this.image;
    }

    public String returnText() {
        return this.getText();
    }
}

