/*
 * Decompiled with CFR 0.152.
 */
package tico.imageGallery.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import tico.components.TButton;
import tico.components.TImagePreview;
import tico.components.resources.ImageFilter;
import tico.components.resources.TFileUtils;
import tico.configuration.TLanguage;

public class TIGSelectNewImage
extends JPanel {
    private static final int ICON_LABEL_WIDTH = 100;
    private static final int ICON_LABEL_HEIGHT = 80;
    private static final int ICON_LABEL_MARGIN = 3;
    public static final int NO_OPTIONS_TYPE = 0;
    public static final int TEXT_POSITION_TYPE = 1;
    public static final int RESIZE_STYLE_TYPE = 2;
    private static final int DEFAULT_TYPE = 0;
    private static final String DEFAULT_TITLE = TLanguage.getString("TImageChooser.TITLE");
    private ImageIcon icon;
    private JLabel iconLabel;
    private JPanel buttonPanel;
    private TButton clearIconButton;
    private TButton openChooserDialogButton;
    private static File defaultDirectory = null;
    public static String path = null;

    public TIGSelectNewImage() {
        this(DEFAULT_TITLE);
    }

    public TIGSelectNewImage(String title) {
        this.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.WHITE, new Color(165, 163, 151)), title));
        this.createIconLabel();
        this.createButtonPanel();
        this.updateComponents();
        GridBagConstraints c2 = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        c2.fill = 10;
        c2.insets = new Insets(10, 10, 10, 10);
        c2.gridx = 0;
        c2.gridy = 0;
        this.add((Component)this.iconLabel, c2);
        c2.fill = 10;
        c2.insets = new Insets(10, 10, 10, 10);
        c2.gridx = 1;
        c2.gridy = 0;
        this.add((Component)this.buttonPanel, c2);
    }

    private void createIconLabel() {
        this.iconLabel = new JLabel();
        this.iconLabel.setMinimumSize(new Dimension(100, 80));
        this.iconLabel.setPreferredSize(new Dimension(100, 80));
        this.iconLabel.setBorder(BorderFactory.createBevelBorder(1));
        this.iconLabel.setVerticalAlignment(0);
        this.iconLabel.setHorizontalAlignment(0);
        this.iconLabel.setBackground(Color.WHITE);
    }

    private void createButtonPanel() {
        this.buttonPanel = new JPanel();
        this.openChooserDialogButton = new TButton(TLanguage.getString("TImageChooser.BUTTON_SELECT"));
        this.openChooserDialogButton.addActionListener(new ChooseIconButtonListener());
        this.clearIconButton = new TButton(new AbstractAction(TLanguage.getString("TImageChooser.BUTTON_CLEAR")){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TIGSelectNewImage.this.setIcon(null);
                path = null;
            }
        });
        this.buttonPanel.add(this.openChooserDialogButton);
        this.buttonPanel.add(this.clearIconButton);
    }

    public String returnImage() {
        return path;
    }

    public void updateComponents() {
        if (this.icon != null) {
            this.clearIconButton.setEnabled(true);
            ImageIcon thumbnail = this.icon;
            int maxImageWidth = this.iconLabel.getPreferredSize().width - 3;
            int maxImageHeight = this.iconLabel.getPreferredSize().height - 3;
            if (thumbnail.getIconWidth() > maxImageWidth) {
                thumbnail = new ImageIcon(thumbnail.getImage().getScaledInstance(maxImageWidth, -1, 4));
            }
            if (thumbnail.getIconHeight() > maxImageHeight) {
                thumbnail = new ImageIcon(thumbnail.getImage().getScaledInstance(-1, maxImageHeight, 4));
            }
            this.iconLabel.setText("");
            this.iconLabel.setIcon(thumbnail);
        } else {
            this.clearIconButton.setEnabled(false);
            this.iconLabel.setText(TLanguage.getString("TImageChooser.PREVIEW_EMPTY"));
            this.iconLabel.setIcon(null);
        }
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public void setIcon(ImageIcon icon) {
        this.icon = icon;
        this.updateComponents();
    }

    private class ChooseIconButtonListener
    implements ActionListener {
        private ChooseIconButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setDialogTitle(TLanguage.getString("TImageChooser.CHOOSE_IMAGE"));
            fileChooser.setCurrentDirectory(defaultDirectory);
            fileChooser.addChoosableFileFilter(new ImageFilter());
            fileChooser.setAcceptAllFileFilterUsed(false);
            fileChooser.setAccessory(new TImagePreview(fileChooser));
            int returnValue = fileChooser.showOpenDialog(null);
            if (returnValue == 0) {
                File selectedFile = fileChooser.getSelectedFile();
                defaultDirectory = selectedFile.getParentFile();
                try {
                    ImageIcon newImageIcon;
                    if (TFileUtils.isJAIRequired(selectedFile)) {
                        RenderedOp src = JAI.create("fileload", selectedFile.getAbsolutePath());
                        BufferedImage bufferedImage = src.getAsBufferedImage();
                        newImageIcon = new ImageIcon(bufferedImage, selectedFile.getAbsolutePath());
                        path = selectedFile.getAbsolutePath();
                    } else {
                        newImageIcon = new ImageIcon(selectedFile.getAbsolutePath(), selectedFile.getAbsolutePath());
                        path = selectedFile.getAbsolutePath();
                    }
                    TIGSelectNewImage.this.setIcon(newImageIcon);
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(null, TLanguage.getString("TImageChooser.CHOOSE_IMAGE_ERROR"), String.valueOf(TLanguage.getString("ERROR")) + "!", 0);
                }
            }
        }
    }
}

