/*
 * Decompiled with CFR 0.152.
 */
package tico.imageGallery.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import tico.configuration.TLanguage;

public class TIGImageInformation
extends JPanel {
    private static final int ICON_LABEL_WIDTH = 100;
    private static final int ICON_LABEL_HEIGHT = 80;
    private static final int ICON_LABEL_MARGIN = 3;
    private JLabel iconLabel;
    private ImageIcon myIcon;
    private JTextField imageName;

    public TIGImageInformation(String title, ImageIcon icon, String name) {
        this.myIcon = icon;
        this.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.WHITE, new Color(165, 163, 151)), title));
        this.createIconLabel();
        this.createNamePanel(name);
        this.updateComponents();
        GridBagConstraints c2 = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        c2.fill = 10;
        c2.insets = new Insets(10, 10, 10, 10);
        c2.gridx = 0;
        c2.gridy = 0;
        this.add((Component)this.iconLabel, c2);
        c2.fill = 11;
        c2.insets = new Insets(10, 10, 10, 10);
        c2.gridx = 1;
        c2.gridy = 0;
        this.add((Component)this.imageName, c2);
    }

    private void createIconLabel() {
        this.iconLabel = new JLabel();
        this.iconLabel.setMinimumSize(new Dimension(100, 80));
        this.iconLabel.setPreferredSize(new Dimension(100, 80));
        this.iconLabel.setBorder(BorderFactory.createBevelBorder(1));
        this.iconLabel.setVerticalAlignment(0);
        this.iconLabel.setHorizontalAlignment(0);
        this.iconLabel.setBackground(Color.WHITE);
    }

    private void createNamePanel(String name) {
        this.imageName = new JTextField(name);
        this.imageName.setEditable(false);
        this.imageName.setPreferredSize(new Dimension(180, 25));
    }

    protected void updateComponents() {
        if (this.myIcon != null) {
            ImageIcon thumbnail = this.myIcon;
            int maxImageWidth = this.iconLabel.getPreferredSize().width - 3;
            int maxImageHeight = this.iconLabel.getPreferredSize().height - 3;
            if (thumbnail.getIconWidth() > maxImageWidth) {
                thumbnail = new ImageIcon(thumbnail.getImage().getScaledInstance(maxImageWidth, -1, 4));
            }
            if (thumbnail.getIconHeight() > maxImageHeight) {
                thumbnail = new ImageIcon(thumbnail.getImage().getScaledInstance(-1, maxImageHeight, 4));
            }
            this.iconLabel.setText("");
            this.iconLabel.setIcon(thumbnail);
        } else {
            this.iconLabel.setText(TLanguage.getString("TIGModifyImageNameDialog.PREVIEW_EMPTY"));
            this.iconLabel.setIcon(null);
        }
    }

    public String returnName() {
        return this.imageName.getText();
    }
}

