/*
 * Decompiled with CFR 0.152.
 */
package tico.imageGallery.actions;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.util.Vector;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import tico.components.resources.TFileUtils;
import tico.configuration.TLanguage;
import tico.editor.TEditor;
import tico.imageGallery.actions.TIGAbstractAction;
import tico.imageGallery.dataBase.TIGDataBase;

public class TIGInsertImageAction
extends TIGAbstractAction {
    private static final int PREVIEW_WIDTH = 125;
    private static final int PREVIEW_HEIGHT = 125;
    private ImageIcon image;
    protected TIGDataBase dataBase;
    protected Vector theConcepts;
    protected String path;
    protected String directoryPath;
    protected String imageName;
    protected String imagePath;
    protected String imagePathThumb;
    protected String name;
    protected String myImagesBehaviour;

    public TIGInsertImageAction(TEditor editor, Vector concepts, String image, TIGDataBase dataBase, String behaviour) {
        super(editor);
        this.theConcepts = (Vector)concepts.clone();
        this.path = image;
        this.myImagesBehaviour = behaviour;
        this.dataBase = dataBase;
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        if (this.path.compareTo("") != 0) {
            Vector<Vector<String>> aux;
            this.imageName = this.path.substring(this.path.lastIndexOf(File.separator) + 1, this.path.length());
            String name = this.imageName.substring(0, this.imageName.lastIndexOf(46));
            String extension = this.imageName.substring(this.imageName.lastIndexOf(46) + 1, this.imageName.length());
            File imageFile = new File(this.path);
            this.directoryPath = "images" + File.separator + this.imageName.substring(0, 1).toUpperCase();
            File directory = new File(this.directoryPath);
            directory.mkdirs();
            this.imagePath = "." + File.separator + "images" + File.separator + this.imageName.substring(0, 1).toUpperCase() + File.separator + this.imageName;
            File newFile = new File(this.imagePath);
            if (this.myImagesBehaviour.equals(TLanguage.getString("TIGManageGalleryDialog.REPLACE_IMAGE")) && (aux = TIGDataBase.imageSearchByName(name)).size() != 0) {
                int idImage = TIGDataBase.imageKeySearchName(name);
                TIGDataBase.deleteAsociatedOfImage(idImage);
            }
            if (this.myImagesBehaviour.equals(TLanguage.getString("TIGManageGalleryDialog.ADD_IMAGE"))) {
                int i2 = 1;
                while (newFile.exists()) {
                    this.imagePath = "." + File.separator + "images" + File.separator + this.imageName.substring(0, 1).toUpperCase() + File.separator + this.imageName.substring(0, this.imageName.lastIndexOf(46)) + "_" + i2 + this.imageName.substring(this.imageName.lastIndexOf(46), this.imageName.length());
                    name = String.valueOf(name) + "_" + i2;
                    newFile = new File(this.imagePath);
                    ++i2;
                }
            }
            this.imagePathThumb = this.imagePath.substring(0, this.imagePath.lastIndexOf(".")).concat("_th.jpg");
            this.imageName = String.valueOf(name) + "." + extension;
            try {
                FileChannel srcChannel = new FileInputStream(this.path).getChannel();
                FileChannel dstChannel = new FileOutputStream(this.imagePath).getChannel();
                dstChannel.transferFrom(srcChannel, 0L, srcChannel.size());
                srcChannel.close();
                dstChannel.close();
            }
            catch (IOException exc) {
                System.out.println(exc.getMessage());
                System.out.println(exc.toString());
            }
            TIGDataBase.insertDB(this.theConcepts, this.imageName, this.imageName.substring(0, this.imageName.lastIndexOf(46)));
            this.image = null;
            if (imageFile != null) {
                if (TFileUtils.isJAIRequired(imageFile)) {
                    RenderedOp src = JAI.create("fileload", imageFile.getAbsolutePath());
                    BufferedImage bufferedImage = src.getAsBufferedImage();
                    this.image = new ImageIcon(bufferedImage);
                } else {
                    this.image = new ImageIcon(imageFile.getAbsolutePath());
                }
                if (this.image.getImageLoadStatus() == 4) {
                    int choosenOption = 1;
                    choosenOption = JOptionPane.showConfirmDialog(null, TLanguage.getString("TIGInsertImageAction.MESSAGE"), TLanguage.getString("TIGInsertImageAction.NAME"), -1, 0);
                } else {
                    this.createThumbnail();
                }
            }
        }
    }

    private void createThumbnail() {
        try {
            int thumbWidth = 125;
            int thumbHeight = 125;
            double thumbRatio = (double)thumbWidth / (double)thumbHeight;
            int imageWidth = this.image.getIconWidth();
            int imageHeight = this.image.getIconHeight();
            double imageRatio = (double)imageWidth / (double)imageHeight;
            if (thumbRatio < imageRatio) {
                thumbHeight = (int)((double)thumbWidth / imageRatio);
            } else {
                thumbWidth = (int)((double)thumbHeight * imageRatio);
            }
            BufferedImage thumbImage = new BufferedImage(thumbWidth, thumbHeight, 1);
            Graphics2D graphics2D = thumbImage.createGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            graphics2D.drawImage(this.image.getImage(), 0, 0, thumbWidth, thumbHeight, null);
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(this.imagePathThumb));
            JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)out);
            JPEGEncodeParam param = encoder.getDefaultJPEGEncodeParam(thumbImage);
            int quality = 100;
            quality = Math.max(0, Math.min(quality, 100));
            param.setQuality((float)quality / 100.0f, false);
            encoder.setJPEGEncodeParam(param);
            encoder.encode(thumbImage);
            out.close();
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            System.out.println(ex.toString());
        }
    }
}

