/*
 * Decompiled with CFR 0.152.
 */
package tico.imageGallery;

import database.DB;
import dialogs.FindImageFrame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import tico.components.TButton;
import tico.components.TImageChooser;
import tico.configuration.TLanguage;
import tico.editor.TEditor;

public class TImageGalleryButton {
    private TEditor myEditor;
    private TImageChooser theChooser;
    private Vector<Vector<String>> data;
    private int indexImageSelected = 0;
    private String path = null;

    public TButton createImageGalleryButton(TEditor editor, TImageChooser chooser) {
        this.myEditor = editor;
        this.theChooser = chooser;
        TButton openGalleryButton = new TButton(new AbstractAction(TLanguage.getString("TImageChooser.BUTTON_OPEN")){

            @Override
            public void actionPerformed(ActionEvent e2) {
                FindImageFrame f2 = new FindImageFrame(0);
                f2.setDefaultCloseOperation(2);
                f2.setResizable(false);
                f2.pack();
                f2.setModal(true);
                f2.setLocationRelativeTo(TImageGalleryButton.this.myEditor);
                f2.setVisible(true);
                if (f2.getSelectedImageName() != null) {
                    try {
                        String absolutePath = String.valueOf(DB.getInstance().getImagesPath()) + File.separator + f2.getSelectedImageName();
                        ImageIcon newImageIcon = new ImageIcon(absolutePath, absolutePath);
                        TImageGalleryButton.this.theChooser.setIcon(newImageIcon);
                        TImageGalleryButton.this.theChooser.updateComponents();
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        return openGalleryButton;
    }

    public String getPath() {
        return this.path;
    }
}

