/*
 * Decompiled with CFR 0.152.
 */
package tico.environment;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Vector;
import tico.components.resources.TFileUtils;
import tico.configuration.TResourceBundle;

public class TEnvironment
implements Comparator {
    private static String ENVIRONMENT_DIRECTORY = "environment";
    private static String currentEnvironment = "entorno";
    private static Map environmentMap = TEnvironment.getEnvironment();
    private static TResourceBundle ENVIRONMENT_BUNDLE = null;

    public static void initEnvironment(String environment) throws IOException {
        environmentMap = TEnvironment.getEnvironment();
        if (environmentMap == null || environmentMap.isEmpty()) {
            throw new FileNotFoundException();
        }
        currentEnvironment = "entorno";
        if (currentEnvironment == null || !environmentMap.containsKey(currentEnvironment)) {
            Iterator environIterator = environmentMap.entrySet().iterator();
            Map.Entry environEntry = environIterator.next();
            currentEnvironment = (String)environEntry.getKey();
        }
        FileInputStream i2 = new FileInputStream((File)environmentMap.get(currentEnvironment));
        ENVIRONMENT_BUNDLE = new TResourceBundle(i2);
    }

    public static boolean environmentExists(String environment) {
        Map environmentMap = TEnvironment.getEnvironment();
        return environmentMap.containsKey(environment);
    }

    public static Map getEnvironment() {
        Hashtable<String, File> environmentMap = new Hashtable<String, File>();
        File environmentDirectory = new File(ENVIRONMENT_DIRECTORY);
        File[] fileList = environmentDirectory.listFiles();
        int i2 = 0;
        while (i2 < fileList.length) {
            try {
                if (TFileUtils.getExtension(fileList[i2]).equals("txt")) {
                    TResourceBundle currentEnvironmentBundle = new TResourceBundle(new FileInputStream(fileList[i2]));
                    environmentMap.put(currentEnvironmentBundle.getString("entorno"), fileList[i2]);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ++i2;
        }
        return environmentMap;
    }

    public static String getCode(String key) {
        try {
            return ENVIRONMENT_BUNDLE.getString(key);
        }
        catch (MissingResourceException e2) {
            return String.valueOf('!') + key + '!';
        }
        catch (NullPointerException e3) {
            return String.valueOf('!') + key + '!';
        }
    }

    public TResourceBundle getEnvironmentBundle() {
        return ENVIRONMENT_BUNDLE;
    }

    public static Vector getAllKeys() {
        try {
            Enumeration<String> algo = ENVIRONMENT_BUNDLE.getKeys();
            Vector<String> keys = new Vector<String>();
            int i2 = 0;
            keys.add(i2, " ");
            ++i2;
            while (algo.hasMoreElements()) {
                String cadena = algo.nextElement().toString();
                if (cadena.equals("entorno")) continue;
                keys.add(i2, cadena);
                ++i2;
            }
            Collections.sort(keys, new TEnvironment());
            return keys;
        }
        catch (NullPointerException e2) {
            return new Vector();
        }
    }

    public int compare(Object o1, Object o2) {
        int result = 0;
        String name1 = o1.toString().trim().toLowerCase();
        String name2 = o2.toString().trim().toLowerCase();
        if (name1.length() > 0 && name2.length() > 0) {
            String firstName1 = name1.substring(0, 1);
            String firstName2 = name2.substring(0, 1);
            if (firstName1.matches("[a-z]") && firstName2.matches("[a-z]")) {
                result = name1.compareTo(name2);
            } else if (firstName1.matches("[a-z]") && !firstName2.matches("[a-z]")) {
                result = -1;
            } else if (!firstName1.matches("[a-z]") && firstName2.matches("[a-z]")) {
                result = 1;
            }
        }
        return result;
    }
}

