/*
 * Decompiled with CFR 0.152.
 */
package tico.editor.toolbars;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.jgraph.graph.AttributeMap;
import tico.board.TBoardConstants;
import tico.board.TBoardLayoutCache;
import tico.board.components.TComponent;
import tico.board.components.TGrid;
import tico.components.TColorComboBox;
import tico.components.TFontFaceComboBox;
import tico.components.TFontSizeComboBox;
import tico.components.TToolBar;
import tico.components.TToolBarButton;
import tico.components.TToolBarToggleButton;
import tico.components.resources.TResourceManager;
import tico.configuration.TLanguage;
import tico.editor.TEditor;

public class TTextToolBar
extends TToolBar {
    private TEditor editor;
    private TToolBarButton applyFont;
    private TToolBarToggleButton textBoldButton;
    private TToolBarToggleButton textItalicButton;
    private TFontFaceComboBox fontFaceComboBox;
    private TFontSizeComboBox fontSizeComboBox;
    private TColorComboBox fontColorComboBox;

    public TTextToolBar(TEditor editor) {
        super(TLanguage.getString("TTextToolBar.NAME"));
        this.editor = editor;
        this.setLayout(new FlowLayout(0, 0, 0));
        this.applyFont = new TToolBarButton(TResourceManager.getImageIcon("format-font-22.png"));
        this.applyFont.setToolTipText(TLanguage.getString("TTextToolBar.APPLY_TEXT_TOOLTIP"));
        this.fontFaceComboBox = new TFontFaceComboBox();
        this.fontSizeComboBox = new TFontSizeComboBox();
        this.textBoldButton = new TToolBarToggleButton(TResourceManager.getImageIcon("format-bold-22.png"));
        this.textBoldButton.setToolTipText(TLanguage.getString("TTextToolBar.BOLD"));
        this.textItalicButton = new TToolBarToggleButton(TResourceManager.getImageIcon("format-italic-22.png"));
        this.textItalicButton.setToolTipText(TLanguage.getString("TTextToolBar.ITALIC"));
        this.fontColorComboBox = new TColorComboBox();
        this.applyFont.addActionListener(new ChangeAttributesListener());
        this.textBoldButton.setSelected(false);
        this.textItalicButton.setSelected(false);
        this.fontColorComboBox.setColor(TBoardConstants.DEFAULT_FOREGROUND);
        this.add(this.applyFont);
        this.addSeparator(new Dimension(3, 3));
        this.add(this.fontFaceComboBox);
        this.addSeparator(new Dimension(3, 3));
        this.add(this.fontSizeComboBox);
        this.addSeparator(new Dimension(3, 3));
        this.add(this.textBoldButton);
        this.add(this.textItalicButton);
        this.addSeparator(new Dimension(3, 3));
        this.add(this.fontColorComboBox);
    }

    public void updateComponents() {
        TComponent selectedComponent;
        boolean enabled = this.editor.getCurrentBoard() != null;
        this.applyFont.setEnabled(enabled);
        this.textBoldButton.setEnabled(enabled);
        this.textItalicButton.setEnabled(enabled);
        if (TEditor.get_android_mode()) {
            this.fontFaceComboBox.setEnabled(false);
        } else {
            this.fontFaceComboBox.setEnabled(enabled);
        }
        this.fontSizeComboBox.setEnabled(enabled);
        this.fontColorComboBox.setEnabled(enabled);
        if (enabled && (selectedComponent = (TComponent)this.editor.getCurrentBoard().getSelectionCell()) != null) {
            AttributeMap map;
            Font font;
            if (selectedComponent instanceof TGrid) {
                if (((TGrid)selectedComponent).getChildCount() == 0) {
                    return;
                }
                selectedComponent = (TComponent)selectedComponent.getChildAt(0);
            }
            if (((font = TBoardConstants.getFont(map = selectedComponent.getAttributes())).getStyle() & 1) != 0) {
                this.textBoldButton.setSelected(true);
            } else {
                this.textBoldButton.setSelected(false);
            }
            if ((font.getStyle() & 2) != 0) {
                this.textItalicButton.setSelected(true);
            } else {
                this.textItalicButton.setSelected(false);
            }
            this.fontFaceComboBox.setFontFace(font.getFamily());
            this.fontSizeComboBox.setFontSize(font.getSize());
            this.fontColorComboBox.setColor(TBoardConstants.getForeground(map));
        }
    }

    public AttributeMap getAttributes() {
        AttributeMap attributeMap = new AttributeMap();
        int style = 0;
        if (this.textBoldButton.isSelected()) {
            style |= 1;
        }
        if (this.textItalicButton.isSelected()) {
            style |= 2;
        }
        TBoardConstants.setFont(attributeMap, new Font(this.fontFaceComboBox.getFontFace(), style, this.fontSizeComboBox.getFontSize()));
        Color fontColor = this.fontColorComboBox.getColor();
        if (fontColor != null) {
            TBoardConstants.setForeground(attributeMap, fontColor);
        }
        return attributeMap;
    }

    private class ChangeAttributesListener
    implements ActionListener {
        private ChangeAttributesListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            ((TBoardLayoutCache)TTextToolBar.this.editor.getCurrentBoard().getGraphLayoutCache()).editRoots(TTextToolBar.this.editor.getCurrentBoard().getSelectionCells(), TTextToolBar.this.getAttributes());
        }
    }
}

