/*
 * Decompiled with CFR 0.152.
 */
package tico.editor.toolbars;

import javax.swing.ButtonGroup;
import org.jgraph.graph.BasicMarqueeHandler;
import tico.board.TBoard;
import tico.components.TToolBar;
import tico.components.TToolBarToggleButton;
import tico.configuration.TLanguage;
import tico.editor.TEditor;
import tico.editor.handler.TCellMarqueeHandler;
import tico.editor.handler.TControllerCellMarqueeHandler;
import tico.editor.handler.TGridMarqueeHandler;
import tico.editor.handler.TLabelMarqueeHandler;
import tico.editor.handler.TLineMarqueeHandler;
import tico.editor.handler.TOvalMarqueeHandler;
import tico.editor.handler.TRectangleMarqueeHandler;
import tico.editor.handler.TRoundRectMarqueeHandler;
import tico.editor.handler.TTextAreaMarqueeHandler;

public class THandlersToolBar
extends TToolBar {
    private TEditor editor;
    private TToolBarToggleButton selectButton;
    private TToolBarToggleButton cellButton;
    private TToolBarToggleButton controllerCellButton;
    private TToolBarToggleButton gridButton;
    private TToolBarToggleButton textAreaButton;
    private TToolBarToggleButton labelButton;
    private TToolBarToggleButton lineButton;
    private TToolBarToggleButton ovalButton;
    private TToolBarToggleButton rectangleButton;
    private TToolBarToggleButton roundRectangleButton;

    public THandlersToolBar(TEditor editor) {
        super(TLanguage.getString("THandlersToolBar.NAME"));
        this.editor = editor;
        ButtonGroup handlersButtonGroup = new ButtonGroup();
        this.selectButton = new TToolBarToggleButton(editor.getActionSet().getAction("selectionHandlerAction"));
        this.cellButton = new TToolBarToggleButton(editor.getActionSet().getAction("cellHandlerAction"));
        this.controllerCellButton = new TToolBarToggleButton(editor.getActionSet().getAction("controllerCellHandlerAction"));
        this.gridButton = new TToolBarToggleButton(editor.getActionSet().getAction("gridHandlerAction"));
        this.textAreaButton = new TToolBarToggleButton(editor.getActionSet().getAction("textAreaHandlerAction"));
        this.labelButton = new TToolBarToggleButton(editor.getActionSet().getAction("labelHandlerAction"));
        this.lineButton = new TToolBarToggleButton(editor.getActionSet().getAction("lineHandlerAction"));
        this.ovalButton = new TToolBarToggleButton(editor.getActionSet().getAction("ovalHandlerAction"));
        this.rectangleButton = new TToolBarToggleButton(editor.getActionSet().getAction("rectangleHandlerAction"));
        this.roundRectangleButton = new TToolBarToggleButton(editor.getActionSet().getAction("roundRectHandlerAction"));
        handlersButtonGroup.add(this.selectButton);
        handlersButtonGroup.add(this.cellButton);
        handlersButtonGroup.add(this.controllerCellButton);
        handlersButtonGroup.add(this.gridButton);
        handlersButtonGroup.add(this.textAreaButton);
        handlersButtonGroup.add(this.labelButton);
        handlersButtonGroup.add(this.lineButton);
        handlersButtonGroup.add(this.ovalButton);
        handlersButtonGroup.add(this.rectangleButton);
        handlersButtonGroup.add(this.roundRectangleButton);
        this.add(this.selectButton);
        this.addSeparator();
        this.add(this.cellButton);
        this.add(this.controllerCellButton);
        this.add(this.gridButton);
        this.addSeparator();
        this.add(this.textAreaButton);
        this.add(this.labelButton);
        this.addSeparator();
        this.add(this.lineButton);
        this.add(this.ovalButton);
        this.add(this.rectangleButton);
        this.add(this.roundRectangleButton);
        this.selectButton.setSelected(true);
    }

    public void updateHandlers() {
        TBoard board = this.editor.getCurrentBoard();
        BasicMarqueeHandler handler = null;
        if (board != null) {
            handler = board.getMarqueeHandler();
        }
        if (handler != null) {
            if (handler instanceof TCellMarqueeHandler) {
                this.cellButton.setSelected(true);
            } else if (handler instanceof TControllerCellMarqueeHandler) {
                this.controllerCellButton.setSelected(true);
            } else if (handler instanceof TGridMarqueeHandler) {
                this.gridButton.setSelected(true);
            } else if (handler instanceof TTextAreaMarqueeHandler) {
                this.textAreaButton.setSelected(true);
            } else if (handler instanceof TLabelMarqueeHandler) {
                this.labelButton.setSelected(true);
            } else if (handler instanceof TLineMarqueeHandler) {
                this.lineButton.setSelected(true);
            } else if (handler instanceof TOvalMarqueeHandler) {
                this.ovalButton.setSelected(true);
            } else if (handler instanceof TRectangleMarqueeHandler) {
                this.rectangleButton.setSelected(true);
            } else if (handler instanceof TRoundRectMarqueeHandler) {
                this.roundRectangleButton.setSelected(true);
            } else {
                this.selectButton.setSelected(true);
            }
        }
    }
}

