/*
 * Decompiled with CFR 0.152.
 */
package tico.editor.toolbars;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.jgraph.graph.AttributeMap;
import tico.board.TBoardConstants;
import tico.board.TBoardLayoutCache;
import tico.board.components.TComponent;
import tico.board.components.TGrid;
import tico.components.TBorderSizeComboBox;
import tico.components.TColorComboBox;
import tico.components.TToolBar;
import tico.components.TToolBarButton;
import tico.components.resources.TResourceManager;
import tico.configuration.TLanguage;
import tico.editor.TEditor;

public class TFormatToolBar
extends TToolBar {
    private TEditor editor;
    private TColorComboBox backgroundColorComboBox;
    private TColorComboBox gradientColorComboBox;
    private TColorComboBox borderColorComboBox;
    private TBorderSizeComboBox borderSizeComboBox;
    private TToolBarButton applyBackground;
    private TToolBarButton applyBorder;

    public TFormatToolBar(TEditor editor) {
        super(TLanguage.getString("TFormatToolBar.NAME"));
        this.editor = editor;
        this.setLayout(new FlowLayout(0, 0, 0));
        this.applyBackground = new TToolBarButton(TResourceManager.getImageIcon("format-background-22.png"));
        this.applyBackground.setToolTipText(TLanguage.getString("TFormatToolBar.APPLY_BACKGROUND_TOOLTIP"));
        this.backgroundColorComboBox = new TColorComboBox(true);
        this.gradientColorComboBox = new TColorComboBox(true);
        this.applyBorder = new TToolBarButton(TResourceManager.getImageIcon("format-border-22.png"));
        this.applyBorder.setToolTipText(TLanguage.getString("TFormatToolBar.APPLY_BORDER_TOOLTIP"));
        this.borderColorComboBox = new TColorComboBox(true);
        this.borderSizeComboBox = new TBorderSizeComboBox();
        this.backgroundColorComboBox.addActionListener(new ChangeColorListener());
        this.borderColorComboBox.addActionListener(new ChangeColorListener());
        this.applyBackground.addActionListener(new ChangeAttributesListener());
        this.applyBorder.addActionListener(new ChangeAttributesListener());
        this.backgroundColorComboBox.setColor(Color.WHITE);
        this.gradientColorComboBox.setColor(null);
        this.borderColorComboBox.setColor(Color.BLACK);
        this.borderSizeComboBox.setBorderSize(1);
        this.add(this.applyBackground);
        this.addSeparator(new Dimension(3, 3));
        this.add(this.backgroundColorComboBox);
        this.addSeparator(new Dimension(3, 3));
        this.add(this.gradientColorComboBox);
        this.addSeparator();
        this.add(this.applyBorder);
        this.addSeparator(new Dimension(3, 3));
        this.add(this.borderColorComboBox);
        this.addSeparator(new Dimension(3, 3));
        this.add(this.borderSizeComboBox);
    }

    public void updateComponents() {
        TComponent selectedComponent;
        boolean enabled = this.editor.getCurrentBoard() != null;
        this.applyBackground.setEnabled(enabled);
        this.applyBorder.setEnabled(enabled);
        this.backgroundColorComboBox.setEnabled(enabled);
        this.gradientColorComboBox.setEnabled(enabled);
        this.borderColorComboBox.setEnabled(enabled);
        this.borderSizeComboBox.setEnabled(enabled);
        if (enabled && (selectedComponent = (TComponent)this.editor.getCurrentBoard().getSelectionCell()) != null) {
            if (selectedComponent instanceof TGrid) {
                if (((TGrid)selectedComponent).getChildCount() == 0) {
                    return;
                }
                selectedComponent = (TComponent)selectedComponent.getChildAt(0);
            }
            AttributeMap map = selectedComponent.getAttributes();
            this.backgroundColorComboBox.setColor(TBoardConstants.getBackground(map));
            this.gradientColorComboBox.setColor(TBoardConstants.getGradientColor(map));
            this.borderColorComboBox.setColor(TBoardConstants.getBorderColor(map));
            this.borderSizeComboBox.setBorderSize((int)TBoardConstants.getLineWidth(map));
        }
    }

    public AttributeMap getAttributes() {
        Color borderColor;
        Color gradientColor;
        AttributeMap map = new AttributeMap();
        Color backgroundColor = this.backgroundColorComboBox.getColor();
        if (backgroundColor != null) {
            TBoardConstants.setBackground(map, backgroundColor);
        }
        if ((gradientColor = this.gradientColorComboBox.getColor()) != null) {
            TBoardConstants.setGradientColor(map, gradientColor);
        }
        if ((borderColor = this.borderColorComboBox.getColor()) != null) {
            TBoardConstants.setBorderColor(map, borderColor);
        }
        TBoardConstants.setLineWidth(map, this.borderSizeComboBox.getBorderSize());
        TBoardConstants.setAlternativeBorderColor(map, TBoardConstants.DEFAULT_ALTERNATIVE_BORDERCOLOR);
        TBoardConstants.setAlternativeLinewidth(map, 4);
        return map;
    }

    private class ChangeAttributesListener
    implements ActionListener {
        private ChangeAttributesListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            AttributeMap map = new AttributeMap();
            if (e2.getSource() == TFormatToolBar.this.applyBackground) {
                Color gradientColor;
                Color backgroundColor = TFormatToolBar.this.backgroundColorComboBox.getColor();
                if (backgroundColor != null) {
                    TBoardConstants.setBackground(map, backgroundColor);
                }
                if ((gradientColor = TFormatToolBar.this.gradientColorComboBox.getColor()) != null) {
                    TBoardConstants.setGradientColor(map, gradientColor);
                }
                if (gradientColor == null && backgroundColor == null) {
                    TBoardConstants.setRemoveAttributes(map, new Object[]{"backgroundColor", "gradientColor"});
                } else if (gradientColor == null) {
                    TBoardConstants.setRemoveAttributes(map, new Object[]{"gradientColor"});
                } else if (backgroundColor == null) {
                    TBoardConstants.setRemoveAttributes(map, new Object[]{"backgroundColor"});
                }
            } else if (e2.getSource() == TFormatToolBar.this.applyBorder) {
                Color borderColor = TFormatToolBar.this.borderColorComboBox.getColor();
                if (borderColor != null) {
                    TBoardConstants.setBorderColor(map, borderColor);
                } else {
                    TBoardConstants.setRemoveAttributes(map, new Object[]{"bordercolor"});
                }
                TBoardConstants.setLineWidth(map, TFormatToolBar.this.borderSizeComboBox.getBorderSize());
            }
            ((TBoardLayoutCache)TFormatToolBar.this.editor.getCurrentBoard().getGraphLayoutCache()).editRoots(TFormatToolBar.this.editor.getCurrentBoard().getSelectionCells(), map);
        }
    }

    private class ChangeColorListener
    implements ActionListener {
        private ChangeColorListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            if (TFormatToolBar.this.backgroundColorComboBox.getColor() == null) {
                TFormatToolBar.this.gradientColorComboBox.setEnabled(false);
            } else {
                TFormatToolBar.this.gradientColorComboBox.setEnabled(true);
            }
            if (TFormatToolBar.this.borderColorComboBox.getColor() == null) {
                TFormatToolBar.this.borderSizeComboBox.setEnabled(false);
            } else {
                TFormatToolBar.this.borderSizeComboBox.setEnabled(true);
            }
        }
    }
}

