/*
 * Decompiled with CFR 0.152.
 */
package tico.editor.handler;

import java.awt.Graphics;
import java.awt.geom.Rectangle2D;
import org.jgraph.JGraph;
import tico.board.TBoardConstants;
import tico.board.components.TComponent;
import tico.board.components.TLine;
import tico.editor.TBoardContainer;
import tico.editor.handler.TComponentMarqueeHandler;

public class TLineMarqueeHandler
extends TComponentMarqueeHandler {
    public TLineMarqueeHandler(TBoardContainer boardContainer) {
        super(boardContainer);
    }

    @Override
    protected TComponent createDefaultComponent(Rectangle2D bounds) {
        TLine line = new TLine();
        line.getAttributes().applyMap(this.getBoardContainer().getEditor().getCurrentAttributes());
        TBoardConstants.setBounds(line.getAttributes(), bounds);
        TBoardConstants.setStartCorner(line.getAttributes(), this.computeStartCorner());
        return line;
    }

    @Override
    public void overlay(JGraph graph, Graphics g2, boolean clear) {
        if (this.startPoint != null && this.currentPoint != null) {
            g2.drawLine((int)this.startPoint.getX(), (int)this.startPoint.getY(), (int)this.currentPoint.getX(), (int)this.currentPoint.getY());
        }
    }

    protected int computeStartCorner() {
        if (this.startPoint.getX() < this.currentPoint.getX()) {
            if (this.startPoint.getY() < this.currentPoint.getY()) {
                return 0;
            }
            return 5;
        }
        if (this.startPoint.getY() < this.currentPoint.getY()) {
            return 2;
        }
        return 7;
    }
}

