/*
 * Decompiled with CFR 0.152.
 */
package tico.editor.handler;

import java.awt.Dimension;
import java.awt.geom.Rectangle2D;
import tico.board.TBoardConstants;
import tico.board.components.TComponent;
import tico.board.components.TGrid;
import tico.board.components.TGridCell;
import tico.editor.TBoardContainer;
import tico.editor.handler.TComponentMarqueeHandler;

public class TGridMarqueeHandler
extends TComponentMarqueeHandler {
    private int columns;
    private int rows;

    public TGridMarqueeHandler(TBoardContainer boardContainer, Dimension dimension) {
        this(boardContainer, dimension.height, dimension.width);
    }

    public TGridMarqueeHandler(TBoardContainer boardContainer, int rows, int columns) {
        super(boardContainer);
        this.columns = columns;
        this.rows = rows;
    }

    @Override
    protected TComponent createDefaultComponent(Rectangle2D bounds) {
        double cellHorizontalGap = 10.0;
        double cellVerticalGap = 10.0;
        TGridCell[] childs = new TGridCell[this.columns * this.rows];
        double cellHeight = (bounds.getHeight() - (double)(this.rows - 1) * cellVerticalGap) / (double)this.rows;
        double cellWidth = (bounds.getWidth() - (double)(this.columns - 1) * cellHorizontalGap) / (double)this.columns;
        double currentY = bounds.getY();
        int i2 = 0;
        while (i2 < this.rows) {
            double currentX = bounds.getX();
            int j2 = 0;
            while (j2 < this.columns) {
                childs[this.columns * i2 + j2] = new TGridCell(i2 + 1, j2 + 1);
                childs[this.columns * i2 + j2].getAttributes().applyMap(this.getBoardContainer().getEditor().getCurrentAttributes());
                TBoardConstants.setBounds(childs[this.columns * i2 + j2].getAttributes(), new Rectangle2D.Double(currentX, currentY, cellWidth, cellHeight));
                currentX += cellWidth + cellHorizontalGap;
                ++j2;
            }
            currentY += cellHeight + cellVerticalGap;
            ++i2;
        }
        TGrid grid = new TGrid(childs);
        return grid;
    }
}

