/*
 * Decompiled with CFR 0.152.
 */
package tico.editor.handler;

import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jgraph.JGraph;
import tico.board.components.TComponent;
import tico.editor.TBoardContainer;
import tico.editor.handler.TBasicMarqueeHandler;

public abstract class TComponentMarqueeHandler
extends TBasicMarqueeHandler {
    protected static int MIN_HEIGHT = 5;
    protected static int MIN_WIDTH = 5;

    public TComponentMarqueeHandler(TBoardContainer boardContainer) {
        super(boardContainer);
    }

    @Override
    public boolean isForceMarqueeEvent(MouseEvent e2) {
        return true;
    }

    @Override
    public void handleMarqueeEvent(MouseEvent e2, JGraph graph, Rectangle2D bounds) {
        Rectangle2D snapBounds = graph.snap(bounds);
        if (bounds.getHeight() >= (double)MIN_HEIGHT || bounds.getWidth() >= (double)MIN_WIDTH) {
            TComponent component = this.createDefaultComponent(snapBounds);
            this.getBoard().getGraphLayoutCache().insert(component);
            e2.consume();
            this.getBoard().setMarqueeHandler(new TBasicMarqueeHandler(this.getBoardContainer()));
        }
    }

    @Override
    protected void processMouseDraggedEvent(MouseEvent e2) {
        Point eventPoint = e2.getPoint();
        if (((Point2D)eventPoint).getX() < 0.0) {
            e2.translatePoint((int)(-((Point2D)eventPoint).getX()), 0);
        }
        if (((Point2D)eventPoint).getY() < 0.0) {
            e2.translatePoint(0, (int)(-((Point2D)eventPoint).getY()));
        }
        super.processMouseDraggedEvent(e2);
    }

    protected abstract TComponent createDefaultComponent(Rectangle2D var1);
}

