/*
 * Decompiled with CFR 0.152.
 */
package tico.editor.handler;

import java.awt.event.MouseEvent;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import org.jgraph.graph.BasicMarqueeHandler;
import tico.board.TBoard;
import tico.board.components.TComponent;
import tico.board.componentview.TComponentView;
import tico.components.TMenuItem;
import tico.configuration.TLanguage;
import tico.editor.TBoardContainer;
import tico.editor.TEditor;
import tico.editor.actions.TBoardPropertiesAction;

public class TBasicMarqueeHandler
extends BasicMarqueeHandler {
    protected TBoardContainer boardContainer;
    private JPopupMenu menu;

    public TBasicMarqueeHandler(TBoardContainer boardContainer) {
        this.boardContainer = boardContainer;
    }

    protected TBoardContainer getBoardContainer() {
        return this.boardContainer;
    }

    protected TBoard getBoard() {
        return this.boardContainer.getBoard();
    }

    @Override
    public boolean isForceMarqueeEvent(MouseEvent e2) {
        if (e2.isShiftDown()) {
            return false;
        }
        if (SwingUtilities.isRightMouseButton(e2)) {
            return true;
        }
        if (e2.getClickCount() > 1) {
            return true;
        }
        return super.isForceMarqueeEvent(e2);
    }

    @Override
    public void mousePressed(MouseEvent e2) {
        if (SwingUtilities.isRightMouseButton(e2)) {
            TComponentView view = (TComponentView)this.getBoard().getNextViewAt(null, e2.getX(), (double)e2.getY(), true);
            if (view != null) {
                this.getBoard().setSelectionCell(view.getCell());
                this.menu = view.createPopupMenu(this.getBoardContainer().getEditor());
            } else {
                this.menu = this.createDefaultPopupMenu(this.getBoardContainer().getEditor());
            }
        } else if (e2.getClickCount() > 1) {
            TComponent component = (TComponent)this.getBoard().getFirstCellForLocation(e2.getX(), e2.getY());
            if (component != null) {
                this.getBoardContainer().getComponentDialogFactory().createComponentDialog(component);
            }
        } else {
            super.mousePressed(e2);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e2) {
        if (SwingUtilities.isRightMouseButton(e2)) {
            this.menu.show(this.getBoard(), e2.getX(), e2.getY());
            e2.consume();
        } else {
            super.mouseReleased(e2);
        }
    }

    private JPopupMenu createDefaultPopupMenu(TEditor editor) {
        JPopupMenu menu = new JPopupMenu();
        menu.add(new TMenuItem(new TBoardPropertiesAction(editor)));
        menu.add(new JSeparator());
        menu.add(new TMenuItem(editor.getActionSet().getAction("pasteAction")));
        menu.add(new JSeparator());
        menu.add(new TMenuItem(editor.getActionSet().getAction("undoAction")));
        menu.add(new TMenuItem(editor.getActionSet().getAction("redoAction")));
        menu.add(new JSeparator());
        JMenu subMenu = new JMenu(TLanguage.getString("TBasicMarqueeHandler.ALIGNMENT"));
        subMenu.add(new TMenuItem(editor.getActionSet().getAction("alignTopAction")));
        subMenu.add(new TMenuItem(editor.getActionSet().getAction("alignBottomAction")));
        subMenu.add(new TMenuItem(editor.getActionSet().getAction("alignLeftAction")));
        subMenu.add(new TMenuItem(editor.getActionSet().getAction("alignRightAction")));
        subMenu.add(new JSeparator());
        subMenu.add(new TMenuItem(editor.getActionSet().getAction("alignHorizontalAction")));
        subMenu.add(new TMenuItem(editor.getActionSet().getAction("alignVerticalAction")));
        subMenu.add(new JSeparator());
        subMenu.add(new TMenuItem(editor.getActionSet().getAction("fitWidthAction")));
        subMenu.add(new TMenuItem(editor.getActionSet().getAction("fitHeightAction")));
        subMenu.add(new JSeparator());
        subMenu.add(new TMenuItem(editor.getActionSet().getAction("horizontalGapAction")));
        subMenu.add(new TMenuItem(editor.getActionSet().getAction("verticalGapAction")));
        menu.add(subMenu);
        return menu;
    }
}

