/*
 * Decompiled with CFR 0.152.
 */
package tico.editor.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.border.TitledBorder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import tico.board.TBoardConstants;
import tico.board.TBoardModel;
import tico.components.TIdTextField;
import tico.components.TSizeChooser;
import tico.configuration.TLanguage;
import tico.configuration.TSetup;
import tico.editor.TBoardContainer;
import tico.editor.TEditor;
import tico.editor.dialogs.TPropertiesDialog;

public class newAndroidOptions
extends TPropertiesDialog {
    protected TIdTextField nameTextField;
    private JPanel orientationPanel;
    private String selectedOrientation;
    private TSizeChooser sizeChooser;
    private TEditor myEditor;
    private boolean firstEdit = true;

    public newAndroidOptions(TBoardContainer boardContainer) {
        super(boardContainer.getEditor());
        this.myEditor = boardContainer.getEditor();
        this.setTitle(TLanguage.getString("newAndroidOptions.TITLE"));
        this.createTabbedPane();
        this.setVisible(true);
    }

    private void createTabbedPane() {
        this.getPropertiesPane().setLayout(new GridBagLayout());
        GridBagConstraints c2 = new GridBagConstraints();
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab(TLanguage.getString("TBoardDialog.TAB_PROPERTIES"), this.createPropertiesPanel());
        c2.fill = 1;
        c2.insets = new Insets(0, 5, 5, 5);
        c2.gridx = 0;
        c2.gridy = 1;
        this.getPropertiesPane().add((Component)tabbedPane, c2);
    }

    private JPanel createPropertiesPanel() {
        JPanel propertiesPanel = new JPanel();
        GridBagConstraints c2 = new GridBagConstraints();
        propertiesPanel.setLayout(new GridBagLayout());
        this.createSizeChooser();
        this.createOrientationPanel();
        c2.fill = 2;
        c2.insets = new Insets(5, 10, 0, 10);
        c2.gridx = 0;
        c2.gridy = 0;
        propertiesPanel.add((Component)this.sizeChooser, c2);
        c2.fill = 2;
        c2.insets = new Insets(5, 10, 0, 10);
        c2.gridx = 0;
        c2.gridy = 1;
        propertiesPanel.add((Component)this.orientationPanel, c2);
        return propertiesPanel;
    }

    private void createSizeChooser() {
        Map map = ((TBoardModel)this.getBoard().getModel()).getAttributes();
        this.sizeChooser = new TSizeChooser();
        JLabel texto = new JLabel(TLanguage.getString("newAndroidOptions.SIZE_INSTRUCTIONS"));
        texto.setHorizontalAlignment(4);
        GridBagConstraints c2 = new GridBagConstraints();
        c2.fill = 0;
        c2.insets = new Insets(0, 0, 0, 0);
        c2.weightx = 0.5;
        c2.weighty = 1.0;
        c2.gridx = 0;
        c2.gridy = 1;
        c2.gridwidth = 4;
        this.sizeChooser.add((Component)texto, c2);
        this.sizeChooser.setSelectedSize(TBoardConstants.getSize(map));
    }

    private void createOrientationPanel() {
        this.orientationPanel = new JPanel();
        this.orientationPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.WHITE, new Color(165, 163, 151)), TLanguage.getString("TProjectDialog.ORIENTATION")));
        JRadioButton portraitMode = new JRadioButton(TLanguage.getString("TProjectDialog.PORTRAIT"));
        portraitMode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                newAndroidOptions.this.selectedOrientation = "portrait";
            }
        });
        if (TEditor.get_android_orientation().equals("portrait")) {
            portraitMode.setSelected(true);
            this.selectedOrientation = "portrait";
        }
        JRadioButton landscapeMode = new JRadioButton(TLanguage.getString("TProjectDialog.LANDSCAPE"));
        landscapeMode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                newAndroidOptions.this.selectedOrientation = "landscape";
            }
        });
        if (TEditor.get_android_orientation().equals("landscape")) {
            landscapeMode.setSelected(true);
            this.selectedOrientation = "landscape";
        }
        JRadioButton freeMode = new JRadioButton(TLanguage.getString("TProjectDialog.FREE"));
        freeMode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                newAndroidOptions.this.selectedOrientation = "free";
            }
        });
        if (TEditor.get_android_orientation().equals("free")) {
            freeMode.setSelected(true);
            this.selectedOrientation = "free";
        }
        ButtonGroup orientationsButtonGroup = new ButtonGroup();
        orientationsButtonGroup.add(portraitMode);
        orientationsButtonGroup.add(landscapeMode);
        orientationsButtonGroup.add(freeMode);
        this.orientationPanel.add(portraitMode);
        this.orientationPanel.add(landscapeMode);
        this.orientationPanel.add(freeMode);
    }

    @Override
    protected boolean applyValues() {
        Hashtable nested = new Hashtable();
        Hashtable attributeMap = new Hashtable();
        Vector removalAttributes = new Vector();
        Dimension board_dimension = this.sizeChooser.getSelectedSize();
        TBoardConstants.setSize(attributeMap, board_dimension);
        TEditor.set_board_height(board_dimension.height);
        TEditor.set_board_width(board_dimension.width);
        TSetup.setBoardHeight(board_dimension.height);
        TSetup.setBoardWidth(board_dimension.width);
        TEditor.set_android_orientation(this.selectedOrientation);
        TSetup.setOrientation(this.selectedOrientation);
        TBoardConstants.setRemoveAttributes(attributeMap, removalAttributes.toArray());
        nested.put(this.getBoard().getModel(), attributeMap);
        this.getBoard().getGraphLayoutCache().edit(nested);
        this.firstEdit = false;
        this.getBoard().updateUI();
        try {
            TSetup.save();
        }
        catch (ParserConfigurationException e2) {
            e2.printStackTrace();
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
        catch (TransformerException e4) {
            e4.printStackTrace();
        }
        return true;
    }
}

