/*
 * Decompiled with CFR 0.152.
 */
package tico.editor.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.TitledBorder;
import tico.board.TBoardConstants;
import tico.board.components.TComponent;
import tico.components.TBackgroundSelectionPanel;
import tico.components.TBorderSelectionPanel;
import tico.components.TFontModelChooser;
import tico.components.TIdTextField;
import tico.components.TTextAlignSelectorPanel;
import tico.components.TTextField;
import tico.configuration.TLanguage;
import tico.editor.TBoardContainer;
import tico.editor.TEditor;
import tico.editor.dialogs.TComponentDialog;

public class TTextAreaDialog
extends TComponentDialog {
    private static String DEFAULT_TITLE = TLanguage.getString("TTextAreaDialog.TITLE");
    private JTabbedPane tabbedPane;
    private JPanel textPropertiesPanel;
    private JPanel textFieldPanel;
    private TTextField textField;
    private TTextAlignSelectorPanel textAlignSelectorPanel;
    private JPanel idFieldPanel;
    private TIdTextField idTextField;
    private TFontModelChooser fontModel;
    private JPanel componentPropertiesPanel;
    private TBorderSelectionPanel borderSelectionPanel;
    private TBackgroundSelectionPanel backgroundSelectionPanel;

    public TTextAreaDialog(TBoardContainer boardContainer, TComponent textArea) {
        super(boardContainer, DEFAULT_TITLE, textArea);
    }

    @Override
    protected JPanel setComponentPane(TEditor editor) {
        JPanel componentPane = new JPanel();
        GridBagConstraints c2 = new GridBagConstraints();
        componentPane.setLayout(new GridBagLayout());
        this.createIdField();
        this.createTabbedPane();
        c2.fill = 2;
        c2.insets = new Insets(5, 10, 0, 10);
        c2.gridx = 0;
        c2.gridy = 0;
        componentPane.add((Component)this.idFieldPanel, c2);
        c2.fill = 1;
        c2.insets = new Insets(0, 5, 5, 5);
        c2.gridx = 0;
        c2.gridy = 1;
        componentPane.add((Component)this.tabbedPane, c2);
        return componentPane;
    }

    private void createIdField() {
        this.idFieldPanel = new JPanel();
        this.idFieldPanel.setLayout(new FlowLayout(2));
        this.idFieldPanel.add(new JLabel(TLanguage.getString("TTextAreaDialog.ID")));
        this.idTextField = new TIdTextField();
        this.idFieldPanel.add(this.idTextField);
        this.idTextField.setText(TBoardConstants.getId(this.getAttributeMap()));
    }

    private void createTabbedPane() {
        this.tabbedPane = new JTabbedPane();
        this.createTextPropertiesPanel();
        this.createComponentPropertiesPanel();
        this.tabbedPane.addTab(TLanguage.getString("TTextAreaDialog.TAB_TEXT"), this.textPropertiesPanel);
        this.tabbedPane.addTab(TLanguage.getString("TTextAreaDialog.TAB_PROPERTIES"), this.componentPropertiesPanel);
    }

    private void createTextPropertiesPanel() {
        this.textPropertiesPanel = new JPanel();
        GridBagConstraints c2 = new GridBagConstraints();
        this.textPropertiesPanel.setLayout(new GridBagLayout());
        this.createTextField();
        this.createTextAlignSelector();
        this.createFontModel();
        c2.fill = 2;
        c2.insets = new Insets(5, 10, 0, 10);
        c2.gridx = 0;
        c2.gridy = 0;
        this.textPropertiesPanel.add((Component)this.textFieldPanel, c2);
        c2.fill = 2;
        c2.insets = new Insets(5, 10, 0, 10);
        c2.gridx = 0;
        c2.gridy = 1;
        this.textPropertiesPanel.add((Component)this.textAlignSelectorPanel, c2);
        c2.fill = 2;
        c2.insets = new Insets(5, 10, 10, 10);
        c2.gridx = 0;
        c2.gridy = 2;
        this.textPropertiesPanel.add((Component)this.fontModel, c2);
    }

    private void createComponentPropertiesPanel() {
        this.componentPropertiesPanel = new JPanel();
        GridBagConstraints c2 = new GridBagConstraints();
        this.componentPropertiesPanel.setLayout(new GridBagLayout());
        this.createBorderSelectionPanel();
        this.createBackgroundSelectionPanel();
        c2.fill = 2;
        c2.insets = new Insets(5, 10, 0, 10);
        c2.gridx = 0;
        c2.gridy = 0;
        this.componentPropertiesPanel.add((Component)this.borderSelectionPanel, c2);
        c2.fill = 2;
        c2.insets = new Insets(5, 10, 10, 10);
        c2.gridx = 0;
        c2.gridy = 1;
        this.componentPropertiesPanel.add((Component)this.backgroundSelectionPanel, c2);
    }

    private void createTextAlignSelector() {
        Map map = this.getAttributeMap();
        this.textAlignSelectorPanel = new TTextAlignSelectorPanel();
        this.textAlignSelectorPanel.setHorizontalAlignment(TBoardConstants.getHorizontalAlignment(map));
        this.textAlignSelectorPanel.setVerticalAlignment(TBoardConstants.getVerticalAlignment(map));
    }

    private void createTextField() {
        Map map = this.getAttributeMap();
        this.textFieldPanel = new JPanel();
        this.textFieldPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.WHITE, new Color(165, 163, 151)), TLanguage.getString("TTextAreaDialog.TEXT")));
        this.textField = new TTextField(TBoardConstants.getText(map));
        this.textField.setColumns(30);
        this.textFieldPanel.add(this.textField);
    }

    private void createFontModel() {
        Map map = this.getAttributeMap();
        this.fontModel = new TFontModelChooser(TBoardConstants.getFont(map).getName(), TBoardConstants.getForeground(map), TBoardConstants.getFont(map).getSize(), TBoardConstants.getFont(map).getStyle());
    }

    private void createBorderSelectionPanel() {
        Map map = this.getAttributeMap();
        this.borderSelectionPanel = new TBorderSelectionPanel();
        this.borderSelectionPanel.setBorderColor(TBoardConstants.getBorderColor(map));
        this.borderSelectionPanel.setBorderSize(Math.max(1, Math.round(TBoardConstants.getLineWidth(map))));
    }

    private void createBackgroundSelectionPanel() {
        Map map = this.getAttributeMap();
        this.backgroundSelectionPanel = new TBackgroundSelectionPanel();
        this.backgroundSelectionPanel.setBackgroundColor(TBoardConstants.getBackground(map));
        this.backgroundSelectionPanel.setGradientColor(TBoardConstants.getGradientColor(map));
    }

    @Override
    protected Map newComponentsAttributeMap() {
        Hashtable nested = new Hashtable();
        Hashtable attributeMap = new Hashtable();
        Vector<String> removalAttributes = new Vector<String>();
        TBoardConstants.setText(attributeMap, this.textField.getText());
        TBoardConstants.setForeground(attributeMap, this.fontModel.getFontColor());
        TBoardConstants.setFont(attributeMap, new Font(this.fontModel.getFontFace(), this.fontModel.getFontStyle(), this.fontModel.getFontSize()));
        TBoardConstants.setHorizontalAlignment(attributeMap, this.textAlignSelectorPanel.getHorizontalAlignment());
        TBoardConstants.setVerticalAlignment(attributeMap, this.textAlignSelectorPanel.getVerticalAlignment());
        Color color = this.borderSelectionPanel.getBorderColor();
        if (color != null) {
            TBoardConstants.setBorderColor(attributeMap, color);
        } else {
            removalAttributes.add("bordercolor");
        }
        TBoardConstants.setLineWidth(attributeMap, this.borderSelectionPanel.getBorderSize());
        Color background = this.backgroundSelectionPanel.getBackgroundColor();
        if (background != null) {
            TBoardConstants.setBackground(attributeMap, background);
        } else {
            removalAttributes.add("backgroundColor");
        }
        Color gradient = this.backgroundSelectionPanel.getGradientColor();
        if (gradient != null) {
            TBoardConstants.setGradientColor(attributeMap, gradient);
        } else {
            removalAttributes.add("gradientColor");
        }
        TBoardConstants.setRemoveAttributes(attributeMap, removalAttributes.toArray());
        TBoardConstants.setId(attributeMap, this.idTextField.getText());
        nested.put(this.getComponent(), attributeMap);
        return nested;
    }
}

