/*
 * Decompiled with CFR 0.152.
 */
package tico.editor.dialogs;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.Line2D;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Enumeration;
import java.util.Vector;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.SoftBevelBorder;
import tico.components.resources.SoundFilter;
import tico.configuration.TLanguage;

public class TRecordSound
extends JDialog
implements ActionListener {
    static File defaultDirectory = null;
    public static File text = null;
    final int bufSize = 16384;
    FormatControls formatControls = new FormatControls();
    Capture capture = new Capture();
    Playback playback = new Playback();
    AudioInputStream audioInputStream;
    SamplingGraph samplingGraph;
    JButton play;
    JButton record;
    JButton pause;
    JButton save;
    JButton exit;
    JButton auB;
    JButton aiffB;
    JTextField textField;
    String fileName = "untitled";
    String errStr;
    double duration;
    double seconds;
    File file;
    Vector lines = new Vector();
    String extension;

    public TRecordSound() {
        this.setTitle(TLanguage.getString("TSoundChooser.RECORD"));
        this.setModal(true);
        this.setDefaultCloseOperation(2);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int w2 = 720;
        int h2 = 340;
        this.setLocation(screenSize.width / 2 - w2 / 2, screenSize.height / 2 - h2 / 2);
        this.setSize(w2, h2);
        this.getContentPane().setLayout(new BorderLayout());
        EmptyBorder eb = new EmptyBorder(5, 5, 5, 5);
        SoftBevelBorder sbb = new SoftBevelBorder(1);
        JPanel p1 = new JPanel();
        p1.setLayout(new BoxLayout(p1, 0));
        JPanel p2 = new JPanel();
        p2.setBorder(sbb);
        p2.setLayout(new BoxLayout(p2, 1));
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setBorder(new EmptyBorder(10, 0, 5, 0));
        this.play = this.addButton(TLanguage.getString("TRecordSound.PLAY"), buttonsPanel, false);
        this.record = this.addButton(TLanguage.getString("TRecordSound.RECORD"), buttonsPanel, true);
        this.pause = this.addButton(TLanguage.getString("TRecordSound.PAUSE"), buttonsPanel, false);
        p2.add(buttonsPanel);
        JPanel samplingPanel = new JPanel(new BorderLayout());
        eb = new EmptyBorder(10, 20, 20, 20);
        samplingPanel.setBorder(new CompoundBorder(eb, sbb));
        this.samplingGraph = new SamplingGraph();
        samplingPanel.add(this.samplingGraph);
        p2.add(samplingPanel);
        JPanel savePanel = new JPanel();
        savePanel.setLayout(new BoxLayout(savePanel, 1));
        JPanel saveExitPanel = new JPanel();
        this.save = this.addButton(TLanguage.getString("TRecordSound.SAVE"), saveExitPanel, false);
        this.exit = new JButton(TLanguage.getString("TRecordSound.EXIT"));
        this.exit.setEnabled(true);
        this.exit.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e2) {
                TRecordSound.this.dispose();
            }
        });
        saveExitPanel.add(this.exit);
        savePanel.add(saveExitPanel);
        p2.add(savePanel);
        p1.add(p2);
        this.setContentPane(p1);
        this.setVisible(true);
    }

    public void open() {
    }

    public void close() {
        if (this.playback.thread != null) {
            this.play.doClick(0);
        }
        if (this.capture.thread != null) {
            this.record.doClick(0);
        }
    }

    private JButton addButton(String name, JPanel panel, boolean state) {
        JButton button = new JButton(name);
        button.addActionListener(this);
        button.setEnabled(state);
        panel.add(button);
        return button;
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        Object obj = e2.getSource();
        if (obj.equals(this.save)) {
            JFileChooser chooser = new JFileChooser();
            chooser.setDialogTitle(TLanguage.getString("TRecordSound.TITLE"));
            chooser.setCurrentDirectory(defaultDirectory);
            chooser.addChoosableFileFilter(new SoundFilter());
            chooser.setAcceptAllFileFilterUsed(false);
            int returnVal = chooser.showSaveDialog(this.getParent());
            if (returnVal == 0) {
                defaultDirectory = chooser.getCurrentDirectory();
                this.saveToFile(chooser.getName(chooser.getSelectedFile()), AudioFileFormat.Type.WAVE);
            } else {
                text = null;
            }
        } else if (obj.equals(this.play)) {
            if (this.play.getText().startsWith(TLanguage.getString("TRecordSound.PLAY"))) {
                this.playback.start();
                this.samplingGraph.start();
                this.record.setEnabled(false);
                this.pause.setEnabled(true);
                this.save.setEnabled(false);
                this.exit.setEnabled(false);
                this.play.setText(TLanguage.getString("TRecordSound.STOP"));
            } else {
                this.playback.stop();
                this.samplingGraph.stop();
                this.record.setEnabled(true);
                this.pause.setEnabled(false);
                this.exit.setEnabled(true);
                this.play.setText(TLanguage.getString("TRecordSound.PLAY"));
            }
        } else if (obj.equals(this.record)) {
            if (this.record.getText().startsWith(TLanguage.getString("TRecordSound.RECORD"))) {
                this.file = null;
                this.capture.start();
                this.fileName = "untitled";
                this.samplingGraph.start();
                this.play.setEnabled(false);
                this.pause.setEnabled(true);
                this.save.setEnabled(false);
                this.exit.setEnabled(false);
                this.record.setText(TLanguage.getString("TRecordSound.STOP"));
            } else {
                this.lines.removeAllElements();
                this.capture.stop();
                this.samplingGraph.stop();
                this.play.setEnabled(true);
                this.pause.setEnabled(false);
                this.save.setEnabled(true);
                this.exit.setEnabled(true);
                this.record.setText(TLanguage.getString("TRecordSound.RECORD"));
            }
        } else if (obj.equals(this.pause)) {
            if (this.pause.getText().startsWith(TLanguage.getString("TRecordSound.PAUSE"))) {
                if (this.capture.thread != null) {
                    this.capture.line.stop();
                } else if (this.playback.thread != null) {
                    this.playback.line.stop();
                }
                this.pause.setText(TLanguage.getString("TRecordSound.RESUME"));
            } else {
                if (this.capture.thread != null) {
                    this.capture.line.start();
                } else if (this.playback.thread != null) {
                    this.playback.line.start();
                }
                this.pause.setText(TLanguage.getString("TRecordSound.PAUSE"));
            }
        }
    }

    public void createAudioInputStream(File file, boolean updateComponents) {
        if (file != null && file.isFile()) {
            try {
                this.file = file;
                this.errStr = null;
                this.audioInputStream = AudioSystem.getAudioInputStream(file);
                this.play.setEnabled(true);
                this.fileName = file.getName();
                long milliseconds = (long)((float)(this.audioInputStream.getFrameLength() * 1000L) / this.audioInputStream.getFormat().getFrameRate());
                this.duration = (double)milliseconds / 1000.0;
                this.save.setEnabled(true);
                if (updateComponents) {
                    this.formatControls.setFormat(this.audioInputStream.getFormat());
                    this.samplingGraph.createWaveForm(null);
                }
            }
            catch (Exception ex) {
                this.reportStatus(ex.toString());
            }
        } else {
            this.reportStatus("Audio file required.");
        }
    }

    public static String getExtension(String s2) {
        String ext = null;
        int i2 = s2.lastIndexOf(46);
        if (i2 > 0 && i2 < s2.length() - 1) {
            ext = s2.substring(i2 + 1).toLowerCase();
        }
        return ext;
    }

    public void saveToFile(String name, AudioFileFormat.Type fileType) {
        File file;
        if (this.audioInputStream == null) {
            this.reportStatus("No loaded audio to save");
            return;
        }
        if (this.file != null) {
            this.createAudioInputStream(this.file, false);
        }
        try {
            this.audioInputStream.reset();
        }
        catch (Exception e2) {
            this.reportStatus("Unable to reset stream " + e2);
            return;
        }
        this.extension = TRecordSound.getExtension(name);
        if (this.extension == null) {
            name = String.valueOf(name) + ".wav";
        }
        this.fileName = defaultDirectory + File.separator + name;
        text = file = new File(this.fileName);
        try {
            if (AudioSystem.write(this.audioInputStream, fileType, file) == -1) {
                throw new IOException("Problems writing to file");
            }
        }
        catch (Exception ex) {
            this.reportStatus(ex.toString());
        }
        this.samplingGraph.repaint();
    }

    private void reportStatus(String msg) {
        this.errStr = msg;
        if (this.errStr != null) {
            System.out.println(this.errStr);
            this.samplingGraph.repaint();
        }
    }

    public static void main(String[] args) {
        TRecordSound capturePlayback = new TRecordSound();
        capturePlayback.open();
        JFrame f2 = new JFrame("Capture/Playback");
        f2.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e2) {
                System.exit(0);
            }
        });
        f2.getContentPane().add("Center", capturePlayback);
        f2.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int w2 = 720;
        int h2 = 340;
        f2.setLocation(screenSize.width / 2 - w2 / 2, screenSize.height / 2 - h2 / 2);
        f2.setSize(w2, h2);
        f2.setVisible(true);
    }

    class Capture
    implements Runnable {
        TargetDataLine line;
        Thread thread;

        Capture() {
        }

        public void start() {
            TRecordSound.this.errStr = null;
            this.thread = new Thread(this);
            this.thread.setName("Capture");
            this.thread.start();
        }

        public void stop() {
            this.thread = null;
        }

        private void shutDown(String message) {
            TRecordSound.this.errStr = message;
            if (TRecordSound.this.errStr != null && this.thread != null) {
                this.thread = null;
                TRecordSound.this.samplingGraph.stop();
                TRecordSound.this.play.setEnabled(true);
                TRecordSound.this.pause.setEnabled(false);
                TRecordSound.this.save.setEnabled(true);
                TRecordSound.this.record.setText(TLanguage.getString("TRecordSound.RECORD"));
                System.err.println(TRecordSound.this.errStr);
                TRecordSound.this.samplingGraph.repaint();
            }
        }

        @Override
        public void run() {
            TRecordSound.this.duration = 0.0;
            TRecordSound.this.audioInputStream = null;
            AudioFormat format = TRecordSound.this.formatControls.getFormat();
            DataLine.Info info = new DataLine.Info(TargetDataLine.class, format);
            if (!AudioSystem.isLineSupported(info)) {
                this.shutDown("Line matching " + info + " not supported.");
                return;
            }
            try {
                this.line = (TargetDataLine)AudioSystem.getLine(info);
                this.line.open(format, this.line.getBufferSize());
            }
            catch (LineUnavailableException ex) {
                this.shutDown("Unable to open the line: " + ex);
                return;
            }
            catch (SecurityException ex) {
                this.shutDown(ex.toString());
                return;
            }
            catch (Exception ex) {
                this.shutDown(ex.toString());
                return;
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int frameSizeInBytes = format.getFrameSize();
            int bufferLengthInFrames = this.line.getBufferSize() / 8;
            int bufferLengthInBytes = bufferLengthInFrames * frameSizeInBytes;
            byte[] data = new byte[bufferLengthInBytes];
            this.line.start();
            while (this.thread != null) {
                int numBytesRead = this.line.read(data, 0, bufferLengthInBytes);
                if (numBytesRead == -1) break;
                out.write(data, 0, numBytesRead);
            }
            this.line.stop();
            this.line.close();
            this.line = null;
            try {
                out.flush();
                out.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            byte[] audioBytes = out.toByteArray();
            ByteArrayInputStream bais = new ByteArrayInputStream(audioBytes);
            TRecordSound.this.audioInputStream = new AudioInputStream(bais, format, audioBytes.length / frameSizeInBytes);
            long milliseconds = (long)((float)(TRecordSound.this.audioInputStream.getFrameLength() * 1000L) / format.getFrameRate());
            TRecordSound.this.duration = (double)milliseconds / 1000.0;
            try {
                TRecordSound.this.audioInputStream.reset();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return;
            }
            TRecordSound.this.samplingGraph.createWaveForm(audioBytes);
        }
    }

    class FormatControls
    extends JPanel {
        Vector groups = new Vector();
        JToggleButton linrB;
        JToggleButton ulawB;
        JToggleButton alawB;
        JToggleButton rate8B;
        JToggleButton rate11B;
        JToggleButton rate16B;
        JToggleButton rate22B;
        JToggleButton rate44B;
        JToggleButton size8B;
        JToggleButton size16B;
        JToggleButton signB;
        JToggleButton unsignB;
        JToggleButton litB;
        JToggleButton bigB;
        JToggleButton monoB;
        JToggleButton sterB;

        public FormatControls() {
            this.setLayout(new GridLayout(0, 1));
            EmptyBorder eb = new EmptyBorder(0, 0, 0, 5);
            BevelBorder bb = new BevelBorder(1);
            CompoundBorder cb = new CompoundBorder(eb, bb);
            this.setBorder(new CompoundBorder(cb, new EmptyBorder(8, 5, 5, 5)));
            JPanel p1 = new JPanel();
            ButtonGroup encodingGroup = new ButtonGroup();
            this.linrB = this.addToggleButton(p1, encodingGroup, "linear", true);
            this.ulawB = this.addToggleButton(p1, encodingGroup, "ulaw", false);
            this.alawB = this.addToggleButton(p1, encodingGroup, "alaw", false);
            this.add(p1);
            this.groups.addElement(encodingGroup);
            JPanel p2 = new JPanel();
            JPanel p2b = new JPanel();
            ButtonGroup sampleRateGroup = new ButtonGroup();
            this.rate8B = this.addToggleButton(p2, sampleRateGroup, "8000", false);
            this.rate11B = this.addToggleButton(p2, sampleRateGroup, "11025", false);
            this.rate16B = this.addToggleButton(p2b, sampleRateGroup, "16000", false);
            this.rate22B = this.addToggleButton(p2b, sampleRateGroup, "22050", false);
            this.rate44B = this.addToggleButton(p2b, sampleRateGroup, "44100", true);
            this.add(p2);
            this.add(p2b);
            this.groups.addElement(sampleRateGroup);
            JPanel p3 = new JPanel();
            ButtonGroup sampleSizeInBitsGroup = new ButtonGroup();
            this.size8B = this.addToggleButton(p3, sampleSizeInBitsGroup, "8", false);
            this.size16B = this.addToggleButton(p3, sampleSizeInBitsGroup, "16", true);
            this.add(p3);
            this.groups.addElement(sampleSizeInBitsGroup);
            JPanel p4 = new JPanel();
            ButtonGroup signGroup = new ButtonGroup();
            this.signB = this.addToggleButton(p4, signGroup, "signed", true);
            this.unsignB = this.addToggleButton(p4, signGroup, "unsigned", false);
            this.add(p4);
            this.groups.addElement(signGroup);
            JPanel p5 = new JPanel();
            ButtonGroup endianGroup = new ButtonGroup();
            this.litB = this.addToggleButton(p5, endianGroup, "little endian", false);
            this.bigB = this.addToggleButton(p5, endianGroup, "big endian", true);
            this.add(p5);
            this.groups.addElement(endianGroup);
            JPanel p6 = new JPanel();
            ButtonGroup channelsGroup = new ButtonGroup();
            this.monoB = this.addToggleButton(p6, channelsGroup, "mono", false);
            this.sterB = this.addToggleButton(p6, channelsGroup, "stereo", true);
            this.add(p6);
            this.groups.addElement(channelsGroup);
        }

        private JToggleButton addToggleButton(JPanel p2, ButtonGroup g2, String name, boolean state) {
            JToggleButton b2 = new JToggleButton(name, state);
            p2.add(b2);
            g2.add(b2);
            return b2;
        }

        public AudioFormat getFormat() {
            int channels;
            Vector<String> v2 = new Vector<String>(this.groups.size());
            int i2 = 0;
            while (i2 < this.groups.size()) {
                ButtonGroup g2 = (ButtonGroup)this.groups.get(i2);
                Enumeration<AbstractButton> e2 = g2.getElements();
                while (e2.hasMoreElements()) {
                    AbstractButton b2 = e2.nextElement();
                    if (!b2.isSelected()) continue;
                    v2.add(b2.getText());
                    break;
                }
                ++i2;
            }
            AudioFormat.Encoding encoding = AudioFormat.Encoding.ULAW;
            String encString = (String)v2.get(0);
            float rate = Float.valueOf((String)v2.get(1)).floatValue();
            int sampleSize = Integer.valueOf((String)v2.get(2));
            String signedString = (String)v2.get(3);
            boolean bigEndian = ((String)v2.get(4)).startsWith("big");
            int n2 = channels = ((String)v2.get(5)).equals("mono") ? 1 : 2;
            if (encString.equals("linear")) {
                encoding = signedString.equals("signed") ? AudioFormat.Encoding.PCM_SIGNED : AudioFormat.Encoding.PCM_UNSIGNED;
            } else if (encString.equals("alaw")) {
                encoding = AudioFormat.Encoding.ALAW;
            }
            return new AudioFormat(encoding, rate, sampleSize, channels, sampleSize / 8 * channels, rate, bigEndian);
        }

        public void setFormat(AudioFormat format) {
            AudioFormat.Encoding type = format.getEncoding();
            if (type == AudioFormat.Encoding.ULAW) {
                this.ulawB.doClick();
            } else if (type == AudioFormat.Encoding.ALAW) {
                this.alawB.doClick();
            } else if (type == AudioFormat.Encoding.PCM_SIGNED) {
                this.linrB.doClick();
                this.signB.doClick();
            } else if (type == AudioFormat.Encoding.PCM_UNSIGNED) {
                this.linrB.doClick();
                this.unsignB.doClick();
            }
            float rate = format.getFrameRate();
            if (rate == 8000.0f) {
                this.rate8B.doClick();
            } else if (rate == 11025.0f) {
                this.rate11B.doClick();
            } else if (rate == 16000.0f) {
                this.rate16B.doClick();
            } else if (rate == 22050.0f) {
                this.rate22B.doClick();
            } else if (rate == 44100.0f) {
                this.rate44B.doClick();
            }
            switch (format.getSampleSizeInBits()) {
                case 8: {
                    this.size8B.doClick();
                    break;
                }
                case 16: {
                    this.size16B.doClick();
                }
            }
            if (format.isBigEndian()) {
                this.bigB.doClick();
            } else {
                this.litB.doClick();
            }
            if (format.getChannels() == 1) {
                this.monoB.doClick();
            } else {
                this.sterB.doClick();
            }
        }
    }

    public class Playback
    implements Runnable {
        SourceDataLine line;
        Thread thread;

        public void start() {
            TRecordSound.this.errStr = null;
            this.thread = new Thread(this);
            this.thread.setName("Playback");
            this.thread.start();
        }

        public void stop() {
            this.thread = null;
        }

        private void shutDown(String message) {
            TRecordSound.this.errStr = message;
            if (TRecordSound.this.errStr != null) {
                System.err.println(TRecordSound.this.errStr);
                TRecordSound.this.samplingGraph.repaint();
            }
            if (this.thread != null) {
                this.thread = null;
                TRecordSound.this.samplingGraph.stop();
                TRecordSound.this.record.setEnabled(true);
                TRecordSound.this.pause.setEnabled(false);
                TRecordSound.this.play.setText(TLanguage.getString("TRecordSound.PLAY"));
            }
        }

        @Override
        public void run() {
            if (TRecordSound.this.file != null) {
                TRecordSound.this.createAudioInputStream(TRecordSound.this.file, false);
            }
            if (TRecordSound.this.audioInputStream == null) {
                this.shutDown("No loaded audio to play back");
                return;
            }
            try {
                TRecordSound.this.audioInputStream.reset();
            }
            catch (Exception e2) {
                this.shutDown("Unable to reset the stream\n" + e2);
                return;
            }
            AudioFormat format = TRecordSound.this.formatControls.getFormat();
            AudioInputStream playbackInputStream = AudioSystem.getAudioInputStream(format, TRecordSound.this.audioInputStream);
            if (playbackInputStream == null) {
                this.shutDown("Unable to convert stream of format " + TRecordSound.this.audioInputStream + " to format " + format);
                return;
            }
            DataLine.Info info = new DataLine.Info(SourceDataLine.class, format);
            if (!AudioSystem.isLineSupported(info)) {
                this.shutDown("Line matching " + info + " not supported.");
                return;
            }
            try {
                this.line = (SourceDataLine)AudioSystem.getLine(info);
                this.line.open(format, 16384);
            }
            catch (LineUnavailableException ex) {
                this.shutDown("Unable to open the line: " + ex);
                return;
            }
            int frameSizeInBytes = format.getFrameSize();
            int bufferLengthInFrames = this.line.getBufferSize() / 8;
            int bufferLengthInBytes = bufferLengthInFrames * frameSizeInBytes;
            byte[] data = new byte[bufferLengthInBytes];
            int numBytesRead = 0;
            this.line.start();
            while (this.thread != null) {
                try {
                    numBytesRead = playbackInputStream.read(data);
                    if (numBytesRead == -1) break;
                    int numBytesRemaining = numBytesRead;
                    while (numBytesRemaining > 0) {
                        numBytesRemaining -= this.line.write(data, 0, numBytesRemaining);
                    }
                }
                catch (Exception e3) {
                    this.shutDown("Error during playback: " + e3);
                    break;
                }
            }
            if (this.thread != null) {
                this.line.drain();
            }
            this.line.stop();
            this.line.close();
            this.line = null;
            this.shutDown(null);
        }
    }

    class SamplingGraph
    extends JPanel
    implements Runnable {
        private Thread thread;
        private Font font10 = new Font("serif", 0, 10);
        private Font font12 = new Font("serif", 0, 12);
        Color jfcBlue = new Color(204, 204, 255);
        Color pink = new Color(255, 175, 175);

        public SamplingGraph() {
            this.setBackground(new Color(20, 20, 20));
        }

        public void createWaveForm(byte[] audioBytes) {
            int i2;
            int nlengthInSamples;
            TRecordSound.this.lines.removeAllElements();
            AudioFormat format = TRecordSound.this.audioInputStream.getFormat();
            if (audioBytes == null) {
                try {
                    audioBytes = new byte[(int)(TRecordSound.this.audioInputStream.getFrameLength() * (long)format.getFrameSize())];
                    TRecordSound.this.audioInputStream.read(audioBytes);
                }
                catch (Exception ex) {
                    TRecordSound.this.reportStatus(ex.toString());
                    return;
                }
            }
            Dimension d2 = this.getSize();
            int w2 = d2.width;
            int h2 = d2.height - 15;
            int[] audioData = null;
            if (format.getSampleSizeInBits() == 16) {
                nlengthInSamples = audioBytes.length / 2;
                audioData = new int[nlengthInSamples];
                if (format.isBigEndian()) {
                    i2 = 0;
                    while (i2 < nlengthInSamples) {
                        byte MSB = audioBytes[2 * i2];
                        byte LSB = audioBytes[2 * i2 + 1];
                        audioData[i2] = MSB << 8 | 0xFF & LSB;
                        ++i2;
                    }
                } else {
                    i2 = 0;
                    while (i2 < nlengthInSamples) {
                        byte LSB = audioBytes[2 * i2];
                        byte MSB = audioBytes[2 * i2 + 1];
                        audioData[i2] = MSB << 8 | 0xFF & LSB;
                        ++i2;
                    }
                }
            } else if (format.getSampleSizeInBits() == 8) {
                nlengthInSamples = audioBytes.length;
                audioData = new int[nlengthInSamples];
                if (format.getEncoding().toString().startsWith("PCM_SIGN")) {
                    i2 = 0;
                    while (i2 < audioBytes.length) {
                        audioData[i2] = audioBytes[i2];
                        ++i2;
                    }
                } else {
                    i2 = 0;
                    while (i2 < audioBytes.length) {
                        audioData[i2] = audioBytes[i2] - 128;
                        ++i2;
                    }
                }
            }
            int frames_per_pixel = audioBytes.length / format.getFrameSize() / w2;
            byte my_byte = 0;
            double y_last = 0.0;
            int numChannels = format.getChannels();
            double x2 = 0.0;
            while (x2 < (double)w2 && audioData != null) {
                int idx = (int)((double)(frames_per_pixel * numChannels) * x2);
                my_byte = format.getSampleSizeInBits() == 8 ? (byte)audioData[idx] : (byte)(128 * audioData[idx] / 32768);
                double y_new = h2 * (128 - my_byte) / 256;
                TRecordSound.this.lines.add(new Line2D.Double(x2, y_last, x2, y_new));
                y_last = y_new;
                x2 += 1.0;
            }
            this.repaint();
        }

        @Override
        public void paint(Graphics g2) {
            Dimension d2 = this.getSize();
            int w2 = d2.width;
            int h2 = d2.height;
            int INFOPAD = 15;
            Graphics2D g22 = (Graphics2D)g2;
            g22.setBackground(this.getBackground());
            g22.clearRect(0, 0, w2, h2);
            g22.setColor(Color.white);
            g22.fillRect(0, h2 - INFOPAD, w2, INFOPAD);
            if (TRecordSound.this.errStr != null) {
                g22.setColor(this.jfcBlue);
                g22.setFont(new Font("serif", 1, 18));
                g22.drawString("ERROR", 5, 20);
                AttributedString as2 = new AttributedString(TRecordSound.this.errStr);
                as2.addAttribute(TextAttribute.FONT, this.font12, 0, TRecordSound.this.errStr.length());
                AttributedCharacterIterator aci = as2.getIterator();
                FontRenderContext frc = g22.getFontRenderContext();
                LineBreakMeasurer lbm = new LineBreakMeasurer(aci, frc);
                float x2 = 5.0f;
                float y2 = 25.0f;
                lbm.setPosition(0);
                while (lbm.getPosition() < TRecordSound.this.errStr.length()) {
                    TextLayout tl = lbm.nextLayout((float)w2 - x2 - 5.0f);
                    if (!tl.isLeftToRight()) {
                        x2 = (float)w2 - tl.getAdvance();
                    }
                    tl.draw(g22, x2, y2 += tl.getAscent());
                    y2 += tl.getDescent() + tl.getLeading();
                }
            } else if (TRecordSound.this.capture.thread != null) {
                g22.setColor(Color.black);
                g22.setFont(this.font12);
                g22.drawString("Length: " + String.valueOf(TRecordSound.this.seconds), 3, h2 - 4);
            } else {
                g22.setColor(Color.black);
                g22.setFont(this.font12);
                g22.drawString("File: " + TRecordSound.this.fileName + "  Length: " + String.valueOf(TRecordSound.this.duration) + "  Position: " + String.valueOf(TRecordSound.this.seconds), 3, h2 - 4);
                if (TRecordSound.this.audioInputStream != null) {
                    g22.setColor(this.jfcBlue);
                    int i2 = 1;
                    while (i2 < TRecordSound.this.lines.size()) {
                        g22.draw((Line2D)TRecordSound.this.lines.get(i2));
                        ++i2;
                    }
                    if (TRecordSound.this.seconds != 0.0) {
                        double loc = TRecordSound.this.seconds / TRecordSound.this.duration * (double)w2;
                        g22.setColor(this.pink);
                        g22.setStroke(new BasicStroke(3.0f));
                        g22.draw(new Line2D.Double(loc, 0.0, loc, h2 - INFOPAD - 2));
                    }
                }
            }
        }

        public void start() {
            this.thread = new Thread(this);
            this.thread.setName("SamplingGraph");
            this.thread.start();
            TRecordSound.this.seconds = 0.0;
        }

        public void stop() {
            if (this.thread != null) {
                this.thread.interrupt();
            }
            this.thread = null;
        }

        @Override
        public void run() {
            TRecordSound.this.seconds = 0.0;
            block4: while (this.thread != null) {
                if (TRecordSound.this.playback.line != null && TRecordSound.this.playback.line.isOpen()) {
                    long milliseconds = TRecordSound.this.playback.line.getMicrosecondPosition() / 1000L;
                    TRecordSound.this.seconds = (double)milliseconds / 1000.0;
                } else if (TRecordSound.this.capture.line != null && TRecordSound.this.capture.line.isActive()) {
                    long milliseconds = TRecordSound.this.capture.line.getMicrosecondPosition() / 1000L;
                    TRecordSound.this.seconds = (double)milliseconds / 1000.0;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (Exception e2) {
                    break;
                }
                this.repaint();
                while (TRecordSound.this.capture.line != null && !TRecordSound.this.capture.line.isActive() || TRecordSound.this.playback.line != null && !TRecordSound.this.playback.line.isOpen()) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (Exception e3) {
                        continue block4;
                    }
                }
            }
            TRecordSound.this.seconds = 0.0;
            TRecordSound.this.save.setEnabled(true);
            TRecordSound.this.exit.setEnabled(true);
            this.repaint();
        }
    }
}

