/*
 * Decompiled with CFR 0.152.
 */
package tico.editor.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import tico.board.TBoard;
import tico.components.TButton;
import tico.components.TDialog;
import tico.configuration.TLanguage;
import tico.editor.TBoardContainer;
import tico.editor.TEditor;

public abstract class TPropertiesDialog
extends TDialog {
    private TEditor editor;
    private JPanel mainPanel;

    public TPropertiesDialog(TEditor editor) {
        super((Frame)editor, true);
        this.editor = editor;
        this.setDefaultCloseOperation(2);
        this.createPanels();
    }

    @Override
    public void setVisible(boolean visible) {
        this.setResizable(true);
        this.pack();
        this.setLocationRelativeTo(this.editor);
        super.setVisible(visible);
    }

    private void createPanels() {
        this.mainPanel = new JPanel();
        JPanel buttonPanel = this.createButtonPanel();
        Container auxContainer = new Container();
        auxContainer.setLayout(new BorderLayout());
        auxContainer.add((Component)this.mainPanel, "North");
        auxContainer.add((Component)buttonPanel, "South");
        JScrollPane jScrollPane = new JScrollPane(auxContainer, 20, 30);
        this.getContentPane().add(jScrollPane);
    }

    private JPanel createButtonPanel() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        TButton accept = new TButton(TLanguage.getString("TPropertiesDialog.BUTTON_ACCEPT"));
        accept.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                if (TPropertiesDialog.this.applyValues()) {
                    TPropertiesDialog.this.dispose();
                }
            }
        });
        buttonPanel.add(accept);
        TButton apply = new TButton(TLanguage.getString("TPropertiesDialog.BUTTON_APPLY"));
        apply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TPropertiesDialog.this.applyValues();
            }
        });
        buttonPanel.add(apply);
        TButton cancel = new TButton(TLanguage.getString("TPropertiesDialog.BUTTON_CANCEL"));
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TPropertiesDialog.this.dispose();
            }
        });
        buttonPanel.add(cancel);
        return buttonPanel;
    }

    protected TBoard getBoard() {
        return this.editor.getCurrentBoard();
    }

    protected TBoardContainer getBoardContainer() {
        return this.editor.getCurrentBoardContainer();
    }

    protected TEditor getEditor() {
        return this.editor;
    }

    public JPanel getPropertiesPane() {
        return this.mainPanel;
    }

    protected abstract boolean applyValues();
}

