/*
 * Decompiled with CFR 0.152.
 */
package tico.editor.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.border.TitledBorder;
import tico.board.TProject;
import tico.components.TInitialBoardSelectionPanel;
import tico.configuration.TLanguage;
import tico.editor.TEditor;
import tico.editor.dialogs.TPropertiesDialog;

public class TProjectDialog
extends TPropertiesDialog {
    private TProject currentProject;
    private TInitialBoardSelectionPanel initialBoardPanel;
    private JPanel orientationPanel;
    private String selectedOrientation;

    public TProjectDialog(TEditor editor) {
        super(editor);
        this.setTitle(TLanguage.getString("TProjectDialog.TITLE"));
        this.currentProject = editor.getProject();
        this.createTabbedPane();
        this.setVisible(true);
    }

    private void createTabbedPane() {
        this.getPropertiesPane().setLayout(new GridBagLayout());
        GridBagConstraints c2 = new GridBagConstraints();
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab(TLanguage.getString("TProjectDialog.TAB_PROPERTIES"), this.createPropertiesPanel());
        c2.fill = 1;
        c2.insets = new Insets(0, 5, 5, 5);
        c2.gridx = 0;
        c2.gridy = 1;
        this.getPropertiesPane().add((Component)tabbedPane, c2);
    }

    private JPanel createPropertiesPanel() {
        JPanel preferencesPanel = new JPanel();
        GridBagConstraints c2 = new GridBagConstraints();
        preferencesPanel.setLayout(new GridBagLayout());
        this.createInitialBoardPanel();
        this.createOrientationPanel();
        c2.fill = 2;
        c2.insets = new Insets(5, 10, 10, 10);
        c2.gridx = 0;
        c2.gridy = 0;
        preferencesPanel.add((Component)this.initialBoardPanel, c2);
        if (TEditor.get_android_mode()) {
            c2.fill = 2;
            c2.insets = new Insets(5, 10, 10, 10);
            c2.gridx = 0;
            c2.gridy = 1;
            preferencesPanel.add((Component)this.orientationPanel, c2);
        }
        return preferencesPanel;
    }

    private void createInitialBoardPanel() {
        ArrayList boardList = this.currentProject.getBoardList();
        this.initialBoardPanel = new TInitialBoardSelectionPanel(boardList);
        this.initialBoardPanel.setInitialBoard(this.currentProject.getInitialBoard());
    }

    private void createOrientationPanel() {
        this.orientationPanel = new JPanel();
        this.orientationPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.WHITE, new Color(165, 163, 151)), TLanguage.getString("TProjectDialog.ORIENTATION")));
        JRadioButton portraitMode = new JRadioButton(TLanguage.getString("TProjectDialog.PORTRAIT"));
        portraitMode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TProjectDialog.this.selectedOrientation = "portrait";
            }
        });
        if (TEditor.get_android_orientation().equals("portrait")) {
            portraitMode.setSelected(true);
            this.selectedOrientation = "portrait";
        }
        JRadioButton landscapeMode = new JRadioButton(TLanguage.getString("TProjectDialog.LANDSCAPE"));
        landscapeMode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TProjectDialog.this.selectedOrientation = "landscape";
            }
        });
        if (TEditor.get_android_orientation().equals("landscape")) {
            landscapeMode.setSelected(true);
            this.selectedOrientation = "landscape";
        }
        JRadioButton freeMode = new JRadioButton(TLanguage.getString("TProjectDialog.FREE"));
        freeMode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TProjectDialog.this.selectedOrientation = "free";
            }
        });
        if (TEditor.get_android_orientation().equals("free")) {
            freeMode.setSelected(true);
            this.selectedOrientation = "free";
        }
        ButtonGroup orientationsButtonGroup = new ButtonGroup();
        orientationsButtonGroup.add(portraitMode);
        orientationsButtonGroup.add(landscapeMode);
        orientationsButtonGroup.add(freeMode);
        this.orientationPanel.add(portraitMode);
        this.orientationPanel.add(landscapeMode);
        this.orientationPanel.add(freeMode);
    }

    @Override
    protected boolean applyValues() {
        if (!this.currentProject.getInitialBoard().equals(this.initialBoardPanel.getInitialBoard())) {
            this.currentProject.setInitialBoard(this.initialBoardPanel.getInitialBoard());
        }
        if (TEditor.get_android_mode() && !TEditor.get_android_orientation().equals(this.selectedOrientation)) {
            TEditor.set_android_orientation(this.selectedOrientation);
            this.currentProject.setInitialBoard(this.initialBoardPanel.getInitialBoard());
        }
        return true;
    }
}

