/*
 * Decompiled with CFR 0.152.
 */
package tico.editor.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import tico.board.TBoardConstants;
import tico.board.components.TComponent;
import tico.components.TBackgroundSelectionPanel;
import tico.components.TBorderSelectionPanel;
import tico.configuration.TLanguage;
import tico.editor.TBoardContainer;
import tico.editor.TEditor;
import tico.editor.dialogs.TComponentDialog;

public class TPolygonDialog
extends TComponentDialog {
    private static String DEFAULT_TITLE = TLanguage.getString("TPolygonDialog.TITLE");
    private JTabbedPane tabbedPane;
    private JPanel componentPropertiesPanel;
    private TBorderSelectionPanel borderSelectionPanel;
    private TBackgroundSelectionPanel backgroundSelectionPanel;

    public TPolygonDialog(TBoardContainer boardContainer, TComponent polygon) {
        super(boardContainer, DEFAULT_TITLE, polygon);
    }

    @Override
    protected JPanel setComponentPane(TEditor editor) {
        JPanel componentPane = new JPanel();
        GridBagConstraints c2 = new GridBagConstraints();
        componentPane.setLayout(new GridBagLayout());
        this.createTabbedPane();
        c2.fill = 1;
        c2.insets = new Insets(5, 5, 5, 5);
        c2.gridx = 0;
        c2.gridy = 0;
        componentPane.add((Component)this.tabbedPane, c2);
        return componentPane;
    }

    private void createTabbedPane() {
        this.tabbedPane = new JTabbedPane();
        this.createComponentPropertiesPanel();
        this.tabbedPane.addTab(TLanguage.getString("TPolygonDialog.TAB_PROPERTIES"), this.componentPropertiesPanel);
    }

    private void createComponentPropertiesPanel() {
        this.componentPropertiesPanel = new JPanel();
        GridBagConstraints c2 = new GridBagConstraints();
        this.componentPropertiesPanel.setLayout(new GridBagLayout());
        this.createBorderSelectionPanel();
        this.createBackgroundSelectionPanel();
        c2.fill = 2;
        c2.insets = new Insets(5, 10, 0, 10);
        c2.gridx = 0;
        c2.gridy = 0;
        this.componentPropertiesPanel.add((Component)this.borderSelectionPanel, c2);
        c2.fill = 2;
        c2.insets = new Insets(5, 10, 10, 10);
        c2.gridx = 0;
        c2.gridy = 1;
        this.componentPropertiesPanel.add((Component)this.backgroundSelectionPanel, c2);
    }

    private void createBorderSelectionPanel() {
        Map map = this.getAttributeMap();
        this.borderSelectionPanel = new TBorderSelectionPanel();
        this.borderSelectionPanel.setBorderColor(TBoardConstants.getBorderColor(map));
        this.borderSelectionPanel.setBorderSize(Math.max(1, Math.round(TBoardConstants.getLineWidth(map))));
    }

    private void createBackgroundSelectionPanel() {
        Map map = this.getAttributeMap();
        this.backgroundSelectionPanel = new TBackgroundSelectionPanel();
        this.backgroundSelectionPanel.setBackgroundColor(TBoardConstants.getBackground(map));
        this.backgroundSelectionPanel.setGradientColor(TBoardConstants.getGradientColor(map));
    }

    @Override
    protected Map newComponentsAttributeMap() {
        Hashtable nested = new Hashtable();
        Hashtable attributeMap = new Hashtable();
        Vector<String> removalAttributes = new Vector<String>();
        Color color = this.borderSelectionPanel.getBorderColor();
        if (color != null) {
            TBoardConstants.setBorderColor(attributeMap, color);
        } else {
            removalAttributes.add("bordercolor");
        }
        TBoardConstants.setLineWidth(attributeMap, this.borderSelectionPanel.getBorderSize());
        Color background = this.backgroundSelectionPanel.getBackgroundColor();
        if (background != null) {
            TBoardConstants.setBackground(attributeMap, background);
        } else {
            removalAttributes.add("backgroundColor");
        }
        Color gradient = this.backgroundSelectionPanel.getGradientColor();
        if (gradient != null) {
            TBoardConstants.setGradientColor(attributeMap, gradient);
        } else {
            removalAttributes.add("gradientColor");
        }
        TBoardConstants.setRemoveAttributes(attributeMap, removalAttributes.toArray());
        nested.put(this.getComponent(), attributeMap);
        return nested;
    }
}

