/*
 * Decompiled with CFR 0.152.
 */
package tico.editor.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import tico.board.TBoardConstants;
import tico.board.components.TComponent;
import tico.components.TLineSelectionPanel;
import tico.configuration.TLanguage;
import tico.editor.TBoardContainer;
import tico.editor.TEditor;
import tico.editor.dialogs.TComponentDialog;

public class TLineDialog
extends TComponentDialog {
    private static String DEFAULT_TITLE = TLanguage.getString("TLineDialog.TITLE");
    private JTabbedPane tabbedPane;
    private JPanel componentPropertiesPanel;
    private TLineSelectionPanel lineSelectionPanel;

    public TLineDialog(TBoardContainer boardContainer, TComponent line) {
        super(boardContainer, DEFAULT_TITLE, line);
    }

    @Override
    protected JPanel setComponentPane(TEditor editor) {
        JPanel componentPane = new JPanel();
        GridBagConstraints c2 = new GridBagConstraints();
        componentPane.setLayout(new GridBagLayout());
        this.createTabbedPane();
        c2.fill = 1;
        c2.insets = new Insets(5, 5, 5, 5);
        c2.gridx = 0;
        c2.gridy = 0;
        componentPane.add((Component)this.tabbedPane, c2);
        return componentPane;
    }

    private void createTabbedPane() {
        this.tabbedPane = new JTabbedPane();
        this.createComponentPropertiesPanel();
        this.tabbedPane.addTab(TLanguage.getString("TLineDialog.TAB_PROPERTIES"), this.componentPropertiesPanel);
    }

    private void createComponentPropertiesPanel() {
        this.componentPropertiesPanel = new JPanel();
        GridBagConstraints c2 = new GridBagConstraints();
        this.componentPropertiesPanel.setLayout(new GridBagLayout());
        this.createLineSelectionPanel();
        c2.fill = 2;
        c2.insets = new Insets(5, 10, 10, 10);
        c2.gridx = 0;
        c2.gridy = 0;
        this.componentPropertiesPanel.add((Component)this.lineSelectionPanel, c2);
    }

    private void createLineSelectionPanel() {
        Map map = this.getAttributeMap();
        this.lineSelectionPanel = new TLineSelectionPanel();
        this.lineSelectionPanel.setLineColor(TBoardConstants.getBorderColor(map));
        this.lineSelectionPanel.setLineSize(Math.max(1, Math.round(TBoardConstants.getLineWidth(map))));
    }

    @Override
    protected Map newComponentsAttributeMap() {
        Hashtable nested = new Hashtable();
        Hashtable attributeMap = new Hashtable();
        Vector<String> removalAttributes = new Vector<String>();
        Color color = this.lineSelectionPanel.getLineColor();
        if (color != null) {
            TBoardConstants.setBorderColor(attributeMap, color);
        } else {
            removalAttributes.add("bordercolor");
        }
        TBoardConstants.setLineWidth(attributeMap, this.lineSelectionPanel.getLineSize());
        TBoardConstants.setRemoveAttributes(attributeMap, removalAttributes.toArray());
        nested.put(this.getComponent(), attributeMap);
        return nested;
    }
}

