/*
 * Decompiled with CFR 0.152.
 */
package tico.editor.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import tico.components.TButton;
import tico.components.TDialog;
import tico.configuration.TLanguage;
import tico.editor.TEditor;

public class TGridSizeOptionPane
extends TDialog {
    private static int default_rows = 2;
    private static int default_columns = 3;
    private JRadioButton size2x2RadioButton;
    private JRadioButton size3x3RadioButton;
    private JRadioButton size4x4RadioButton;
    private JRadioButton customRadioButton;
    private JSpinner rowsSpinner;
    private JSpinner columnsSpinner;
    private TButton acceptButton;

    public TGridSizeOptionPane(TEditor editor) {
        this(editor, default_rows, default_columns);
    }

    public TGridSizeOptionPane(TEditor editor, int rows, int columns) {
        super(editor, TLanguage.getString("TGridSizeOptionPane.TITLE"), true);
        this.createDimensionChooser();
        this.setDimension(rows, columns);
        this.setResizable(false);
        this.pack();
        this.setLocationRelativeTo(editor);
        this.setVisible(true);
    }

    private void createDimensionChooser() {
        JPanel definedChooserPanel = this.createDefinedChooser();
        JPanel customChooserPanel = this.createCustomChooser();
        JPanel buttonPanel = this.createButtonPanel();
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints c2 = new GridBagConstraints();
        c2.fill = 2;
        c2.insets = new Insets(10, 10, 5, 10);
        c2.gridx = 0;
        c2.gridy = 0;
        this.getContentPane().add((Component)definedChooserPanel, c2);
        c2.fill = 2;
        c2.insets = new Insets(0, 0, 0, 0);
        c2.gridx = 1;
        c2.gridy = 0;
        this.getContentPane().add((Component)customChooserPanel, c2);
        c2.fill = 2;
        c2.insets = new Insets(5, 10, 10, 10);
        c2.gridx = 0;
        c2.gridy = 1;
        c2.gridwidth = 2;
        this.getContentPane().add((Component)buttonPanel, c2);
    }

    private JPanel createDefinedChooser() {
        JPanel definedChooserPanel = new JPanel();
        ButtonGroup definedOptionsButtonGroup = new ButtonGroup();
        GridSizeActionListener listener = new GridSizeActionListener();
        this.size2x2RadioButton = new JRadioButton("2x2");
        this.size3x3RadioButton = new JRadioButton("3x3");
        this.size4x4RadioButton = new JRadioButton("4x4");
        this.customRadioButton = new JRadioButton("Custom");
        this.size2x2RadioButton.addActionListener(listener);
        this.size3x3RadioButton.addActionListener(listener);
        this.size4x4RadioButton.addActionListener(listener);
        this.customRadioButton.addActionListener(listener);
        definedOptionsButtonGroup.add(this.size2x2RadioButton);
        definedOptionsButtonGroup.add(this.size3x3RadioButton);
        definedOptionsButtonGroup.add(this.size4x4RadioButton);
        definedOptionsButtonGroup.add(this.customRadioButton);
        definedChooserPanel.setLayout(new GridLayout(4, 1));
        definedChooserPanel.add(this.size2x2RadioButton);
        definedChooserPanel.add(this.size3x3RadioButton);
        definedChooserPanel.add(this.size4x4RadioButton);
        definedChooserPanel.add(this.customRadioButton);
        return definedChooserPanel;
    }

    private JPanel createCustomChooser() {
        JPanel customChooserPanel = new JPanel();
        SpinnerNumberModel rowsSpinnerModel = new SpinnerNumberModel(default_rows, 1, 1000, 1);
        SpinnerNumberModel columnsSpinnerModel = new SpinnerNumberModel(default_columns, 1, 1000, 1);
        JLabel rowsLabel = new JLabel(TLanguage.getString("TGridSizeOptionPane.ROWS"));
        rowsLabel.setHorizontalAlignment(4);
        this.rowsSpinner = new JSpinner(rowsSpinnerModel);
        JLabel columnsLabel = new JLabel(TLanguage.getString("TGridSizeOptionPane.COLUMNS"));
        columnsLabel.setHorizontalAlignment(4);
        this.columnsSpinner = new JSpinner(columnsSpinnerModel);
        customChooserPanel.setLayout(new GridBagLayout());
        GridBagConstraints c2 = new GridBagConstraints();
        c2.fill = 2;
        c2.insets = new Insets(10, 10, 0, 0);
        c2.gridx = 0;
        c2.gridy = 0;
        customChooserPanel.add((Component)rowsLabel, c2);
        c2.fill = 2;
        c2.insets = new Insets(10, 5, 10, 10);
        c2.gridx = 1;
        c2.gridy = 0;
        customChooserPanel.add((Component)this.rowsSpinner, c2);
        c2.fill = 2;
        c2.insets = new Insets(5, 10, 10, 0);
        c2.gridx = 0;
        c2.gridy = 1;
        customChooserPanel.add((Component)columnsLabel, c2);
        c2.fill = 2;
        c2.insets = new Insets(5, 5, 10, 10);
        c2.gridx = 1;
        c2.gridy = 1;
        customChooserPanel.add((Component)this.columnsSpinner, c2);
        return customChooserPanel;
    }

    private JPanel createButtonPanel() {
        JPanel buttonPanel = new JPanel();
        this.acceptButton = new TButton(TLanguage.getString("TGridSizeOptionPane.BUTTON_ACCEPT"));
        this.acceptButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TGridSizeOptionPane.this.dispose();
            }
        });
        buttonPanel.add(this.acceptButton);
        return buttonPanel;
    }

    public Dimension getDimension() {
        if (this.size2x2RadioButton.isSelected()) {
            default_rows = 2;
            default_columns = 2;
            return new Dimension(2, 2);
        }
        if (this.size3x3RadioButton.isSelected()) {
            default_rows = 3;
            default_columns = 3;
            return new Dimension(3, 3);
        }
        if (this.size4x4RadioButton.isSelected()) {
            default_rows = 4;
            default_columns = 4;
            return new Dimension(4, 4);
        }
        default_rows = (Integer)this.rowsSpinner.getValue();
        default_columns = (Integer)this.columnsSpinner.getValue();
        return new Dimension(default_columns, default_rows);
    }

    private void setDimension(int rows, int columns) {
        this.rowsSpinner.setEnabled(false);
        this.columnsSpinner.setEnabled(false);
        if (rows == 2 && columns == 2) {
            this.size2x2RadioButton.setSelected(true);
        } else if (rows == 3 && columns == 3) {
            this.size3x3RadioButton.setSelected(true);
        } else if (rows == 4 && columns == 4) {
            this.size4x4RadioButton.setSelected(true);
        } else {
            this.customRadioButton.setSelected(true);
            this.rowsSpinner.getModel().setValue(new Integer(rows));
            this.columnsSpinner.getModel().setValue(new Integer(columns));
            this.rowsSpinner.setEnabled(true);
            this.columnsSpinner.setEnabled(true);
        }
    }

    private class GridSizeActionListener
    implements ActionListener {
        private GridSizeActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            if (TGridSizeOptionPane.this.customRadioButton.isSelected()) {
                TGridSizeOptionPane.this.rowsSpinner.setEnabled(true);
                TGridSizeOptionPane.this.columnsSpinner.setEnabled(true);
            } else {
                TGridSizeOptionPane.this.rowsSpinner.setEnabled(false);
                TGridSizeOptionPane.this.columnsSpinner.setEnabled(false);
            }
        }
    }
}

