/*
 * Decompiled with CFR 0.152.
 */
package tico.editor.dialogs;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.JPanel;
import org.jgraph.graph.AttributeMap;
import tico.board.TBoardConstants;
import tico.board.components.TComponent;
import tico.board.components.TGrid;
import tico.components.TAlternativeBorderSelectionPanel;
import tico.components.TGridOrderPanel;
import tico.configuration.TLanguage;
import tico.editor.TBoardContainer;
import tico.editor.dialogs.TCellDialog;

public class TGridCellDialog
extends TCellDialog {
    private static String DEFAULT_TITLE = TLanguage.getString("TGridCellDialog.TITLE");
    private JPanel gridPanel;
    private TGridOrderPanel orderSelectionPanel;
    private TAlternativeBorderSelectionPanel borderPanel;

    public TGridCellDialog(TBoardContainer boardContainer, TComponent gridCell) {
        super(boardContainer, DEFAULT_TITLE, gridCell);
    }

    private void createAnotherBorderSelectionPanel() {
        AttributeMap map = ((TGrid)this.getComponent().getParent()).getAttributes();
        this.borderPanel = new TAlternativeBorderSelectionPanel();
        this.borderPanel.setBorderColor(TBoardConstants.getChangeColorGrid(map));
        this.borderPanel.setBorderSize(Math.max(4, Math.round(TBoardConstants.getChangeLineWidthGrid(map))));
    }

    @Override
    protected void createIdField() {
        super.createIdField();
        this.idTextField.setText(this.getComponent().getId());
        AttributeMap map = this.getComponent().getAttributes();
    }

    @Override
    protected void createTabbedPane() {
        super.createTabbedPane();
    }

    private void createGridOrderPanel() {
        this.gridPanel = new JPanel();
        GridBagConstraints c2 = new GridBagConstraints();
        this.gridPanel.setLayout(new GridBagLayout());
        this.createOrderSelectionPanel();
        this.createAnotherBorderSelectionPanel();
        c2.fill = 2;
        c2.insets = new Insets(5, 10, 10, 10);
        c2.gridx = 0;
        c2.gridy = 0;
        this.gridPanel.add((Component)this.borderPanel, c2);
        c2.fill = 2;
        c2.insets = new Insets(5, 10, 10, 10);
        c2.gridx = 0;
        c2.gridy = 1;
        this.gridPanel.add((Component)this.orderSelectionPanel, c2);
    }

    private void createOrderSelectionPanel() {
        AttributeMap map = ((TGrid)this.getComponent().getParent()).getAttributes();
        this.orderSelectionPanel = new TGridOrderPanel(TBoardConstants.getOrder(map));
        this.orderSelectionPanel.setOrderedCellList(TBoardConstants.getOrderedCellList(map));
    }

    @Override
    protected Map newComponentsAttributeMap() {
        Map nested = super.newComponentsAttributeMap();
        Hashtable attributeMap = new Hashtable();
        return nested;
    }
}

