/*
 * Decompiled with CFR 0.152.
 */
package tico.editor.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.TitledBorder;
import tico.components.TLanguageComboBox;
import tico.configuration.TLanguage;
import tico.configuration.TSetup;
import tico.editor.TEditor;
import tico.editor.dialogs.TPropertiesDialog;

public class TEditorDialog
extends TPropertiesDialog {
    private JPanel languageChooserPanel;
    private TLanguageComboBox languageComboBox;

    public TEditorDialog(TEditor editor) {
        super(editor);
        this.setTitle(TLanguage.getString("TEditorDialog.TITLE"));
        this.createTabbedPane();
        this.setVisible(true);
    }

    private void createTabbedPane() {
        this.getPropertiesPane().setLayout(new GridBagLayout());
        GridBagConstraints c2 = new GridBagConstraints();
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab(TLanguage.getString("TEditorDialog.TAB_PREFERENCES"), this.createPreferencesPanel());
        c2.fill = 1;
        c2.insets = new Insets(0, 5, 5, 5);
        c2.gridx = 0;
        c2.gridy = 1;
        this.getPropertiesPane().add((Component)tabbedPane, c2);
    }

    private JPanel createPreferencesPanel() {
        JPanel preferencesPanel = new JPanel();
        GridBagConstraints c2 = new GridBagConstraints();
        preferencesPanel.setLayout(new GridBagLayout());
        this.createLanguageChooser();
        c2.fill = 2;
        c2.insets = new Insets(5, 10, 10, 10);
        c2.gridx = 0;
        c2.gridy = 0;
        preferencesPanel.add((Component)this.languageChooserPanel, c2);
        return preferencesPanel;
    }

    private void createLanguageChooser() {
        this.languageChooserPanel = new JPanel();
        this.languageChooserPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.WHITE, new Color(165, 163, 151)), TLanguage.getString("TEditorDialog.LANGUAGE")));
        JLabel languageLabel = new JLabel(TLanguage.getString("TEditorDialog.LANGUAGE"));
        this.languageComboBox = new TLanguageComboBox(TSetup.getLanguage());
        GridBagConstraints c2 = new GridBagConstraints();
        this.languageChooserPanel.setLayout(new GridBagLayout());
        c2.fill = 2;
        c2.insets = new Insets(5, 15, 10, 0);
        c2.gridx = 0;
        c2.gridy = 0;
        this.languageChooserPanel.add((Component)languageLabel, c2);
        c2.fill = 2;
        c2.insets = new Insets(5, 15, 10, 15);
        c2.gridx = 1;
        c2.gridy = 0;
        this.languageChooserPanel.add((Component)this.languageComboBox, c2);
    }

    @Override
    protected boolean applyValues() {
        if (!TSetup.getLanguage().equals(this.languageComboBox.getLanguage())) {
            TSetup.setLanguage(this.languageComboBox.getLanguage());
            String language = this.languageComboBox.getLanguage();
            String languageChangeAdvice = TLanguage.getString(language, "TEditorDialog.LANGUAGE_CHANGE_ADVICE");
            String languageChange = TLanguage.getString(language, "TEditorDialog.LANGUAGE_CHANGE");
            JOptionPane.showMessageDialog(null, languageChangeAdvice, languageChange, 1);
        }
        return true;
    }
}

