/*
 * Decompiled with CFR 0.152.
 */
package tico.editor.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.TitledBorder;
import tico.board.TBoardConstants;
import tico.board.components.TComponent;
import tico.components.TAlternativeSoundChooser;
import tico.components.TClickControllerCellActionsPanel;
import tico.components.TFontModelChooser;
import tico.components.TIdTextField;
import tico.components.TTextField;
import tico.configuration.TLanguage;
import tico.editor.TBoardContainer;
import tico.editor.TEditor;
import tico.editor.TFileHandler;
import tico.editor.dialogs.TComponentDialog;

public class TControllerCellDialog
extends TComponentDialog {
    private static String DEFAULT_TITLE = TLanguage.getString("TControllerCellDialog.TITLE");
    protected JTabbedPane tabbedPane;
    private JPanel textPropertiesPanel;
    private JPanel textFieldPanel;
    private TTextField textField;
    protected JPanel idFieldPanel;
    protected TIdTextField idTextField;
    private TFontModelChooser fontModel;
    private JPanel componentActionsPanel;
    private TClickControllerCellActionsPanel clickControllerCellActionPanel;
    private TAlternativeSoundChooser alternativeSoundChooser;
    private TEditor myEditor;
    private ImageIcon exitIcon;
    private ImageIcon undoIcon;
    private ImageIcon undoAllIcon;
    private ImageIcon readIcon;
    private ImageIcon returnIcon;
    private ImageIcon homeIcon;
    private ImageIcon stopIcon;
    private ImageIcon copyIcon;
    String exitFilePath;
    String undoFilePath;
    String undoAllFilePath;
    String readFilePath;
    String returnFilePath;
    String homeFilePath;
    String stopFilePath;
    String copyFilePath;

    public TControllerCellDialog(TBoardContainer boardContainer, TComponent cell) {
        this(boardContainer, DEFAULT_TITLE, cell);
        this.myEditor = boardContainer.getEditor();
    }

    public TControllerCellDialog(TBoardContainer boardContainer, String title, TComponent cell) {
        super(boardContainer, title, cell);
        this.myEditor = boardContainer.getEditor();
    }

    @Override
    protected JPanel setComponentPane(TEditor editor) {
        JPanel componentPane = new JPanel();
        this.myEditor = editor;
        GridBagConstraints c2 = new GridBagConstraints();
        componentPane.setLayout(new GridBagLayout());
        this.createTabbedPane();
        this.createIdField();
        c2.fill = 2;
        c2.insets = new Insets(5, 10, 0, 10);
        c2.gridx = 0;
        c2.gridy = 0;
        componentPane.add((Component)this.idFieldPanel, c2);
        c2.fill = 1;
        c2.insets = new Insets(0, 5, 5, 5);
        c2.gridx = 0;
        c2.gridy = 1;
        componentPane.add((Component)this.tabbedPane, c2);
        return componentPane;
    }

    protected void createIdField() {
        this.idFieldPanel = new JPanel();
        this.idFieldPanel.setLayout(new FlowLayout(2));
        this.idFieldPanel.add(new JLabel(TLanguage.getString("TControllerCellDialog.ID")));
        this.idTextField = new TIdTextField();
        this.idFieldPanel.add(this.idTextField);
        this.idTextField.setText(TBoardConstants.getId(this.getAttributeMap()));
    }

    protected void createTabbedPane() {
        this.tabbedPane = new JTabbedPane();
        this.createTextPropertiesPanel();
        this.createActionsPanel();
        this.tabbedPane.addTab(TLanguage.getString("TControllerCellDialog.TAB_TEXT"), this.textPropertiesPanel);
        this.tabbedPane.addTab(TLanguage.getString("TControllerCellDialog.TAB_ACTIONS"), this.componentActionsPanel);
    }

    private void createTextPropertiesPanel() {
        this.textPropertiesPanel = new JPanel();
        GridBagConstraints c2 = new GridBagConstraints();
        this.textPropertiesPanel.setLayout(new GridBagLayout());
        this.createTextField();
        this.createFontModel();
        c2.fill = 2;
        c2.insets = new Insets(5, 10, 0, 10);
        c2.gridx = 0;
        c2.gridy = 0;
        this.textPropertiesPanel.add((Component)this.textFieldPanel, c2);
        c2.fill = 2;
        c2.insets = new Insets(5, 10, 10, 10);
        c2.gridx = 0;
        c2.gridy = 1;
        this.textPropertiesPanel.add((Component)this.fontModel, c2);
    }

    private void createActionsPanel() {
        this.componentActionsPanel = new JPanel();
        GridBagConstraints c2 = new GridBagConstraints();
        this.componentActionsPanel.setLayout(new GridBagLayout());
        this.createAlternativeSoundChooser();
        ArrayList<String> controllerActionsList = new ArrayList<String>();
        controllerActionsList.add(TLanguage.getString("TInterpreterExitAction.NAME"));
        controllerActionsList.add(TLanguage.getString("TInterpreterUndoAction.NAME"));
        controllerActionsList.add(TLanguage.getString("TInterpreterUndoAllAction.NAME"));
        controllerActionsList.add(TLanguage.getString("TInterpreterReadAction.NAME"));
        controllerActionsList.add(TLanguage.getString("TInterpreterReturnAction.NAME"));
        controllerActionsList.add(TLanguage.getString("TInterpreterHomeAction.NAME"));
        controllerActionsList.add(TLanguage.getString("TInterpreterStopAction.NAME"));
        controllerActionsList.add(TLanguage.getString("TInterpreterCopyAction.NAME"));
        String currentDirectory = System.getProperty("user.dir");
        this.exitFilePath = String.valueOf(currentDirectory) + File.separator + "controller-icons" + File.separator + "controller-exit.png";
        this.undoFilePath = String.valueOf(currentDirectory) + File.separator + "controller-icons" + File.separator + "controller-undo.png";
        this.undoAllFilePath = String.valueOf(currentDirectory) + File.separator + "controller-icons" + File.separator + "controller-undo-all.png";
        this.readFilePath = String.valueOf(currentDirectory) + File.separator + "controller-icons" + File.separator + "controller-read.png";
        this.returnFilePath = String.valueOf(currentDirectory) + File.separator + "controller-icons" + File.separator + "controller-return.png";
        this.homeFilePath = String.valueOf(currentDirectory) + File.separator + "controller-icons" + File.separator + "controller-home.png";
        this.stopFilePath = String.valueOf(currentDirectory) + File.separator + "controller-icons" + File.separator + "controller-stop.png";
        this.copyFilePath = String.valueOf(currentDirectory) + File.separator + "controller-icons" + File.separator + "controller-copy.png";
        this.clickControllerCellActionPanel = new TClickControllerCellActionsPanel(controllerActionsList, this.textField);
        c2.fill = 2;
        c2.insets = new Insets(5, 10, 0, 10);
        c2.gridx = 0;
        c2.gridy = 0;
        this.componentActionsPanel.add((Component)this.clickControllerCellActionPanel, c2);
        c2.fill = 2;
        c2.insets = new Insets(5, 10, 0, 10);
        c2.gridx = 0;
        c2.gridy = 1;
        this.componentActionsPanel.add((Component)this.alternativeSoundChooser, c2);
    }

    private void createTextField() {
        Map map = this.getAttributeMap();
        this.textFieldPanel = new JPanel();
        this.textFieldPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.WHITE, new Color(165, 163, 151)), TLanguage.getString("TControllerCellDialog.TEXT_FILED")));
        int actionCode = TBoardConstants.getActionCode(map);
        this.textField = new TTextField(TBoardConstants.getText(map));
        if (this.textField.getText().equals("")) {
            this.textField = new TTextField(TLanguage.getString("TControllerCellDialog.TEXT_DEFAULT"));
        } else if (actionCode == 1) {
            this.textField = new TTextField(TLanguage.getString("TInterpreterExitAction.NAME"));
        } else if (actionCode == 2) {
            this.textField = new TTextField(TLanguage.getString("TInterpreterUndoAction.NAME"));
        } else if (actionCode == 3) {
            this.textField = new TTextField(TLanguage.getString("TInterpreterUndoAllAction.NAME"));
        } else if (actionCode == 4) {
            this.textField = new TTextField(TLanguage.getString("TInterpreterReadAction.NAME"));
        } else if (actionCode == 5) {
            this.textField = new TTextField(TLanguage.getString("TInterpreterReturnAction.NAME"));
        } else if (actionCode == 7) {
            this.textField = new TTextField(TLanguage.getString("TInterpreterHomeAction.NAME"));
        } else if (actionCode == 6) {
            this.textField = new TTextField(TLanguage.getString("TInterpreterStopAction.NAME"));
        } else if (actionCode == 8) {
            this.textField = new TTextField(TLanguage.getString("TInterpreterCopyAction.NAME"));
        }
        this.textField.setColumns(30);
        this.textField.setEditable(false);
        this.textFieldPanel.add(this.textField);
    }

    private void createFontModel() {
        Map map = this.getAttributeMap();
        this.fontModel = new TFontModelChooser(TBoardConstants.getFont(map).getName(), TBoardConstants.getForeground(map), TBoardConstants.getFont(map).getSize(), TBoardConstants.getFont(map).getStyle());
    }

    @Override
    protected Map newComponentsAttributeMap() {
        Hashtable nested = new Hashtable();
        Hashtable attributeMap = new Hashtable();
        Vector<String> removalAttributes = new Vector<String>();
        File f2 = null;
        TBoardConstants.setText(attributeMap, this.textField.getText());
        TBoardConstants.setForeground(attributeMap, this.fontModel.getFontColor());
        TBoardConstants.setFont(attributeMap, new Font(this.fontModel.getFontFace(), this.fontModel.getFontStyle(), this.fontModel.getFontSize()));
        TBoardConstants.setBackground(attributeMap, TBoardConstants.DEFAULT_BACKGROUND);
        if (this.textField.getText().equals(TLanguage.getString("TInterpreterExitAction.NAME"))) {
            try {
                f2 = TFileHandler.importFile(this.exitFilePath);
                this.exitIcon = new ImageIcon(f2.getAbsolutePath());
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            TBoardConstants.setIcon(attributeMap, this.exitIcon);
            TBoardConstants.setActionCode(attributeMap, 1);
        } else if (this.textField.getText().equals(TLanguage.getString("TInterpreterUndoAction.NAME"))) {
            try {
                f2 = TFileHandler.importFile(this.undoFilePath);
                this.undoIcon = new ImageIcon(f2.getAbsolutePath());
            }
            catch (IOException e3) {
                e3.printStackTrace();
            }
            TBoardConstants.setIcon(attributeMap, this.undoIcon);
            TBoardConstants.setActionCode(attributeMap, 2);
        } else if (this.textField.getText().equals(TLanguage.getString("TInterpreterUndoAllAction.NAME"))) {
            try {
                f2 = TFileHandler.importFile(this.undoAllFilePath);
                this.undoAllIcon = new ImageIcon(f2.getAbsolutePath());
            }
            catch (IOException e4) {
                e4.printStackTrace();
            }
            TBoardConstants.setIcon(attributeMap, this.undoAllIcon);
            TBoardConstants.setActionCode(attributeMap, 3);
        } else if (this.textField.getText().equals(TLanguage.getString("TInterpreterReadAction.NAME"))) {
            try {
                f2 = TFileHandler.importFile(this.readFilePath);
                this.readIcon = new ImageIcon(f2.getAbsolutePath());
            }
            catch (IOException e5) {
                e5.printStackTrace();
            }
            TBoardConstants.setIcon(attributeMap, this.readIcon);
            TBoardConstants.setActionCode(attributeMap, 4);
        } else if (this.textField.getText().equals(TLanguage.getString("TInterpreterReturnAction.NAME"))) {
            try {
                f2 = TFileHandler.importFile(this.returnFilePath);
                this.returnIcon = new ImageIcon(f2.getAbsolutePath());
            }
            catch (IOException e6) {
                e6.printStackTrace();
            }
            TBoardConstants.setIcon(attributeMap, this.returnIcon);
            TBoardConstants.setActionCode(attributeMap, 5);
        } else if (this.textField.getText().equals(TLanguage.getString("TInterpreterHomeAction.NAME"))) {
            try {
                f2 = TFileHandler.importFile(this.homeFilePath);
                this.homeIcon = new ImageIcon(f2.getAbsolutePath());
            }
            catch (IOException e7) {
                e7.printStackTrace();
            }
            TBoardConstants.setIcon(attributeMap, this.homeIcon);
            TBoardConstants.setActionCode(attributeMap, 7);
        } else if (this.textField.getText().equals(TLanguage.getString("TInterpreterStopAction.NAME"))) {
            try {
                f2 = TFileHandler.importFile(this.stopFilePath);
                this.stopIcon = new ImageIcon(f2.getAbsolutePath());
            }
            catch (IOException e8) {
                e8.printStackTrace();
            }
            TBoardConstants.setIcon(attributeMap, this.stopIcon);
            TBoardConstants.setActionCode(attributeMap, 6);
        } else if (this.textField.getText().equals(TLanguage.getString("TInterpreterCopyAction.NAME"))) {
            try {
                f2 = TFileHandler.importFile(this.copyFilePath);
                this.copyIcon = new ImageIcon(f2.getAbsolutePath());
            }
            catch (IOException e9) {
                e9.printStackTrace();
            }
            TBoardConstants.setIcon(attributeMap, this.copyIcon);
            TBoardConstants.setActionCode(attributeMap, 8);
        } else {
            try {
                f2 = TFileHandler.importFile(this.exitFilePath);
                this.exitIcon = new ImageIcon(f2.getAbsolutePath());
            }
            catch (IOException e10) {
                e10.printStackTrace();
            }
            TBoardConstants.setIcon(attributeMap, this.exitIcon);
        }
        TBoardConstants.setVerticalTextPosition(attributeMap, 3);
        TBoardConstants.setRemoveAttributes(attributeMap, removalAttributes.toArray());
        TBoardConstants.setId(attributeMap, this.idTextField.getText());
        String alternativeSoundFile = this.alternativeSoundChooser.getSoundFilePath();
        if (alternativeSoundFile != null) {
            TBoardConstants.setAlternativeSoundFile(attributeMap, alternativeSoundFile);
        } else {
            removalAttributes.add("soundFile");
        }
        nested.put(this.getComponent(), attributeMap);
        return nested;
    }

    private void createAlternativeSoundChooser() {
        Map map = this.getAttributeMap();
        this.alternativeSoundChooser = new TAlternativeSoundChooser();
        this.alternativeSoundChooser.setSoundFilePath(TBoardConstants.getAlternativeSoundFile(map));
    }
}

