/*
 * Decompiled with CFR 0.152.
 */
package tico.editor.dialogs;

import tico.board.components.TCell;
import tico.board.components.TComponent;
import tico.board.components.TControllerCell;
import tico.board.components.TGridCell;
import tico.board.components.TLabel;
import tico.board.components.TLine;
import tico.board.components.TOval;
import tico.board.components.TRectangle;
import tico.board.components.TRoundRect;
import tico.board.components.TTextArea;
import tico.editor.TBoardContainer;
import tico.editor.dialogs.TCellDialog;
import tico.editor.dialogs.TControllerCellDialog;
import tico.editor.dialogs.TGridCellDialog;
import tico.editor.dialogs.TLabelDialog;
import tico.editor.dialogs.TLineDialog;
import tico.editor.dialogs.TPolygonDialog;
import tico.editor.dialogs.TTextAreaDialog;

public class TComponentDialogFactory {
    private TBoardContainer boardContainer;

    public TComponentDialogFactory(TBoardContainer boardContainer) {
        this.boardContainer = boardContainer;
    }

    public void createComponentDialog(TComponent component) {
        if (component instanceof TCell) {
            new TCellDialog(this.boardContainer, component);
        }
        if (component instanceof TControllerCell) {
            new TControllerCellDialog(this.boardContainer, component);
        }
        if (component instanceof TGridCell) {
            new TGridCellDialog(this.boardContainer, component);
        }
        if (component instanceof TTextArea) {
            new TTextAreaDialog(this.boardContainer, component);
        }
        if (component instanceof TLabel) {
            new TLabelDialog(this.boardContainer, component);
        }
        if (component instanceof TRectangle) {
            new TPolygonDialog(this.boardContainer, component);
        }
        if (component instanceof TRoundRect) {
            new TPolygonDialog(this.boardContainer, component);
        }
        if (component instanceof TOval) {
            new TPolygonDialog(this.boardContainer, component);
        }
        if (component instanceof TLine) {
            new TLineDialog(this.boardContainer, component);
        }
    }
}

