/*
 * Decompiled with CFR 0.152.
 */
package tico.editor.dialogs;

import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import tico.board.TBoardConstants;
import tico.board.TBoardModel;
import tico.board.components.TComponent;
import tico.configuration.TLanguage;
import tico.editor.TBoardContainer;
import tico.editor.TEditor;
import tico.editor.dialogs.TPropertiesDialog;

public abstract class TComponentDialog
extends TPropertiesDialog {
    private TComponent component;
    private boolean firstEdit = true;

    public TComponentDialog(TBoardContainer boardContainer, String title, TComponent component) {
        super(boardContainer.getEditor());
        this.component = component;
        this.setTitle(title);
        this.getPropertiesPane().add(this.setComponentPane(boardContainer.getEditor()));
        this.setVisible(true);
    }

    @Override
    protected boolean applyValues() {
        if (!this.firstEdit) {
            this.getBoardContainer().getUndoManager().undo();
        }
        Map nested = this.newComponentsAttributeMap();
        for (Map.Entry entry : nested.entrySet()) {
            TComponent component = (TComponent)entry.getKey();
            Map attributeMap = (Map)entry.getValue();
            String newId = TBoardConstants.getId(attributeMap);
            if (newId == null) continue;
            if (newId.equals("")) {
                JOptionPane.showMessageDialog(null, TLanguage.getString("TComponentDialog.ERROR_EMPTY_ID"), String.valueOf(TLanguage.getString("WARNING")) + "!", 2);
                return false;
            }
            if (!((TBoardModel)this.getBoard().getGraphLayoutCache().getModel()).isRepeatedId(component, newId)) continue;
            JOptionPane.showMessageDialog(null, TLanguage.getString("TComponentDialog.ERROR_REPEATED_ID"), String.valueOf(TLanguage.getString("WARNING")) + "!", 2);
            return false;
        }
        this.getBoard().getGraphLayoutCache().edit(nested);
        this.firstEdit = false;
        return true;
    }

    protected TComponent getComponent() {
        return this.component;
    }

    protected Map getAttributeMap() {
        return this.getComponent().getAttributes();
    }

    protected abstract JPanel setComponentPane(TEditor var1);

    protected abstract Map newComponentsAttributeMap();
}

