/*
 * Decompiled with CFR 0.152.
 */
package tico.editor.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import tico.board.TBoard;
import tico.board.TBoardConstants;
import tico.board.components.TComponent;
import tico.components.TAlternativeBorderSelectionPanel;
import tico.components.TAlternativeSoundChooser;
import tico.components.TBackgroundSelectionPanel;
import tico.components.TBorderSelectionPanel;
import tico.components.TClickCellActionsPanel;
import tico.components.TFontModelChooser;
import tico.components.TIdTextField;
import tico.components.TImageChooser;
import tico.components.TSendTextChooser;
import tico.components.TSoundChooser;
import tico.components.TSynthesizerConfig;
import tico.components.TTextField;
import tico.components.TVideoChooser;
import tico.configuration.TLanguage;
import tico.editor.TBoardContainer;
import tico.editor.TEditor;
import tico.editor.dialogs.TComponentDialog;
import tico.environment.TEnvironment;

public class TCellDialog
extends TComponentDialog {
    private static String DEFAULT_TITLE = TLanguage.getString("TCellDialog.TITLE");
    protected JTabbedPane tabbedPane;
    private JPanel textPropertiesPanel;
    private JPanel textFieldPanel;
    private TTextField textField;
    protected JPanel idFieldPanel;
    protected TIdTextField idTextField;
    private TFontModelChooser fontModel;
    private JPanel componentPropertiesPanel;
    private JPanel componentMultimediaPanel;
    private TBorderSelectionPanel borderSelectionPanel;
    private TAlternativeBorderSelectionPanel alternativeBorderSelectionPanel;
    private TBackgroundSelectionPanel backgroundSelectionPanel;
    private TImageChooser iconChooser;
    private TImageChooser alternativeIconChooser;
    private JPanel componentActionsPanel;
    private TClickCellActionsPanel clickCellActionPanel;
    private TSoundChooser soundChooser;
    private TAlternativeSoundChooser alternativeSoundChooser;
    private TSendTextChooser sendTextChooser;
    private TVideoChooser videoChooser;
    private JPanel environmentPanel;
    private JScrollPane listScroll;
    private JList orderList;
    private TEditor myEditor;
    private TSynthesizerConfig synthesizerPanel;

    public TCellDialog(TBoardContainer boardContainer, TComponent cell) {
        this(boardContainer, DEFAULT_TITLE, cell);
        this.myEditor = boardContainer.getEditor();
    }

    public TCellDialog(TBoardContainer boardContainer, String title, TComponent cell) {
        super(boardContainer, title, cell);
        this.myEditor = boardContainer.getEditor();
    }

    @Override
    protected JPanel setComponentPane(TEditor editor) {
        JPanel componentPane = new JPanel();
        this.myEditor = editor;
        GridBagConstraints c2 = new GridBagConstraints();
        componentPane.setLayout(new GridBagLayout());
        this.createTabbedPane();
        this.createIdField();
        c2.fill = 2;
        c2.insets = new Insets(5, 10, 0, 10);
        c2.gridx = 0;
        c2.gridy = 0;
        componentPane.add((Component)this.idFieldPanel, c2);
        c2.fill = 1;
        c2.insets = new Insets(0, 5, 5, 5);
        c2.gridx = 0;
        c2.gridy = 1;
        componentPane.add((Component)this.tabbedPane, c2);
        return componentPane;
    }

    protected void createIdField() {
        this.idFieldPanel = new JPanel();
        this.idFieldPanel.setLayout(new FlowLayout(2));
        this.idFieldPanel.add(new JLabel(TLanguage.getString("TCellDialog.ID")));
        this.idTextField = new TIdTextField();
        this.idFieldPanel.add(this.idTextField);
        this.idTextField.setText(TBoardConstants.getId(this.getAttributeMap()));
    }

    protected void createTabbedPane() {
        this.tabbedPane = new JTabbedPane();
        this.createTextPropertiesPanel();
        this.createComponentPropertiesPanel();
        this.createComponentMultimediaPanel();
        this.createActionsPanel();
        this.createEnvironmentPanel();
        this.tabbedPane.addTab(TLanguage.getString("TCellDialog.TAB_TEXT"), this.textPropertiesPanel);
        this.tabbedPane.addTab(TLanguage.getString("TCellDialog.TAB_PROPERTIES"), this.componentPropertiesPanel);
        this.tabbedPane.addTab(TLanguage.getString("TCellDialog.TAB_MULTIMEDIA"), this.componentMultimediaPanel);
        this.tabbedPane.addTab(TLanguage.getString("TCellDialog.TAB_ACTIONS"), this.componentActionsPanel);
        this.tabbedPane.addTab(TLanguage.getString("TCellDialog.ENVIRONMENT"), this.environmentPanel);
    }

    public void createEnvironmentPanel() {
        this.environmentPanel = new JPanel();
        GridBagConstraints c2 = new GridBagConstraints();
        this.environmentPanel.setLayout(new GridBagLayout());
        this.createOrderList();
        c2.fill = 2;
        c2.insets = new Insets(5, 10, 0, 10);
        c2.gridx = 0;
        c2.gridy = 0;
        this.environmentPanel.add((Component)this.listScroll, c2);
    }

    private void createOrderList() {
        Map map = this.getAttributeMap();
        this.listScroll = new JScrollPane();
        this.listScroll.setPreferredSize(new Dimension(300, 300));
        this.listScroll.setVerticalScrollBarPolicy(20);
        this.listScroll.setHorizontalScrollBarPolicy(30);
        Vector environmentAction = TEnvironment.getAllKeys();
        this.orderList = new JList(environmentAction);
        this.orderList.setSelectionMode(0);
        this.orderList.setMinimumSize(new Dimension(300, 500));
        this.orderList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent arg0) {
                TCellDialog.this.orderList.repaint();
            }
        });
        int position = TBoardConstants.getPositionAction(map);
        int tam = environmentAction.size();
        if (position != -1 && position < tam) {
            this.orderList.setSelectedIndex(position);
        }
        this.listScroll.setViewportView(this.orderList);
    }

    private void createTextPropertiesPanel() {
        this.textPropertiesPanel = new JPanel();
        GridBagConstraints c2 = new GridBagConstraints();
        this.textPropertiesPanel.setLayout(new GridBagLayout());
        this.createTextField();
        this.createFontModel();
        c2.fill = 2;
        c2.insets = new Insets(5, 10, 0, 10);
        c2.gridx = 0;
        c2.gridy = 0;
        this.textPropertiesPanel.add((Component)this.textFieldPanel, c2);
        c2.fill = 2;
        c2.insets = new Insets(5, 10, 10, 10);
        c2.gridx = 0;
        c2.gridy = 1;
        this.textPropertiesPanel.add((Component)this.fontModel, c2);
    }

    private void createComponentPropertiesPanel() {
        this.componentPropertiesPanel = new JPanel();
        GridBagConstraints c2 = new GridBagConstraints();
        this.componentPropertiesPanel.setLayout(new GridBagLayout());
        this.createAlternativeBorderSelectionPanel();
        this.createBorderSelectionPanel();
        this.createBackgroundSelectionPanel();
        this.createIconChooser();
        c2.fill = 2;
        c2.insets = new Insets(5, 10, 0, 10);
        c2.gridx = 0;
        c2.gridy = 0;
        this.componentPropertiesPanel.add((Component)this.borderSelectionPanel, c2);
        c2.fill = 2;
        c2.insets = new Insets(5, 10, 0, 10);
        c2.gridx = 0;
        c2.gridy = 1;
        this.componentPropertiesPanel.add((Component)this.alternativeBorderSelectionPanel, c2);
        c2.fill = 2;
        c2.insets = new Insets(5, 10, 0, 10);
        c2.gridx = 0;
        c2.gridy = 2;
        this.componentPropertiesPanel.add((Component)this.backgroundSelectionPanel, c2);
        c2.fill = 2;
        c2.insets = new Insets(5, 10, 10, 10);
        c2.gridx = 0;
        c2.gridy = 3;
        this.componentPropertiesPanel.add((Component)this.iconChooser, c2);
    }

    private void createActionsPanel() {
        this.componentActionsPanel = new JPanel();
        GridBagConstraints c2 = new GridBagConstraints();
        this.componentActionsPanel.setLayout(new GridBagLayout());
        this.createFollowingBoardPanel();
        this.createAlterntativeIconChooser();
        this.createSinthesizerConfig();
        this.createSendTextChooser();
        this.sendTextChooser.setEnabled(false);
        c2.fill = 2;
        c2.insets = new Insets(0, 10, 0, 10);
        c2.gridx = 0;
        c2.gridy = 0;
        this.componentActionsPanel.add((Component)this.clickCellActionPanel, c2);
        c2.fill = 2;
        c2.insets = new Insets(0, 10, 0, 10);
        c2.gridx = 0;
        c2.gridy = 1;
        this.componentActionsPanel.add((Component)this.alternativeIconChooser, c2);
        c2.fill = 2;
        c2.insets = new Insets(0, 10, 0, 10);
        c2.gridx = 0;
        c2.gridy = 3;
        this.componentActionsPanel.add((Component)this.sendTextChooser, c2);
        c2.fill = 2;
        c2.insets = new Insets(0, 10, 0, 10);
        c2.gridx = 0;
        c2.gridy = 6;
        this.componentActionsPanel.add((Component)this.synthesizerPanel, c2);
    }

    private void createComponentMultimediaPanel() {
        this.componentMultimediaPanel = new JPanel();
        GridBagConstraints c2 = new GridBagConstraints();
        this.componentMultimediaPanel.setLayout(new GridBagLayout());
        this.createSoundChooser();
        this.createAlternativeSoundChooser();
        this.createVideoChooser();
        c2.fill = 2;
        c2.insets = new Insets(0, 10, 0, 10);
        c2.gridx = 0;
        c2.gridy = 0;
        this.componentMultimediaPanel.add((Component)this.soundChooser, c2);
        c2.fill = 2;
        c2.insets = new Insets(0, 10, 0, 10);
        c2.gridx = 0;
        c2.gridy = 1;
        this.componentMultimediaPanel.add((Component)this.alternativeSoundChooser, c2);
        c2.fill = 2;
        c2.insets = new Insets(0, 10, 0, 10);
        c2.gridx = 0;
        c2.gridy = 3;
        this.componentMultimediaPanel.add((Component)this.videoChooser, c2);
    }

    private void createTextField() {
        Map map = this.getAttributeMap();
        this.textFieldPanel = new JPanel();
        this.textFieldPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.WHITE, new Color(165, 163, 151)), TLanguage.getString("TCellDialog.TEXT_FILED")));
        this.textField = new TTextField(TBoardConstants.getText(map));
        this.textField.setColumns(30);
        this.textFieldPanel.add(this.textField);
    }

    private void createFontModel() {
        Map map = this.getAttributeMap();
        this.fontModel = new TFontModelChooser(TBoardConstants.getFont(map).getName(), TBoardConstants.getForeground(map), TBoardConstants.getFont(map).getSize(), TBoardConstants.getFont(map).getStyle());
    }

    private void createBorderSelectionPanel() {
        Map map = this.getAttributeMap();
        this.borderSelectionPanel = new TBorderSelectionPanel();
        this.borderSelectionPanel.setBorderColor(TBoardConstants.getBorderColor(map));
        this.borderSelectionPanel.setBorderSize(Math.max(1, Math.round(TBoardConstants.getLineWidth(map))));
    }

    private void createAlternativeBorderSelectionPanel() {
        Map map = this.getAttributeMap();
        this.alternativeBorderSelectionPanel = new TAlternativeBorderSelectionPanel();
        this.alternativeBorderSelectionPanel.setBorderColor(TBoardConstants.getAlternativeBorderColor(map));
        this.alternativeBorderSelectionPanel.setBorderSize(Math.max(1, Math.round(TBoardConstants.getAlternativeLinewidth(map))));
    }

    private void createBackgroundSelectionPanel() {
        Map map = this.getAttributeMap();
        this.backgroundSelectionPanel = new TBackgroundSelectionPanel();
        this.backgroundSelectionPanel.setBackgroundColor(TBoardConstants.getBackground(map));
        this.backgroundSelectionPanel.setGradientColor(TBoardConstants.getGradientColor(map));
    }

    private void createIconChooser() {
        Map map = this.getAttributeMap();
        this.iconChooser = new TImageChooser(1, this.myEditor);
        this.iconChooser.setIcon((ImageIcon)TBoardConstants.getIcon(map));
        this.iconChooser.setVerticalTextPosition(TBoardConstants.getVerticalTextPosition(map));
    }

    private void createAlterntativeIconChooser() {
        Map map = this.getAttributeMap();
        this.alternativeIconChooser = new TImageChooser(TLanguage.getString("TCellDialog.ALTERNATIVE_IMAGE"), this.myEditor);
        this.alternativeIconChooser.setIcon((ImageIcon)TBoardConstants.getAlternativeIcon(map));
    }

    private void createFollowingBoardPanel() {
        Map map = this.getAttributeMap();
        ArrayList boardList = (ArrayList)this.getBoardContainer().getEditor().getProject().getBoardList().clone();
        ArrayList<String> boardListName = new ArrayList<String>();
        int i2 = 0;
        while (i2 < boardList.size()) {
            boardListName.add(((TBoard)boardList.get(i2)).getBoardName());
            ++i2;
        }
        boardListName.remove(this.getBoard().getBoardName());
        this.clickCellActionPanel = new TClickCellActionsPanel(boardListName);
        this.clickCellActionPanel.setFollowingBoard(TBoardConstants.getFollowingBoardName(map));
        this.clickCellActionPanel.setAccumulated(TBoardConstants.isAccumulated(map));
    }

    private void createSinthesizerConfig() {
        Map map = this.getAttributeMap();
        this.synthesizerPanel = new TSynthesizerConfig(false);
        String synthMode = TBoardConstants.getSynthMode(map);
        if (synthMode != null) {
            this.synthesizerPanel.setMode(Integer.parseInt(synthMode));
        } else {
            this.synthesizerPanel.setMode(0);
        }
        this.synthesizerPanel.setTexto(TBoardConstants.getVoiceText(map));
        this.synthesizerPanel.setCopyFrom(this.textField);
    }

    private void createSoundChooser() {
        Map map = this.getAttributeMap();
        this.soundChooser = new TSoundChooser();
        this.soundChooser.setSoundFilePath(TBoardConstants.getSoundFile(map));
    }

    private void createAlternativeSoundChooser() {
        Map map = this.getAttributeMap();
        this.alternativeSoundChooser = new TAlternativeSoundChooser();
        this.alternativeSoundChooser.setSoundFilePath(TBoardConstants.getAlternativeSoundFile(map));
    }

    private void createVideoChooser() {
        Map map = this.getAttributeMap();
        this.videoChooser = new TVideoChooser();
        this.videoChooser.setVideoFilePath(TBoardConstants.getVideoFile(map));
        this.videoChooser.setVideoFileURL(TBoardConstants.getVideoURL(map));
    }

    private void createSendTextChooser() {
        Map map = this.getAttributeMap();
        this.sendTextChooser = new TSendTextChooser(this.getBoard());
        this.sendTextChooser.setText(TBoardConstants.getSendText(map));
        this.sendTextChooser.setTextReceiver(TBoardConstants.getSendTextTarget(map));
        this.sendTextChooser.setTimer(TBoardConstants.getSendTextTimer(map));
    }

    @Override
    protected Map newComponentsAttributeMap() {
        Hashtable nested = new Hashtable();
        Hashtable attributeMap = new Hashtable();
        Vector<String> removalAttributes = new Vector<String>();
        TBoardConstants.setText(attributeMap, this.textField.getText());
        TBoardConstants.setForeground(attributeMap, this.fontModel.getFontColor());
        TBoardConstants.setFont(attributeMap, new Font(this.fontModel.getFontFace(), this.fontModel.getFontStyle(), this.fontModel.getFontSize()));
        Color color = this.borderSelectionPanel.getBorderColor();
        if (color != null) {
            TBoardConstants.setBorderColor(attributeMap, color);
        } else {
            removalAttributes.add("bordercolor");
        }
        Color alternativeBorderColor = this.alternativeBorderSelectionPanel.getBorderColor();
        if (alternativeBorderColor != null) {
            TBoardConstants.setAlternativeBorderColor(attributeMap, alternativeBorderColor);
        } else {
            removalAttributes.add("alternativeBorderColor");
        }
        TBoardConstants.setLineWidth(attributeMap, this.borderSelectionPanel.getBorderSize());
        int alternativeBorderLinewidth = this.alternativeBorderSelectionPanel.getBorderSize();
        TBoardConstants.setAlternativeLinewidth(attributeMap, alternativeBorderLinewidth);
        Color background = this.backgroundSelectionPanel.getBackgroundColor();
        if (background != null) {
            TBoardConstants.setBackground(attributeMap, background);
        } else {
            removalAttributes.add("backgroundColor");
        }
        Color gradient = this.backgroundSelectionPanel.getGradientColor();
        if (gradient != null) {
            TBoardConstants.setGradientColor(attributeMap, gradient);
        } else {
            removalAttributes.add("gradientColor");
        }
        ImageIcon icon = this.iconChooser.getIcon();
        if (icon != null) {
            TBoardConstants.setIcon(attributeMap, icon);
        } else {
            removalAttributes.add("icon");
        }
        TBoardConstants.setVerticalTextPosition(attributeMap, this.iconChooser.getVerticalTextPosition());
        ImageIcon alternativeIcon = this.alternativeIconChooser.getIcon();
        if (alternativeIcon != null) {
            TBoardConstants.setAlternativeIcon(attributeMap, alternativeIcon);
        } else {
            removalAttributes.add("alternativeIcon");
        }
        String soundFile = this.soundChooser.getSoundFilePath();
        if (soundFile != null) {
            TBoardConstants.setSoundFile(attributeMap, soundFile);
        } else {
            removalAttributes.add("soundFile");
        }
        String alternativeSoundFile = this.alternativeSoundChooser.getSoundFilePath();
        if (alternativeSoundFile != null) {
            TBoardConstants.setAlternativeSoundFile(attributeMap, alternativeSoundFile);
        } else {
            removalAttributes.add("alternativeSoundFile");
        }
        String voiceName = this.synthesizerPanel.getNombreVoz();
        if (!voiceName.equals("")) {
            TBoardConstants.setVoiceName(attributeMap, voiceName);
        } else {
            removalAttributes.add("voiceName");
        }
        String voiceText = this.synthesizerPanel.getTexto();
        if (voiceText != null) {
            TBoardConstants.setVoiceText(attributeMap, voiceText);
        } else {
            removalAttributes.add("voiceText");
        }
        int mode = this.synthesizerPanel.getMode();
        TBoardConstants.setSynthMode(attributeMap, String.valueOf(mode));
        String videoFile = this.videoChooser.getVideoFilePath();
        if (videoFile != null) {
            TBoardConstants.setVideoFile(attributeMap, videoFile);
        } else {
            removalAttributes.add("videoFile");
        }
        String videoURL = this.videoChooser.getVideoFileURL();
        if (videoURL != null) {
            TBoardConstants.setVideoURL(attributeMap, videoURL);
        } else {
            removalAttributes.add("videoURL");
        }
        Object action = this.orderList.getSelectedValue();
        if (action != null && !action.toString().trim().equals("")) {
            int pos = this.orderList.getSelectedIndex();
            TBoardConstants.setEnvironmentAction(attributeMap, TEnvironment.getCode(action.toString()));
            TBoardConstants.setPositionAction(attributeMap, pos);
        } else {
            removalAttributes.add("environmentAction");
            removalAttributes.add("actionPosition");
        }
        TComponent component = this.sendTextChooser.getTextReceiver();
        if (component != null) {
            TBoardConstants.setSendTextTarget(attributeMap, component);
            TBoardConstants.setSendText(attributeMap, this.sendTextChooser.getText());
            TBoardConstants.setSendTextTimer(attributeMap, this.sendTextChooser.getTimer());
        } else {
            removalAttributes.add("sendTextTarget");
            removalAttributes.add("sendText");
            removalAttributes.add("sendTextTimer");
        }
        TBoardConstants.setAccumulated(attributeMap, this.clickCellActionPanel.getAccumulated());
        String followingBoard = this.clickCellActionPanel.getFollowingBoard();
        if (followingBoard != null) {
            TBoardConstants.setFollowingBoard(attributeMap, followingBoard);
        } else {
            removalAttributes.add("followingBoard");
        }
        TBoardConstants.setRemoveAttributes(attributeMap, removalAttributes.toArray());
        TBoardConstants.setId(attributeMap, this.idTextField.getText());
        nested.put(this.getComponent(), attributeMap);
        return nested;
    }
}

