/*
 * Decompiled with CFR 0.152.
 */
package tico.editor.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellView;
import tico.board.TBoardConstants;
import tico.board.TBoardModel;
import tico.board.components.TCell;
import tico.board.componentview.TCellView;
import tico.board.componentview.TComponentView;
import tico.components.TBackgroundSelectionPanel;
import tico.components.TBoardOrderPanel;
import tico.components.TIdTextField;
import tico.components.TImageChooser;
import tico.components.TSizeChooser;
import tico.components.TSoundChooser;
import tico.configuration.TLanguage;
import tico.editor.TBoardContainer;
import tico.editor.TEditor;
import tico.editor.dialogs.TPropertiesDialog;

public class TBoardDialog
extends TPropertiesDialog {
    private JPanel nameFieldPanel;
    protected TIdTextField nameTextField;
    private TBackgroundSelectionPanel backgroundSelectionPanel;
    private TBoardOrderPanel boardOrderPanel;
    private TSizeChooser sizeChooser;
    private TImageChooser iconChooser;
    private TSoundChooser soundChooser;
    private TEditor myEditor;
    private boolean firstEdit = true;

    public TBoardDialog(TBoardContainer boardContainer) {
        super(boardContainer.getEditor());
        this.myEditor = boardContainer.getEditor();
        this.setTitle(TLanguage.getString("TBoardDialog.TITLE"));
        this.createTabbedPane();
        this.setVisible(true);
    }

    private void createTabbedPane() {
        this.getPropertiesPane().setLayout(new GridBagLayout());
        GridBagConstraints c2 = new GridBagConstraints();
        this.createNameField();
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab(TLanguage.getString("TBoardDialog.TAB_PROPERTIES"), this.createPropertiesPanel());
        tabbedPane.addTab(TLanguage.getString("TBoardDialog.TAB_BROWSE_ORDER"), this.createOrderPanel());
        c2.fill = 2;
        c2.insets = new Insets(5, 10, 0, 10);
        c2.gridx = 0;
        c2.gridy = 0;
        this.getPropertiesPane().add((Component)this.nameFieldPanel, c2);
        c2.fill = 1;
        c2.insets = new Insets(0, 5, 5, 5);
        c2.gridx = 0;
        c2.gridy = 1;
        this.getPropertiesPane().add((Component)tabbedPane, c2);
    }

    private void createNameField() {
        this.nameFieldPanel = new JPanel();
        this.nameFieldPanel.setLayout(new FlowLayout(2));
        this.nameFieldPanel.add(new JLabel(TLanguage.getString("TBoardDialog.BOARD_NAME")));
        this.nameTextField = new TIdTextField();
        this.nameFieldPanel.add(this.nameTextField);
        this.nameTextField.setText(this.getBoard().getBoardName());
    }

    private JPanel createPropertiesPanel() {
        JPanel propertiesPanel = new JPanel();
        GridBagConstraints c2 = new GridBagConstraints();
        propertiesPanel.setLayout(new GridBagLayout());
        this.createSizeChooser();
        this.createBackgroundSelectionPanel();
        this.createIconChooser();
        this.createSoundChooser();
        c2.fill = 2;
        c2.insets = new Insets(5, 10, 0, 10);
        c2.gridx = 0;
        c2.gridy = 0;
        propertiesPanel.add((Component)this.sizeChooser, c2);
        c2.fill = 2;
        c2.insets = new Insets(5, 10, 0, 10);
        c2.gridx = 0;
        c2.gridy = 1;
        propertiesPanel.add((Component)this.backgroundSelectionPanel, c2);
        c2.fill = 2;
        c2.insets = new Insets(5, 10, 0, 10);
        c2.gridx = 0;
        c2.gridy = 2;
        propertiesPanel.add((Component)this.soundChooser, c2);
        c2.fill = 2;
        c2.insets = new Insets(5, 10, 10, 10);
        c2.gridx = 0;
        c2.gridy = 3;
        propertiesPanel.add((Component)this.iconChooser, c2);
        return propertiesPanel;
    }

    private JPanel createOrderPanel() {
        Map map = ((TBoardModel)this.getBoard().getModel()).getAttributes();
        JPanel orderPanel = new JPanel();
        GridBagConstraints c2 = new GridBagConstraints();
        orderPanel.setLayout(new GridBagLayout());
        this.boardOrderPanel = new TBoardOrderPanel();
        c2.fill = 2;
        c2.insets = new Insets(5, 10, 10, 10);
        c2.gridx = 0;
        c2.gridy = 0;
        orderPanel.add((Component)this.boardOrderPanel, c2);
        this.boardOrderPanel.setUnorderedList(TBoardConstants.getUnorderedCellList(map));
        this.boardOrderPanel.setOrderedList(TBoardConstants.getOrderedCellList(map));
        return orderPanel;
    }

    private void createSizeChooser() {
        Map map = ((TBoardModel)this.getBoard().getModel()).getAttributes();
        this.sizeChooser = new TSizeChooser();
        this.sizeChooser.setSelectedSize(TBoardConstants.getSize(map));
    }

    private void createBackgroundSelectionPanel() {
        Map map = ((TBoardModel)this.getBoard().getModel()).getAttributes();
        this.backgroundSelectionPanel = new TBackgroundSelectionPanel(false);
        this.backgroundSelectionPanel.setBackgroundColor(TBoardConstants.getBackground(map));
        this.backgroundSelectionPanel.setGradientColor(TBoardConstants.getGradientColor(map));
    }

    private void createSoundChooser() {
        Map map = ((TBoardModel)this.getBoard().getModel()).getAttributes();
        this.soundChooser = new TSoundChooser();
        this.soundChooser.setSoundFilePath(TBoardConstants.getSoundFile(map));
    }

    private void createIconChooser() {
        Map map = ((TBoardModel)this.getBoard().getModel()).getAttributes();
        this.iconChooser = new TImageChooser(2, this.myEditor);
        this.iconChooser.setIcon((ImageIcon)TBoardConstants.getIcon(map));
        this.iconChooser.setResizeStyle(TBoardConstants.getImageResizeStyle(map));
    }

    @Override
    protected boolean applyValues() {
        Hashtable nested = new Hashtable();
        Hashtable attributeMap = new Hashtable();
        Vector<String> removalAttributes = new Vector<String>();
        String newName = this.nameTextField.getText();
        if (newName != null) {
            if (newName.equals("")) {
                JOptionPane.showMessageDialog(null, TLanguage.getString("TBoardDialog.ERROR_EMPTY_NAME"), String.valueOf(TLanguage.getString("WARNING")) + "!", 2);
                return false;
            }
            if (this.getBoardContainer().getEditor().getProject().isRepeatedName(this.getBoardContainer().getBoard(), newName)) {
                JOptionPane.showMessageDialog(null, TLanguage.getString("TBoardDialog.ERROR_REPEATED_NAME"), String.valueOf(TLanguage.getString("WARNING")) + "!", 2);
                return false;
            }
        }
        String oldBoardName = this.getBoard().getBoardName();
        this.getBoard().setBoardName(newName);
        int i2 = 0;
        while (i2 < this.myEditor.getBoardContainerCount()) {
            TBoardContainer boardContainer = this.myEditor.getBoardContainer(i2);
            CellView[] components = boardContainer.getBoard().getGraphLayoutCache().getCellViews();
            int j2 = 0;
            while (j2 < components.length) {
                TCell cell;
                AttributeMap cellAttributes;
                TComponentView view;
                if (components[j2] instanceof TComponentView && (view = (TComponentView)components[j2]) instanceof TCellView && TBoardConstants.getFollowingBoardName(cellAttributes = (cell = (TCell)view.getCell()).getAttributes()) != null && TBoardConstants.getFollowingBoardName(cellAttributes) == oldBoardName) {
                    TBoardConstants.setFollowingBoard(cellAttributes, newName);
                    cell.setAttributes(cellAttributes);
                }
                ++j2;
            }
            ++i2;
        }
        Dimension board_dimension = this.sizeChooser.getSelectedSize();
        TBoardConstants.setSize(attributeMap, board_dimension);
        TEditor.set_board_height(board_dimension.height);
        TEditor.set_board_width(board_dimension.width);
        Color background = this.backgroundSelectionPanel.getBackgroundColor();
        TEditor.set_board_background_color(background);
        if (background != null) {
            TBoardConstants.setBackground(attributeMap, background);
        } else {
            removalAttributes.add("backgroundColor");
        }
        String soundFile = this.soundChooser.getSoundFilePath();
        if (soundFile != null) {
            TBoardConstants.setSoundFile(attributeMap, soundFile);
        } else {
            removalAttributes.add("soundFile");
        }
        Color gradient = this.backgroundSelectionPanel.getGradientColor();
        TEditor.set_board_gradient_color(gradient);
        if (gradient != null) {
            TBoardConstants.setGradientColor(attributeMap, gradient);
        } else {
            removalAttributes.add("gradientColor");
        }
        ImageIcon icon = this.iconChooser.getIcon();
        if (icon != null) {
            TBoardConstants.setIcon(attributeMap, icon);
        } else {
            removalAttributes.add("icon");
        }
        TBoardConstants.setImageResizeStyle(attributeMap, this.iconChooser.getResizeStyle());
        TBoardConstants.setOrderedCellList(attributeMap, this.boardOrderPanel.getOrderedList());
        TBoardConstants.setUnorderedCellList(attributeMap, this.boardOrderPanel.getUnorderedList());
        TBoardConstants.setRemoveAttributes(attributeMap, removalAttributes.toArray());
        nested.put(this.getBoard().getModel(), attributeMap);
        if (!this.firstEdit) {
            this.getBoardContainer().getUndoManager().undo();
        }
        this.getBoard().getGraphLayoutCache().edit(nested);
        this.firstEdit = false;
        this.getBoard().updateUI();
        return true;
    }
}

