/*
 * Decompiled with CFR 0.152.
 */
package tico.editor.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import tico.board.TProject;
import tico.components.resources.ProjectFilter;
import tico.components.resources.TFileUtils;
import tico.configuration.TLanguage;
import tico.editor.TEditor;
import tico.editor.TProjectHandler;
import tico.editor.actions.TEditorAbstractAction;

public class TSoundSave
extends TEditorAbstractAction {
    private static File defaultDirectory = null;

    public TSoundSave(TEditor editor) {
        super(editor, TLanguage.getString("Guardar Fichero"));
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        File selectedFile = this.getEditor().getProjectFile();
        if (selectedFile == null) {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setDialogTitle(TLanguage.getString("TProjectSaveAction.SAVE_PROJECT"));
            fileChooser.setSelectedFile(new File(String.valueOf(this.getEditor().getProject().getName()) + "." + "tco"));
            fileChooser.setCurrentDirectory(defaultDirectory);
            fileChooser.addChoosableFileFilter(new ProjectFilter());
            fileChooser.setAcceptAllFileFilterUsed(false);
            int returnValue = fileChooser.showSaveDialog(null);
            if (returnValue == 0) {
                selectedFile = fileChooser.getSelectedFile();
                defaultDirectory = selectedFile.getParentFile();
                if ((selectedFile = new File(TFileUtils.setExtension(selectedFile.getAbsolutePath(), "tco"))).exists() && JOptionPane.showConfirmDialog(null, String.valueOf(TLanguage.getString("TProjectSaveAction.CHOOSE_FILE_EXISTS")) + "\n" + TLanguage.getString("TProjectSaveAction.CHOOSE_FILE_EXISTS_QUESTION"), TLanguage.getString("TProjectSaveAction.CHOOSE_FILE_OVERWRITE"), 0) == 1) {
                    return;
                }
            }
        }
        if (selectedFile != null) {
            try {
                this.getEditor().getProject().setName(TFileUtils.getFilename(selectedFile));
                TProject project = this.getEditor().getProject();
                TProjectHandler.saveProject(project, selectedFile);
                this.getEditor().setModified(false);
                this.getEditor().setProjectFile(selectedFile);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(null, TLanguage.getString("TProjectSaveAction.SAVE_ERROR"), String.valueOf(TLanguage.getString("ERROR")) + "!", 0);
            }
        }
    }
}

