/*
 * Decompiled with CFR 0.152.
 */
package tico.editor.actions;

import java.awt.event.ActionEvent;
import java.awt.geom.Rectangle2D;
import java.util.Hashtable;
import org.jgraph.graph.AttributeMap;
import tico.board.TBoardConstants;
import tico.board.components.TGrid;
import tico.board.components.TGridCell;
import tico.configuration.TLanguage;
import tico.editor.TEditor;
import tico.editor.actions.TEditorAbstractAction;

public class TReorderGridAction
extends TEditorAbstractAction {
    private TGrid grid;

    public TReorderGridAction(TEditor editor, TGrid grid) {
        super(editor, TLanguage.getString("TReorderGridAction.NAME"));
        this.grid = grid;
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        double cellVerticalGap;
        double cellHorizontalGap;
        Hashtable<TGridCell, AttributeMap> nested = new Hashtable<TGridCell, AttributeMap>();
        int rowsCount = this.grid.getRowsCount();
        int columnsCount = this.grid.getColumnsCount();
        Rectangle2D referenceBounds = TBoardConstants.getBounds(this.grid.getCell(1, 1).getAttributes());
        double cellWidth = referenceBounds.getWidth();
        double cellHeight = referenceBounds.getHeight();
        TGridCell followingRowCell = this.grid.getFollowingRowCell(1, 2);
        if (followingRowCell != null) {
            Rectangle2D followingRowBounds = TBoardConstants.getBounds(followingRowCell.getAttributes());
            cellHorizontalGap = followingRowBounds.getX() - (referenceBounds.getX() + referenceBounds.getWidth());
        } else {
            cellHorizontalGap = 10.0;
        }
        TGridCell followingColumnCell = this.grid.getFollowingColumnCell(1, 2);
        if (followingColumnCell != null) {
            Rectangle2D followingColumnBounds = TBoardConstants.getBounds(followingColumnCell.getAttributes());
            cellVerticalGap = followingColumnBounds.getY() - (referenceBounds.getY() + referenceBounds.getHeight());
        } else {
            cellVerticalGap = 10.0;
        }
        int row = 1;
        while (row <= rowsCount) {
            int col = 1;
            while (col <= columnsCount) {
                TGridCell currentCell = this.grid.getCell(row, col);
                if (currentCell != null) {
                    AttributeMap attributeMap = new AttributeMap();
                    TBoardConstants.setBounds(attributeMap, new Rectangle2D.Double(referenceBounds.getX() + (cellHorizontalGap + cellWidth) * (double)(col - 1), referenceBounds.getY() + (cellVerticalGap + cellHeight) * (double)(row - 1), cellWidth, cellHeight));
                    nested.put(currentCell, attributeMap);
                }
                ++col;
            }
            ++row;
        }
        this.getEditor().getCurrentBoard().getGraphLayoutCache().edit(nested);
    }
}

